/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConcurrentAutoloadTest
extends BaseJDBCTestCase {
    public ConcurrentAutoloadTest(String name) {
        super(name);
    }

    public void testConcurrentAutoloading() throws Exception {
        if (!TestConfiguration.loadingFromJars()) {
            return;
        }
        if (!JDBC.vmSupportsJDBC41()) {
            return;
        }
        TestConfiguration tc = this.getTestConfiguration();
        final String url = tc.getJDBCUrl() + ";create=true";
        final String user = tc.getUserName();
        final String pw = tc.getUserPassword();
        final List errors = Collections.synchronizedList(new ArrayList());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    DriverManager.getConnection(url, user, pw);
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
        };
        Thread t1 = new Thread(r);
        Thread t2 = new Thread(r);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (!errors.isEmpty()) {
            if (errors.size() > 1) {
                for (int i = 0; i < errors.size(); ++i) {
                    ConcurrentAutoloadTest.printStackTrace((Throwable)errors.get(i));
                }
            }
            ConcurrentAutoloadTest.fail("Thread failed", (Throwable)errors.get(0));
        }
    }
}

