/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.AuxObject;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.StorableFormatId;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BranchControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.btree.WaitError;
import org.apache.derby.impl.store.access.conglomerate.ConglomerateUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class ControlRow
implements AuxObject,
TypedFormat {
    private StorableFormatId version = null;
    private SQLLongint leftSiblingPageNumber;
    private SQLLongint rightSiblingPageNumber;
    private SQLLongint parentPageNumber;
    private SQLLongint level;
    private SQLLongint isRoot = null;
    private BTree btree = null;
    protected Page page;
    protected DataValueDescriptor[] row;
    protected DataValueDescriptor[] scratch_row;
    protected FetchDescriptor fetchDesc;
    protected transient boolean use_last_search_result_hint = false;
    protected transient int last_search_result = 0;
    protected static final int CR_COLID_FIRST = 0;
    protected static final int CR_VERSION_COLID = 0;
    protected static final int CR_LEFTSIB_COLID = 1;
    protected static final int CR_RIGHTSIB_COLID = 2;
    protected static final int CR_PARENT_COLID = 3;
    protected static final int CR_LEVEL_COLID = 4;
    protected static final int CR_ISROOT_COLID = 5;
    protected static final int CR_CONGLOM_COLID = 6;
    protected static final int CR_COLID_LAST = 6;
    protected static final int CR_NCOLUMNS = 7;
    protected static final FormatableBitSet CR_VERSION_BITSET = new FormatableBitSet(1);
    protected static final FormatableBitSet CR_LEFTSIB_BITSET = new FormatableBitSet(2);
    protected static final FormatableBitSet CR_RIGHTSIB_BITSET = new FormatableBitSet(3);
    protected static final FormatableBitSet CR_PARENT_BITSET = new FormatableBitSet(4);
    protected static final FormatableBitSet CR_LEVEL_BITSET = new FormatableBitSet(5);
    protected static final FormatableBitSet CR_ISROOT_BITSET = new FormatableBitSet(6);
    protected static final FormatableBitSet CR_CONGLOM_BITSET = new FormatableBitSet(7);
    public static final int SPLIT_FLAG_LAST_ON_PAGE = 1;
    public static final int SPLIT_FLAG_LAST_IN_TABLE = 2;
    public static final int SPLIT_FLAG_FIRST_ON_PAGE = 4;
    public static final int SPLIT_FLAG_FIRST_IN_TABLE = 8;
    protected static final int CR_SLOT = 0;

    protected ControlRow() {
        this.scratch_row = new DataValueDescriptor[this.getNumberOfControlRowColumns()];
        this.fetchDesc = new FetchDescriptor(this.scratch_row.length, null, null);
    }

    protected ControlRow(OpenBTree btree, Page page, int level, ControlRow parent, boolean isRoot) throws StandardException {
        SanityManager.ASSERT(page.isLatched());
        SanityManager.ASSERT(parent == null || parent.page.isLatched());
        this.page = page;
        this.leftSiblingPageNumber = new SQLLongint(-1L);
        this.rightSiblingPageNumber = new SQLLongint(-1L);
        this.parentPageNumber = new SQLLongint(parent == null ? -1L : parent.page.getPageNumber());
        this.isRoot = new SQLLongint(isRoot ? 1L : 0L);
        this.level = new SQLLongint(level);
        this.version = new StorableFormatId(this.getTypeFormatId());
        this.btree = isRoot ? btree.getConglomerate() : (BTree)Monitor.newInstanceFromIdentifier(btree.getConglomerate().getTypeFormatId());
        this.row = new DataValueDescriptor[this.getNumberOfControlRowColumns()];
        this.row[0] = this.version;
        this.row[1] = this.leftSiblingPageNumber;
        this.row[2] = this.rightSiblingPageNumber;
        this.row[3] = this.parentPageNumber;
        this.row[4] = this.level;
        this.row[5] = this.isRoot;
        this.row[6] = this.btree;
        page.setAuxObject(this);
    }

    protected ControlRow(ContainerHandle container, Page page) throws StandardException {
        System.out.println("ControlRow construct 2.");
        SanityManager.ASSERT(page.isLatched());
        this.page = page;
    }

    protected int getVersion() throws StandardException {
        if (this.version == null) {
            this.version = new StorableFormatId();
            this.scratch_row[0] = this.version;
            this.fetchDesc.setValidColumns(CR_VERSION_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.version.getValue();
    }

    protected void setVersion(int version) throws StandardException {
        if (this.version == null) {
            this.version = new StorableFormatId();
        }
        this.version.setValue(version);
        this.page.updateFieldAtSlot(0, 0, this.version, null);
    }

    public ControlRow getLeftSibling(OpenBTree btree) throws StandardException, WaitError {
        long pageno = this.getleftSiblingPageNumber();
        if (pageno == -1L) {
            return null;
        }
        ControlRow cr = ControlRow.getNoWait(btree, pageno);
        if (cr == null) {
            throw new WaitError();
        }
        return cr;
    }

    protected void setLeftSibling(ControlRow leftsib) throws StandardException {
        long left_sib_pageno;
        long l = left_sib_pageno = leftsib == null ? -1L : leftsib.page.getPageNumber();
        if (this.leftSiblingPageNumber == null) {
            this.leftSiblingPageNumber = new SQLLongint(left_sib_pageno);
        } else {
            this.leftSiblingPageNumber.setValue(left_sib_pageno);
        }
        try {
            this.page.updateFieldAtSlot(0, 1, this.leftSiblingPageNumber, null);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("setLeftSibling got an exception: control_row = " + this + "trying to update field number " + 1 + "to new value " + this.leftSiblingPageNumber, se);
            throw se;
        }
    }

    protected ControlRow getRightSibling(OpenBTree open_btree) throws StandardException {
        long pageno = this.getrightSiblingPageNumber();
        if (pageno == -1L) {
            return null;
        }
        return ControlRow.get(open_btree, pageno);
    }

    protected void setRightSibling(ControlRow rightsib) throws StandardException {
        long right_sib_pageno;
        long l = right_sib_pageno = rightsib == null ? -1L : rightsib.page.getPageNumber();
        if (this.rightSiblingPageNumber == null) {
            this.rightSiblingPageNumber = new SQLLongint(right_sib_pageno);
        } else {
            this.rightSiblingPageNumber.setValue(right_sib_pageno);
        }
        try {
            this.page.updateFieldAtSlot(0, 2, this.rightSiblingPageNumber, null);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("setRightSibling got an exception: control_row = " + this + "trying to update field number " + 2 + "to new value " + this.rightSiblingPageNumber, se);
            throw se;
        }
    }

    public long getleftSiblingPageNumber() throws StandardException {
        if (this.leftSiblingPageNumber == null) {
            this.leftSiblingPageNumber = new SQLLongint();
            SanityManager.ASSERT(this.scratch_row != null);
            this.scratch_row[1] = this.leftSiblingPageNumber;
            this.fetchDesc.setValidColumns(CR_LEFTSIB_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.leftSiblingPageNumber.getLong();
    }

    protected long getrightSiblingPageNumber() throws StandardException {
        if (this.rightSiblingPageNumber == null) {
            this.rightSiblingPageNumber = new SQLLongint();
            this.scratch_row[2] = this.rightSiblingPageNumber;
            this.fetchDesc.setValidColumns(CR_RIGHTSIB_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.rightSiblingPageNumber.getLong();
    }

    protected long getParentPageNumber() throws StandardException {
        if (this.parentPageNumber == null) {
            this.parentPageNumber = new SQLLongint();
            this.scratch_row[3] = this.parentPageNumber;
            this.fetchDesc.setValidColumns(CR_PARENT_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        long pageno = this.parentPageNumber.getLong();
        return pageno;
    }

    void setParent(long parent) throws StandardException {
        if (this.parentPageNumber == null) {
            this.parentPageNumber = new SQLLongint();
        }
        this.parentPageNumber.setValue(parent);
        try {
            this.page.updateFieldAtSlot(0, 3, this.parentPageNumber, null);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT("setParent got an exception: control_row = " + this + "trying to update field number " + 3 + "to new value " + this.parentPageNumber, se);
            throw se;
        }
    }

    protected int getLevel() throws StandardException {
        if (this.level == null) {
            this.level = new SQLLongint();
            this.scratch_row[4] = this.level;
            this.fetchDesc.setValidColumns(CR_LEVEL_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return (int)this.level.getLong();
    }

    protected void setLevel(int newlevel) throws StandardException {
        if (this.level == null) {
            this.level = new SQLLongint();
        }
        this.level.setValue((long)newlevel);
        this.page.updateFieldAtSlot(0, 4, this.level, null);
    }

    protected boolean getIsRoot() throws StandardException {
        if (this.isRoot == null) {
            this.isRoot = new SQLLongint();
            this.scratch_row[5] = this.isRoot;
            this.fetchDesc.setValidColumns(CR_ISROOT_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.isRoot.getLong() == 1L;
    }

    protected void setIsRoot(boolean isRoot) throws StandardException {
        if (this.isRoot == null) {
            this.isRoot = new SQLLongint();
        }
        this.isRoot.setValue(isRoot ? 1 : 0);
        this.page.updateFieldAtSlot(0, 5, this.isRoot, null);
    }

    public BTree getConglom(int format_id) throws StandardException {
        SanityManager.ASSERT(this.page.getPageNumber() == 1L && this.getIsRoot());
        if (this.btree == null) {
            this.btree = (BTree)Monitor.newInstanceFromIdentifier(format_id);
            this.scratch_row[6] = this.btree;
            this.fetchDesc.setValidColumns(CR_CONGLOM_BITSET);
            this.page.fetchFromSlot(null, 0, this.scratch_row, this.fetchDesc, false);
        }
        return this.btree;
    }

    public static ControlRow get(OpenBTree open_btree, long pageNumber) throws StandardException {
        return ControlRow.get(open_btree.container, pageNumber);
    }

    public static ControlRow get(ContainerHandle container, long pageNumber) throws StandardException {
        SanityManager.ASSERT(container != null, "ControlRow.Get() is being called on a closed container.");
        Page page = container.getPage(pageNumber);
        if (page == null) {
            SanityManager.THROWASSERT("No page at pagenumber: " + pageNumber + "; ContainerHandle = " + container);
        }
        return ControlRow.getControlRowForPage(container, page);
    }

    public static ControlRow getNoWait(OpenBTree open_btree, long pageNumber) throws StandardException {
        Page page = open_btree.container.getUserPageNoWait(pageNumber);
        if (page == null) {
            return null;
        }
        return ControlRow.getControlRowForPage(open_btree.container, page);
    }

    protected static ControlRow getControlRowForPage(ContainerHandle container, Page page) throws StandardException {
        ControlRow cr = null;
        AuxObject auxobject = page.getAuxObject();
        if (auxobject != null) {
            return (ControlRow)auxobject;
        }
        SanityManager.ASSERT(page.recordCount() >= 1);
        StorableFormatId version = new StorableFormatId();
        Object[] version_ret = new DataValueDescriptor[]{version};
        page.fetchFromSlot(null, 0, version_ret, new FetchDescriptor(1, CR_VERSION_BITSET, null), false);
        cr = (ControlRow)Monitor.newInstanceFromIdentifier(version.getValue());
        cr.page = page;
        cr.controlRowInit();
        page.setAuxObject(cr);
        return cr;
    }

    public void release() {
        SanityManager.ASSERT(this.page != null);
        if (this.page != null) {
            this.page.unlatch();
        }
    }

    protected void searchForEntry(SearchParameters params) throws StandardException {
        int midslot;
        int leftrange = 1;
        int rightrange = this.page.recordCount() - 1;
        int leftslot = 0;
        int rightslot = rightrange + 1;
        if (this.use_last_search_result_hint) {
            int n = midslot = this.last_search_result == 0 ? 1 : this.last_search_result;
            if (midslot > rightrange) {
                midslot = rightrange;
            }
        } else {
            midslot = (leftrange + rightrange) / 2;
        }
        if (leftslot != rightslot - 1 && (midslot < leftrange || midslot > rightrange)) {
            SanityManager.THROWASSERT("midslot = " + midslot + ";leftrange = " + leftrange + ";rightrange = " + rightrange);
        }
        while (leftslot != rightslot - 1) {
            int compare_ret = ControlRow.compareIndexRowFromPageToKey(this, midslot, params.template, params.searchKey, params.btree.getConglomerate().nUniqueColumns, params.partial_key_match_op, params.btree.getConglomerate().ascDescInfo);
            if (compare_ret == 0) {
                params.resultSlot = midslot;
                params.resultExact = true;
                this.use_last_search_result_hint = midslot == this.last_search_result;
                this.last_search_result = midslot;
                return;
            }
            if (compare_ret > 0) {
                rightslot = midslot;
                rightrange = midslot - 1;
            } else {
                leftslot = midslot;
                leftrange = midslot + 1;
            }
            midslot = (leftrange + rightrange) / 2;
        }
        this.use_last_search_result_hint = leftslot == this.last_search_result;
        this.last_search_result = leftslot;
        if (leftslot != rightslot - 1) {
            SanityManager.THROWASSERT("leftslot = " + leftslot + "; rightslot = " + rightslot);
        }
        params.resultSlot = leftslot;
        params.resultExact = false;
    }

    protected void searchForEntryBackward(SearchParameters params) throws StandardException {
        int midslot;
        int leftrange = 1;
        int rightrange = this.page.recordCount() - 1;
        int leftslot = 0;
        int rightslot = rightrange + 1;
        if (this.use_last_search_result_hint) {
            int n = midslot = this.last_search_result == 0 ? 1 : this.last_search_result;
            if (midslot > rightrange) {
                midslot = rightrange;
            }
        } else {
            midslot = (leftrange + rightrange) / 2;
        }
        if (leftslot != rightslot - 1 && (midslot < leftrange || midslot > rightrange)) {
            SanityManager.THROWASSERT("midslot = " + midslot + ";leftrange = " + leftrange + ";rightrange = " + rightrange);
        }
        while (leftslot != rightslot - 1) {
            int compare_ret = ControlRow.compareIndexRowFromPageToKey(this, midslot, params.template, params.searchKey, params.btree.getConglomerate().nUniqueColumns, params.partial_key_match_op, params.btree.getConglomerate().ascDescInfo);
            if (compare_ret == 0) {
                params.resultSlot = midslot;
                params.resultExact = true;
                this.use_last_search_result_hint = midslot == this.last_search_result;
                this.last_search_result = midslot;
                return;
            }
            if (compare_ret > 0) {
                rightslot = midslot;
                rightrange = midslot - 1;
            } else {
                leftslot = midslot;
                leftrange = midslot + 1;
            }
            midslot = (leftrange + rightrange) / 2;
        }
        this.use_last_search_result_hint = leftslot == this.last_search_result;
        this.last_search_result = leftslot;
        if (leftslot != rightslot - 1) {
            SanityManager.THROWASSERT("leftslot = " + leftslot + "; rightslot = " + rightslot);
        }
        params.resultSlot = leftslot;
        params.resultExact = false;
    }

    public static int compareIndexRowFromPageToKey(ControlRow indexpage, int slot, DataValueDescriptor[] indexrow, DataValueDescriptor[] key, int nCompareCols, int partialKeyOrder, boolean[] ascOrDesc) throws StandardException {
        int partialKeyCols = key.length;
        indexpage.page.fetchFromSlot(null, slot, indexrow, null, true);
        for (int i = 0; i < nCompareCols; ++i) {
            if (i >= partialKeyCols) {
                return partialKeyOrder;
            }
            int r = indexrow[i].compare(key[i]);
            if (r == 0) continue;
            if (ascOrDesc[i]) {
                return r;
            }
            return -r;
        }
        return 0;
    }

    public static int compareIndexRowToKey(DataValueDescriptor[] indexrow, DataValueDescriptor[] key, int nCompareCols, int partialKeyOrder, boolean[] ascOrDesc) throws StandardException {
        int partialKeyCols = key.length;
        for (int i = 0; i < nCompareCols; ++i) {
            if (i >= partialKeyCols) {
                return partialKeyOrder;
            }
            DataValueDescriptor indexcol = indexrow[i];
            DataValueDescriptor keycol = key[i];
            int r = indexcol.compare(keycol);
            if (r == 0) continue;
            if (ascOrDesc[i]) {
                return r;
            }
            return -r;
        }
        return 0;
    }

    protected void checkGeneric(OpenBTree btree, ControlRow parent, boolean check_other_pages) throws StandardException {
        SanityManager.ASSERT(this.page.recordCount() >= 1);
        SanityManager.ASSERT(!this.page.isDeletedAtSlot(0));
        if (parent != null && parent.page.getPageNumber() != this.getParentPageNumber()) {
            SanityManager.THROWASSERT(this + " not child of " + parent);
        }
        if (parent != null && parent.getLevel() != this.getLevel() + 1) {
            SanityManager.THROWASSERT(this + " at wrong level when compared to parent:" + parent);
        }
        this.checkRowOrder(btree, parent);
        if (check_other_pages) {
            this.checkSiblings(btree);
        }
    }

    protected boolean checkRowOrder(OpenBTree btree, ControlRow parent) throws StandardException {
        RecordHandle lesser_handle = null;
        RecordHandle greater_handle = null;
        Object[] lesser = this.getRowTemplate(btree);
        Object[] greater = this.getRowTemplate(btree);
        boolean is_consistent = true;
        int numslots = this.page.recordCount();
        int i = 1;
        while (i + 1 < numslots) {
            lesser_handle = this.page.fetchFromSlot(null, i, lesser, null, true);
            greater_handle = this.page.fetchFromSlot(null, i + 1, greater, null, true);
            SanityManager.ASSERT(btree.getConglomerate().nUniqueColumns <= btree.getConglomerate().nKeyFields);
            int compare_result = ControlRow.compareIndexRowToKey((DataValueDescriptor[])lesser, (DataValueDescriptor[])greater, btree.getConglomerate().nUniqueColumns, 0, btree.getConglomerate().ascDescInfo);
            if (compare_result >= 0) {
                SanityManager.THROWASSERT("Bad order of rows found in conglomerate: " + btree + "\n.compare result = " + compare_result + ".  nKeyFields = " + btree.getConglomerate().nKeyFields + ".\n" + this + " rows " + i + " and " + (i + 1) + " out of order.\nrow[" + i + "] + " + RowUtil.toString(lesser) + "\nrow[" + (i + 1) + "] + " + RowUtil.toString(greater) + "\ndump of page = " + this.debugPage(btree) + "\ndump of parent page = " + (parent != null ? parent.debugPage(btree) : "null parent") + "\rawstore dump = " + this.page);
                is_consistent = false;
            }
            ++i;
        }
        return is_consistent;
    }

    protected boolean compareRowsOnSiblings(OpenBTree btree, ControlRow left_sib, ControlRow right_sib) throws StandardException {
        boolean is_consistent = true;
        if (left_sib.page.recordCount() > 1 && right_sib.page.recordCount() > 1) {
            Object[] left_lastrow = this.getRowTemplate(btree);
            Object[] right_firstrow = this.getRowTemplate(btree);
            RecordHandle left_lastrow_handle = left_sib.page.fetchFromSlot(null, left_sib.page.recordCount() - 1, left_lastrow, null, true);
            RecordHandle right_firstrow_handle = right_sib.page.fetchFromSlot(null, 1, right_firstrow, null, true);
            int r = ControlRow.compareIndexRowToKey((DataValueDescriptor[])left_lastrow, (DataValueDescriptor[])right_firstrow, btree.getConglomerate().nUniqueColumns, 0, btree.getConglomerate().ascDescInfo);
            if (r >= 0) {
                SanityManager.THROWASSERT("last row on left page " + left_sib.page.getPageNumber() + " > than first row on right page " + right_sib.page.getPageNumber() + "\nleft last row = " + RowUtil.toString(left_lastrow) + "right first row = " + RowUtil.toString(right_firstrow) + left_sib + " last > first of " + right_sib);
                is_consistent = false;
            }
        }
        return is_consistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSiblings(OpenBTree btree) throws StandardException {
        ControlRow leftsib = null;
        ControlRow rightsib = null;
        try {
            try {
                leftsib = this.getLeftSibling(btree);
            }
            catch (WaitError e) {
                leftsib = null;
            }
            if (leftsib != null) {
                long hopefullythis_pageno;
                if (leftsib.getLevel() != this.getLevel()) {
                    SanityManager.THROWASSERT(leftsib + "not at same level as " + this);
                }
                if ((hopefullythis_pageno = leftsib.getrightSiblingPageNumber()) != this.page.getPageNumber()) {
                    SanityManager.THROWASSERT("right sibling of " + leftsib + " isn't " + this);
                }
                this.compareRowsOnSiblings(btree, leftsib, this);
                leftsib.release();
                leftsib = null;
            }
            if ((rightsib = this.getRightSibling(btree)) != null) {
                long hopefullythis_pageno;
                if (rightsib.getLevel() != this.getLevel()) {
                    SanityManager.THROWASSERT(rightsib + "not at same level as " + this);
                }
                if ((hopefullythis_pageno = rightsib.getleftSiblingPageNumber()) != this.page.getPageNumber()) {
                    SanityManager.THROWASSERT("left sibling of " + rightsib + " isn't " + this);
                }
                this.compareRowsOnSiblings(btree, this, rightsib);
                rightsib.release();
                rightsib = null;
            }
        }
        finally {
            if (leftsib != null) {
                leftsib.release();
            }
            if (rightsib != null) {
                rightsib.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void linkRight(OpenBTree btree, ControlRow target) throws StandardException {
        ControlRow rightSibling = null;
        try {
            rightSibling = target.getRightSibling(btree);
            this.setRightSibling(rightSibling);
            this.setLeftSibling(target);
            if (rightSibling != null) {
                rightSibling.setLeftSibling(this);
            }
            target.setRightSibling(this);
        }
        finally {
            if (rightSibling != null) {
                rightSibling.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlink(OpenBTree btree) throws StandardException {
        ControlRow leftsib = null;
        ControlRow rightsib = null;
        try {
            try {
                leftsib = this.getLeftSibling(btree);
            }
            catch (WaitError e) {
                boolean bl = false;
                if (leftsib != null) {
                    leftsib.release();
                }
                if (rightsib != null) {
                    rightsib.release();
                }
                return bl;
            }
            rightsib = this.getRightSibling(btree);
            if (leftsib != null) {
                leftsib.setRightSibling(rightsib);
            }
            if (rightsib != null) {
                rightsib.setLeftSibling(leftsib);
            }
            btree.container.removePage(this.page);
            SanityManager.ASSERT(!this.page.isLatched());
            boolean bl = true;
            return bl;
        }
        finally {
            if (leftsib != null) {
                leftsib.release();
            }
            if (rightsib != null) {
                rightsib.release();
            }
        }
    }

    public Page getPage() {
        return this.page;
    }

    protected final DataValueDescriptor[] getRow() {
        return this.row;
    }

    protected abstract int checkConsistency(OpenBTree var1, ControlRow var2, boolean var3) throws StandardException;

    protected abstract ControlRow getLeftChild(OpenBTree var1) throws StandardException;

    protected abstract ControlRow getRightChild(OpenBTree var1) throws StandardException;

    protected abstract void controlRowInit();

    public abstract boolean isLeftmostLeaf() throws StandardException;

    public abstract boolean isRightmostLeaf() throws StandardException;

    public abstract ControlRow search(SearchParameters var1) throws StandardException;

    protected abstract int getNumberOfControlRowColumns();

    protected abstract ControlRow searchLeft(OpenBTree var1) throws StandardException;

    protected abstract ControlRow searchRight(OpenBTree var1) throws StandardException;

    protected abstract boolean shrinkFor(OpenBTree var1, DataValueDescriptor[] var2) throws StandardException;

    protected abstract long splitFor(OpenBTree var1, DataValueDescriptor[] var2, BranchControlRow var3, DataValueDescriptor[] var4, int var5) throws StandardException;

    public abstract void printTree(OpenBTree var1) throws StandardException;

    @Override
    public void auxObjectInvalidated() {
        this.version = null;
        this.leftSiblingPageNumber = null;
        this.rightSiblingPageNumber = null;
        this.parentPageNumber = null;
        this.level = null;
        this.isRoot = null;
        this.page = null;
    }

    public DataValueDescriptor[] getRowTemplate(OpenBTree open_btree) throws StandardException {
        return open_btree.getConglomerate().createTemplate(open_btree.getRawTran());
    }

    public String debugPage(OpenBTree open_btree) throws StandardException {
        StringBuffer string = new StringBuffer(4096);
        string.append(this.toString());
        string.append("\n");
        DataValueDescriptor[] row = this.getRowTemplate(open_btree);
        string.append(ConglomerateUtil.debugPage(this.page, 1, false, row));
        String ret_str = string.toString();
        return ret_str;
    }

    public String toString() {
        StringBuffer string = new StringBuffer(4096);
        try {
            string.append(this.getLevel() == 0 ? "\nLEAF" : "\nBRANCH");
            string.append(this.getIsRoot() ? "-ROOT" : "");
            string.append("(");
            string.append(this.page.getPageNumber());
            string.append(")(lev=");
            string.append(this.level);
            string.append("): num recs = ");
            string.append(this.page.recordCount());
            string.append("\n");
            string.append("\t");
            string.append("left = ");
            string.append(this.getleftSiblingPageNumber());
            string.append(";");
            string.append("right = ");
            string.append(this.getrightSiblingPageNumber());
            string.append(";");
            string.append("parent = ");
            string.append(this.getParentPageNumber());
            string.append(";");
            string.append("isRoot = ");
            string.append(this.getIsRoot());
            string.append(";");
        }
        catch (Throwable t) {
            string.append("error encountered while doing ControlRow.toString()");
        }
        return string.toString();
    }

    static {
        CR_VERSION_BITSET.set(0);
        CR_LEFTSIB_BITSET.set(1);
        CR_RIGHTSIB_BITSET.set(2);
        CR_PARENT_BITSET.set(3);
        CR_LEVEL_BITSET.set(4);
        CR_ISROOT_BITSET.set(5);
        CR_CONGLOM_BITSET.set(6);
    }
}

