/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.shared.common.sanity.SanityManager;

class FromList
extends QueryTreeNodeVector<ResultSetNode>
implements OptimizableList {
    Properties properties;
    boolean fixedJoinOrder = true;
    boolean useStatistics = true;
    private boolean referencesSessionSchema;
    private boolean isTransparent;
    private WindowList windows;

    FromList(ContextManager cm) {
        super(ResultSetNode.class, cm);
        this.isTransparent = false;
    }

    FromList(boolean optimizeJoinOrder, ContextManager cm) {
        super(ResultSetNode.class, cm);
        this.constructorMinion(optimizeJoinOrder);
    }

    FromList(boolean optimizeJoinOrder, FromTable fromTable, ContextManager cm) throws StandardException {
        super(ResultSetNode.class, cm);
        this.constructorMinion(optimizeJoinOrder);
        this.addFromTable(fromTable);
    }

    private void constructorMinion(boolean optimizeJoinOrder) {
        this.fixedJoinOrder = !optimizeJoinOrder;
        this.isTransparent = false;
    }

    @Override
    public Optimizable getOptimizable(int index) {
        return (Optimizable)this.elementAt(index);
    }

    @Override
    public void setOptimizable(int index, Optimizable optimizable) {
        this.setElementAt((FromTable)optimizable, index);
    }

    @Override
    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((Optimizable)this.elementAt(index)).verifyProperties(dDictionary);
        }
    }

    final void addFromTable(FromTable fromTable) throws StandardException {
        if (!(fromTable instanceof TableOperatorNode)) {
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                TableName rightTable;
                TableName leftTable = fromTable.getTableName();
                if ((FromTable)this.elementAt(index) instanceof TableOperatorNode || !leftTable.equals(rightTable = ((FromTable)this.elementAt(index)).getTableName())) continue;
                throw StandardException.newException("42X09", fromTable.getExposedName());
            }
        }
        this.addElement(fromTable);
    }

    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        boolean found = false;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!fromTable.referencesTarget(name, baseTable)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        boolean found = false;
        if (this.referencesSessionSchema) {
            return true;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!fromTable.referencesSessionSchema()) continue;
            found = true;
            break;
        }
        return found;
    }

    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        FromTable result = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            result = fromTable.getFromTableByName(name, schemaName, exactMatch);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    void isJoinColumnForRightOuterJoin(ResultColumn rc) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.isJoinColumnForRightOuterJoin(rc);
        }
    }

    void bindTables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        FromTable newNode;
        FromTable fromTable;
        int index;
        boolean wasSkippingTypePrivileges = this.getCompilerContext().skipTypePrivileges(true);
        int size = this.size();
        for (index = 0; index < size; ++index) {
            fromTable = (FromTable)this.elementAt(index);
            newNode = (FromTable)fromTable.bindNonVTITables(dataDictionary, fromListParam);
            if (fromTable.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            newNode.setMergeTableID(fromTable.getMergeTableID());
            this.setElementAt(newNode, index);
        }
        for (index = 0; index < size; ++index) {
            fromTable = (FromTable)this.elementAt(index);
            newNode = (FromTable)fromTable.bindVTITables(fromListParam);
            if (fromTable.referencesSessionSchema()) {
                this.referencesSessionSchema = true;
            }
            newNode.setMergeTableID(fromTable.getMergeTableID());
            this.setElementAt(newNode, index);
        }
        CompilerContext cc = this.getCompilerContext();
        cc.pushCurrentPrivType(8);
        for (int index2 = 0; index2 < size; ++index2) {
            fromTable = (FromTable)this.elementAt(index2);
            if (!fromTable.isPrivilegeCollectionRequired() || !fromTable.isBaseTable() || fromTable.forUpdate()) continue;
            cc.addRequiredColumnPriv(fromTable.getTableDescriptor().getColumnDescriptor(1));
        }
        cc.popCurrentPrivType();
        this.getCompilerContext().skipTypePrivileges(wasSkippingTypePrivileges);
    }

    void bindExpressions(FromList fromListParam) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.bindExpressions(this.isTransparent ? fromListParam : this);
        }
    }

    void bindResultColumns(FromList fromListParam) throws StandardException {
        int origList = fromListParam.size();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (fromTable.needsSpecialRCLBinding()) {
                fromTable.bindResultColumns(fromListParam);
            }
            fromListParam.insertElementAt(fromTable, 0);
        }
        while (fromListParam.size() > origList) {
            fromListParam.removeElementAt(0);
        }
    }

    ResultColumnList expandAll(TableName allTableName) throws StandardException {
        FromTable fromTable;
        ResultColumnList resultColumnList = null;
        boolean matchfound = false;
        int targetNestingLevel = ((FromTable)this.elementAt(0)).getLevel();
        int size = this.size();
        int prevNL = targetNestingLevel;
        for (int i = 1; i < size; ++i) {
            int currNL = ((FromTable)this.elementAt(i)).getLevel();
            SanityManager.ASSERT(prevNL >= currNL, "FROM list should have been ordered by nesting level (deepest level first), but it was not.");
            prevNL = currNL;
        }
        for (int index = 0; index < size && targetNestingLevel == (fromTable = (FromTable)this.elementAt(index)).getLevel(); ++index) {
            ResultColumnList tempRCList = fromTable.getAllResultColumns(allTableName);
            if (tempRCList == null) continue;
            if (resultColumnList == null) {
                resultColumnList = tempRCList;
            } else {
                resultColumnList.nondestructiveAppend(tempRCList);
            }
            if (allTableName == null) continue;
            matchfound = true;
        }
        if (resultColumnList == null) {
            throw StandardException.newException("42X10", allTableName);
        }
        return resultColumnList;
    }

    ResultColumn bindColumnReference(ColumnReference columnReference) throws StandardException {
        boolean columnNameMatch = false;
        boolean tableNameMatch = false;
        FromTable fromTable = null;
        FromTable matchingTable = null;
        int previousLevel = -1;
        ResultColumn matchingRC = null;
        String crTableName = columnReference.getTableName();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            fromTable = (FromTable)this.elementAt(index);
            if (fromTable.getMergeTableID() != 0 && columnReference.getMergeTableID() != 0 && fromTable.getMergeTableID() != columnReference.getMergeTableID()) continue;
            int currentLevel = fromTable.getLevel();
            if (previousLevel != currentLevel && (columnNameMatch || tableNameMatch)) break;
            previousLevel = currentLevel;
            ResultColumn resultColumn = fromTable.getMatchingColumn(columnReference);
            if (resultColumn != null) {
                if (!columnNameMatch) {
                    matchingRC = resultColumn;
                    columnReference.setSource(resultColumn);
                    columnReference.setNestingLevel(((FromTable)this.elementAt(0)).getLevel());
                    columnReference.setSourceLevel(currentLevel);
                    columnNameMatch = true;
                    if (fromTable.isPrivilegeCollectionRequired()) {
                        this.getCompilerContext().addRequiredColumnPriv(resultColumn.getTableColumnDescriptor());
                    }
                    matchingTable = fromTable;
                } else {
                    throw StandardException.newException("42X03", columnReference.getSQLColumnName());
                }
            }
            tableNameMatch = tableNameMatch || crTableName != null && crTableName.equals(fromTable.getExposedName());
        }
        if (matchingTable != null && matchingRC != null && columnReference.getTableName() == null) {
            FromBaseTable fbt;
            TableName crtn = matchingTable.getTableName();
            if (matchingTable instanceof FromBaseTable && (fbt = (FromBaseTable)matchingTable).getExposedTableName() != null) {
                crtn = fbt.getExposedTableName();
            }
            columnReference.setQualifiedTableName(crtn);
        }
        return matchingRC;
    }

    void rejectParameters() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.rejectParameters();
        }
    }

    boolean LOJ_reorderable(int numTables) throws StandardException {
        boolean anyChange = false;
        if (this.size() > 1) {
            return anyChange;
        }
        FromTable ft = (FromTable)this.elementAt(0);
        anyChange = ft.LOJ_reorderable(numTables);
        return anyChange;
    }

    void preprocess(int numTables, GroupByList gbl, ValueNode predicateTree) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            ft = ft.transformOuterJoins(predicateTree, numTables);
            this.setElementAt(ft.preprocess(numTables, gbl, this), index);
        }
    }

    void flattenFromTables(ResultColumnList rcl, PredicateList predicateList, SubqueryList sql, GroupByList gbl, ValueNode havingClause) throws StandardException {
        FromTable ft;
        boolean flattened = true;
        ArrayList<Integer> flattenedTableNumbers = new ArrayList<Integer>();
        SanityManager.ASSERT(rcl != null, "rcl is expected to be non-null");
        SanityManager.ASSERT(predicateList != null, "predicateList is expected to be non-null");
        SanityManager.ASSERT(sql != null, "sql is expected to be non-null");
        while (flattened) {
            flattened = false;
            for (int index = 0; index < this.size() && !flattened; ++index) {
                ft = (FromTable)this.elementAt(index);
                if (!(ft instanceof FromSubquery) && !ft.isFlattenableJoinNode()) continue;
                flattenedTableNumbers.add(ft.getTableNumber());
                FromList flatteningFL = ft.flatten(rcl, predicateList, sql, gbl, havingClause);
                SanityManager.ASSERT(flatteningFL == null || flatteningFL.size() > 0, "flatteningFL expected to be null or size > 0");
                if (flatteningFL != null) {
                    this.setElementAt(flatteningFL.elementAt(0), index);
                    int innerSize = flatteningFL.size();
                    for (int inner = 1; inner < innerSize; ++inner) {
                        this.insertElementAt(flatteningFL.elementAt(inner), index + inner);
                    }
                } else {
                    this.removeElementAt(index);
                }
                flattened = true;
            }
        }
        if (!flattenedTableNumbers.isEmpty()) {
            for (int i = 0; i < this.size(); ++i) {
                ResultSetNode rst;
                ft = (FromTable)this.elementAt(i);
                if (!(ft instanceof ProjectRestrictNode) || !((rst = ((ProjectRestrictNode)ft).getChildResult()) instanceof FromBaseTable)) continue;
                ((FromBaseTable)rst).clearDependency(flattenedTableNumbers);
            }
        }
    }

    void pushPredicates(PredicateList predicateList) throws StandardException {
        SanityManager.ASSERT(predicateList != null, "predicateList is expected to be non-null");
        predicateList.categorize();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.pushExpressions(predicateList);
        }
    }

    void setLevel(int level) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.setLevel(level);
        }
    }

    FromTable getFromTableByResultColumn(ResultColumn rc) {
        FromTable fromTable = null;
        int size = this.size();
        for (int index = 0; index < size && (fromTable = (FromTable)this.elementAt(index)).getResultColumns().indexOf(rc) == -1; ++index) {
        }
        SanityManager.ASSERT(fromTable != null, "No matching FromTable found");
        return fromTable;
    }

    void setProperties(Properties props) throws StandardException {
        this.properties = props;
        Enumeration<Object> e = this.properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.properties.get(key);
            if (key.equals("joinOrder")) {
                if (StringUtil.SQLEqualsIgnoreCase(value, "fixed")) {
                    this.fixedJoinOrder = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(value, "unfixed")) {
                    this.fixedJoinOrder = false;
                    continue;
                }
                throw StandardException.newException("42X17", value);
            }
            if (key.equals("useStatistics")) {
                if (StringUtil.SQLEqualsIgnoreCase(value, "true")) {
                    this.useStatistics = true;
                    continue;
                }
                if (StringUtil.SQLEqualsIgnoreCase(value, "false")) {
                    this.useStatistics = false;
                    continue;
                }
                throw StandardException.newException("42X64", value);
            }
            throw StandardException.newException("42X41", key, value);
        }
    }

    @Override
    public void reOrder(int[] joinOrder) {
        int posn;
        if (joinOrder.length != this.size()) {
            SanityManager.THROWASSERT("In reOrder(), size of FromList is " + this.size() + " while size of joinOrder array is " + joinOrder.length);
        }
        int sum = 0;
        for (int i = 0; i < joinOrder.length; ++i) {
            if (joinOrder[i] < 0 || joinOrder[i] > joinOrder.length - 1) {
                SanityManager.THROWASSERT("joinOrder[" + i + "] == " + joinOrder[i] + " is out of range - must be between 0 and " + (joinOrder.length - 1) + " inclusive.");
            }
            sum += joinOrder[i];
        }
        if (sum != joinOrder.length * (joinOrder.length - 1) / 2) {
            StringBuilder arrayVals = new StringBuilder();
            for (int i : joinOrder) {
                arrayVals.append(i);
                arrayVals.append(' ');
            }
            SanityManager.THROWASSERT("joinOrder array has some duplicate value: " + arrayVals);
        }
        FromTable[] orderedFL = new FromTable[joinOrder.length];
        for (posn = 0; posn < joinOrder.length; ++posn) {
            orderedFL[posn] = (ResultSetNode)this.elementAt(joinOrder[posn]);
        }
        for (posn = 0; posn < joinOrder.length; ++posn) {
            this.setElementAt(orderedFL[posn], posn);
        }
    }

    @Override
    public boolean useStatistics() {
        return this.useStatistics;
    }

    @Override
    public boolean optimizeJoinOrder() {
        return !this.fixedJoinOrder;
    }

    @Override
    public boolean legalJoinOrder(int numTablesInQuery) {
        JBitSet assignedTableMap = new JBitSet(numTablesInQuery);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            assignedTableMap.or(ft.getReferencedTableMap());
            if (ft.legalJoinOrder(assignedTableMap)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            ft.initAccessPaths(optimizer);
        }
    }

    void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.bindUntypedNullsToResultColumns(bindingRCL);
        }
    }

    void decrementLevel(int decrement) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            fromTable.decrementLevel(decrement);
            ProjectRestrictNode prn = (ProjectRestrictNode)fromTable;
            PredicateList pl = prn.getRestrictionList();
            if (pl == null) continue;
            pl.decrementLevel(this, decrement);
        }
    }

    boolean returnsAtMostSingleRow(ResultColumnList rcl, ValueNode whereClause, PredicateList wherePredicates, DataDictionary dd) throws StandardException {
        ResultColumn rc;
        boolean satisfiesOuter = false;
        ColumnReference additionalCR = null;
        PredicateList predicatesTemp = new PredicateList(this.getContextManager());
        for (Predicate p : wherePredicates) {
            predicatesTemp.addPredicate(p);
        }
        if (rcl != null && (rc = (ResultColumn)rcl.elementAt(0)).getExpression() instanceof ColumnReference) {
            additionalCR = (ColumnReference)rc.getExpression();
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!(fromTable instanceof ProjectRestrictNode)) {
                return false;
            }
            ProjectRestrictNode prn = (ProjectRestrictNode)fromTable;
            if (!(prn.getChildResult() instanceof FromBaseTable)) {
                return false;
            }
            FromBaseTable fbt = (FromBaseTable)prn.getChildResult();
            if (!fbt.getExistsBaseTable()) continue;
            int existsTableNumber = fbt.getTableNumber();
            block2: for (int i = predicatesTemp.size() - 1; i >= 0; --i) {
                AndNode topAndNode;
                ValueNode whereWalker = topAndNode = ((Predicate)predicatesTemp.elementAt(i)).getAndNode();
                while (whereWalker instanceof AndNode) {
                    JBitSet referencedTables;
                    AndNode and = whereWalker;
                    if (and.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)and.getLeftOperand())).getOperator() == 1 && (referencedTables = and.getLeftOperand().getTablesReferenced()).get(existsTableNumber)) {
                        predicatesTemp.removeElementAt(i);
                        continue block2;
                    }
                    whereWalker = whereWalker.getRightOperand();
                }
            }
        }
        int[] tableNumbers = this.getTableNumbers();
        JBitSet[][] tableColMap = new JBitSet[size][size];
        boolean[] oneRow = new boolean[size];
        for (int index = 0; index < size; ++index) {
            ProjectRestrictNode prn = (ProjectRestrictNode)this.elementAt(index);
            FromBaseTable fbt = (FromBaseTable)prn.getChildResult();
            if (fbt.getExistsBaseTable()) {
                oneRow[index] = true;
                continue;
            }
            int numColumns = fbt.getTableDescriptor().getNumberOfColumns();
            boolean[] eqOuterCols = new boolean[numColumns + 1];
            int tableNumber = fbt.getTableNumber();
            boolean resultColTable = false;
            for (int i = 0; i < size; ++i) {
                tableColMap[index][i] = new JBitSet(numColumns + 1);
            }
            if (additionalCR != null && additionalCR.getTableNumber() == tableNumber) {
                rcl.recordColumnReferences(eqOuterCols, tableColMap[index], index);
                resultColTable = true;
            }
            if (whereClause != null) {
                whereClause.checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap[index], resultColTable);
            }
            predicatesTemp.checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap[index], resultColTable);
            if (prn.getRestrictionList() != null) {
                prn.getRestrictionList().checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap[index], resultColTable);
            }
            if (!fbt.supersetOfUniqueIndex(tableColMap[index])) {
                return false;
            }
            boolean oneRowResult = fbt.supersetOfUniqueIndex(eqOuterCols);
            if (!oneRowResult) continue;
            oneRow[index] = true;
            satisfiesOuter = true;
        }
        if (satisfiesOuter) {
            boolean foundOneRow = true;
            while (foundOneRow) {
                foundOneRow = false;
                for (int index = 0; index < size; ++index) {
                    if (!oneRow[index]) continue;
                    for (int i = 0; i < size; ++i) {
                        if (oneRow[i] || !tableColMap[i][index].get(0)) continue;
                        oneRow[i] = true;
                        foundOneRow = true;
                    }
                }
            }
            for (int index = 0; index < size; ++index) {
                if (oneRow[index]) continue;
                satisfiesOuter = false;
                break;
            }
        }
        return satisfiesOuter;
    }

    int[] getTableNumbers() {
        int size = this.size();
        int[] tableNumbers = new int[size];
        for (int index = 0; index < size; ++index) {
            ProjectRestrictNode prn = (ProjectRestrictNode)this.elementAt(index);
            if (!(prn.getChildResult() instanceof FromTable)) continue;
            FromTable ft = (FromTable)prn.getChildResult();
            tableNumbers[index] = ft.getTableNumber();
        }
        return tableNumbers;
    }

    void genExistsBaseTables(JBitSet referencedTableMap, FromList outerFromList, boolean isNotExists) throws StandardException {
        int index;
        JBitSet dependencyMap = (JBitSet)referencedTableMap.clone();
        if (this.size() != 1) {
            SanityManager.THROWASSERT("size() expected to be 1, not " + this.size());
        }
        int size = this.size();
        for (index = 0; index < size; ++index) {
            ResultSetNode ft = ((ProjectRestrictNode)this.elementAt(index)).getChildResult();
            if (!(ft instanceof FromTable)) continue;
            dependencyMap.clear(((FromTable)ft).getTableNumber());
        }
        if (dependencyMap.getFirstSetBit() == -1) {
            int outerSize = outerFromList.size();
            for (int outer = 0; outer < outerSize; ++outer) {
                dependencyMap.or(((FromTable)outerFromList.elementAt(outer)).getReferencedTableMap());
            }
        }
        for (index = 0; index < size; ++index) {
            ProjectRestrictNode prn;
            FromTable fromTable = (FromTable)this.elementAt(index);
            if (!(fromTable instanceof ProjectRestrictNode) || !((prn = (ProjectRestrictNode)fromTable).getChildResult() instanceof FromBaseTable)) continue;
            FromBaseTable fbt = (FromBaseTable)prn.getChildResult();
            fbt.setExistsBaseTable(true, (JBitSet)dependencyMap.clone(), isNotExists);
        }
    }

    boolean tableNumberIsNotExists(int tableNumber) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft;
            ProjectRestrictNode prn = (ProjectRestrictNode)this.elementAt(index);
            if (!(prn.getChildResult() instanceof FromTable) || (ft = (FromTable)prn.getChildResult()).getTableNumber() != tableNumber) continue;
            return ft.isNotExists();
        }
        return false;
    }

    int updateTargetLockMode() {
        if (this.size() != 1) {
            SanityManager.THROWASSERT("size() is " + this.size() + " but should be 1");
        }
        return ((ResultSetNode)this.elementAt(0)).updateTargetLockMode();
    }

    boolean hashJoinSpecified() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            FromTable ft = (FromTable)this.elementAt(index);
            String joinStrategy = ft.getUserSpecifiedJoinStrategy();
            if (joinStrategy == null || !StringUtil.SQLToUpperCase(joinStrategy).equals("HASH")) continue;
            return true;
        }
        return false;
    }

    void markAsTransparent() {
        this.isTransparent = true;
    }

    void setWindows(WindowList windows) {
        this.windows = windows;
    }

    WindowList getWindows() {
        return this.windows;
    }
}

