/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Hashtable;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DateTime;
import org.apache.derby.client.am.DateTimeValue;
import org.apache.derby.client.am.Decimal;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.EncodedInputStream;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.PublicBufferOutputStream;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

class Request {
    protected ByteBuffer buffer;
    private static final int MAX_MARKS_NESTING = 10;
    private int[] markStack_ = new int[10];
    private int top_ = 0;
    private int dssLengthLocation_ = 0;
    private int correlationID_ = 0;
    private boolean simpleDssFinalize = false;
    protected boolean passwordIncluded_ = false;
    protected int passwordStart_ = 0;
    protected int passwordLength_ = 0;
    protected NetAgent netAgent_;

    Request(NetAgent netAgent, int minSize) {
        this.netAgent_ = netAgent;
        this.buffer = ByteBuffer.allocate(minSize);
        this.clearBuffer();
    }

    private final void clearBuffer() {
        this.buffer.clear();
        this.top_ = 0;
        for (int i = 0; i < this.markStack_.length && this.markStack_[i] != 0; ++i) {
            this.markStack_[i] = 0;
        }
        this.dssLengthLocation_ = 0;
    }

    final void initialize() {
        this.clearBuffer();
        this.correlationID_ = 0;
    }

    private final void ensureLength(int length) {
        if (length > this.buffer.remaining()) {
            int newLength = Math.max(this.buffer.capacity() * 2, this.buffer.position() + length);
            this.buffer.flip();
            this.buffer = ByteBuffer.allocate(newLength).put(this.buffer);
        }
    }

    protected final void createCommand() {
        this.buildDss(false, false, false, 1, ++this.correlationID_, false);
    }

    final void createCommandData() {
        this.buildDss(true, false, false, 3, this.correlationID_, false);
    }

    final void createEncryptedCommandData() {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, false, false, 4, this.correlationID_, false);
        } else {
            this.buildDss(true, false, false, 3, this.correlationID_, false);
        }
    }

    private final void buildDss(boolean dssHasSameCorrelator, boolean chainedToNextStructure, boolean nextHasSameCorrelator, int dssType, int corrId, boolean simpleFinalizeBuildingNextDss) {
        if (this.doesRequestContainData()) {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(dssHasSameCorrelator);
            }
        }
        this.ensureLength(6);
        this.dssLengthLocation_ = this.buffer.position();
        this.buffer.putShort((short)-1);
        this.buffer.put((byte)-48);
        if (chainedToNextStructure) {
            dssType |= 0x40;
            if (nextHasSameCorrelator) {
                dssType |= 0x10;
            }
        }
        this.buffer.put((byte)dssType);
        this.buffer.putShort((short)corrId);
        this.simpleDssFinalize = simpleFinalizeBuildingNextDss;
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        this.writePlainScalarStream(chained, chainedWithSameCorrelator, codePoint, in, writeNullByte, parameterIndex);
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, long length, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("0A000.S"), "encrypted scalar streams");
        }
        this.writePlainScalarStream(chained, chainedWithSameCorrelator, codePoint, length, in, writeNullByte, parameterIndex);
    }

    private final void writePlainScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, long length, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        boolean writeEXTDTAStatusByte = this.netAgent_.netConnection_.serverSupportsEXTDTAAbort();
        long leftToRead = length;
        long bytesToSend = writeEXTDTAStatusByte ? leftToRead + 1L : leftToRead;
        int extendedLengthByteCount = this.prepScalarStream(chained, chainedWithSameCorrelator, writeNullByte, bytesToSend);
        int nullIndicatorSize = writeNullByte ? 1 : 0;
        int dssMaxDataLength = 32757 - nullIndicatorSize - extendedLengthByteCount;
        int bytesToRead = (int)Math.min(bytesToSend, (long)dssMaxDataLength);
        if (writeEXTDTAStatusByte && (long)bytesToRead == bytesToSend) {
            --bytesToRead;
        }
        this.buildLengthAndCodePointForLob(codePoint, bytesToSend, writeNullByte, extendedLengthByteCount);
        byte status = 127;
        int bytesRead = 0;
        while (true) {
            try {
                bytesRead = in.read(this.buffer.array(), this.buffer.position(), bytesToRead);
            }
            catch (IOException ioe) {
                if (this.netAgent_.getOutputStream() == null) {
                    for (Throwable t = ioe; t != null; t = t.getCause()) {
                        if (!(t instanceof SqlException) || !((SqlException)t).getSQLState().equals(ExceptionUtil.getSQLStateFromIdentifier("XN022.C"))) continue;
                        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN023.C"), ioe, parameterIndex);
                    }
                    throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN024.C"), ioe, parameterIndex, ioe.getMessage());
                }
                status = 1;
                this.padScalarStreamForError(leftToRead, bytesToRead, writeEXTDTAStatusByte, status);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), ioe, parameterIndex, ioe.getMessage()));
                return;
            }
            if (bytesRead == -1) {
                status = 2;
                this.padScalarStreamForError(leftToRead, bytesToRead, writeEXTDTAStatusByte, status);
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN017.S"), parameterIndex));
                return;
            }
            this.buffer.position(this.buffer.position() + bytesRead);
            leftToRead -= (long)bytesRead;
            if ((bytesToRead -= bytesRead) > 0) continue;
            bytesToRead = this.flushScalarStreamSegment(leftToRead, bytesToRead);
            if (leftToRead <= 0L) break;
        }
        try {
            if (in.read() != -1) {
                status = 4;
                this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN015.S"), parameterIndex));
            }
        }
        catch (Exception e) {
            status = 1;
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN016.S"), e, parameterIndex, e.getMessage()));
        }
        if (writeEXTDTAStatusByte) {
            this.writeEXTDTAStatus(status);
        }
    }

    private final void writePlainScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, InputStream in, boolean writeNullByte, int parameterIndex) throws DisconnectException {
        boolean writeEXTDTAStatusByte = this.netAgent_.netConnection_.serverSupportsEXTDTAAbort();
        in = new BufferedInputStream(in);
        this.flushExistingDSS();
        this.ensureLength(Short.MAX_VALUE - this.buffer.position());
        this.buildDss(true, chained, chainedWithSameCorrelator, 3, this.correlationID_, true);
        int spareInDss = writeNullByte ? 32756 : 32757;
        this.buildLengthAndCodePointForLob(codePoint, writeNullByte);
        try {
            int bytesRead = 0;
            while ((bytesRead = in.read(this.buffer.array(), this.buffer.position(), spareInDss)) > -1) {
                this.buffer.position(this.buffer.position() + bytesRead);
                if ((spareInDss -= bytesRead) > 0) continue;
                if (Request.peekStream((BufferedInputStream)in)) {
                    this.flushScalarStreamSegment();
                    this.buffer.putShort((short)-1);
                    spareInDss = 32765;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            if (writeEXTDTAStatusByte) {
                this.writeEXTDTAStatus((byte)1);
            }
            SqlException sqlex = new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN014.S"), e, parameterIndex, e.getMessage());
            this.netAgent_.accumulateReadException(sqlex);
            return;
        }
        if (writeEXTDTAStatusByte) {
            this.writeEXTDTAStatus((byte)127);
        }
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, int length, Reader r, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        this.writeScalarStream(chained, chainedWithSameCorrelator, codePoint, (long)length * 2L, EncodedInputStream.createUTF16BEStream(r), writeNullByte, parameterIndex);
    }

    final void writeScalarStream(boolean chained, boolean chainedWithSameCorrelator, int codePoint, Reader r, boolean writeNullByte, int parameterIndex) throws DisconnectException, SqlException {
        this.writeScalarStream(chained, chainedWithSameCorrelator, codePoint, EncodedInputStream.createUTF16BEStream(r), writeNullByte, parameterIndex);
    }

    private final int prepScalarStream(boolean chained, boolean chainedWithSameCorrelator, boolean writeNullByte, long leftToRead) throws DisconnectException {
        int nullIndicatorSize = writeNullByte ? 1 : 0;
        int extendedLengthByteCount = this.calculateExtendedLengthByteCount(leftToRead + 4L + (long)nullIndicatorSize);
        if ((long)(10 + extendedLengthByteCount + nullIndicatorSize) + leftToRead + (long)this.buffer.position() > 32767L) {
            try {
                if (this.simpleDssFinalize) {
                    this.finalizeDssLength();
                } else {
                    this.finalizePreviousChainedDss(true);
                }
                this.sendBytes(this.netAgent_.getOutputStream());
            }
            catch (IOException e) {
                this.netAgent_.throwCommunicationsFailure(e);
            }
        }
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.buildDss(true, chained, chainedWithSameCorrelator, 4, this.correlationID_, true);
        } else {
            this.buildDss(true, chained, chainedWithSameCorrelator, 3, this.correlationID_, true);
        }
        return extendedLengthByteCount;
    }

    private final void flushExistingDSS() throws DisconnectException {
        try {
            if (this.simpleDssFinalize) {
                this.finalizeDssLength();
            } else {
                this.finalizePreviousChainedDss(true);
            }
            this.sendBytes(this.netAgent_.getOutputStream());
        }
        catch (IOException e) {
            this.netAgent_.throwCommunicationsFailure(e);
        }
    }

    private final int flushScalarStreamSegment(long leftToRead, int bytesToRead) throws DisconnectException {
        int newBytesToRead = bytesToRead;
        if (leftToRead != 0L) {
            if (Math.min(2L + leftToRead, 32767L) > (long)this.buffer.remaining()) {
                try {
                    this.sendBytes(this.netAgent_.getOutputStream());
                }
                catch (IOException ioe) {
                    this.netAgent_.throwCommunicationsFailure(ioe);
                }
            }
            this.dssLengthLocation_ = this.buffer.position();
            this.buffer.putShort((short)-1);
            newBytesToRead = (int)Math.min(leftToRead, 32765L);
        }
        return newBytesToRead;
    }

    private final int flushScalarStreamSegment() throws DisconnectException {
        try {
            this.sendBytes(this.netAgent_.getOutputStream());
        }
        catch (IOException ioe) {
            this.netAgent_.throwCommunicationsFailure(ioe);
        }
        this.dssLengthLocation_ = this.buffer.position();
        return Short.MAX_VALUE;
    }

    private final void padScalarStreamForError(long leftToRead, int bytesToRead, boolean writeStatus, byte status) throws DisconnectException {
        while (true) {
            this.buffer.put((byte)0);
            --leftToRead;
            if (--bytesToRead > 0) continue;
            bytesToRead = this.flushScalarStreamSegment(leftToRead, bytesToRead);
            if (leftToRead <= 0L) break;
        }
        if (writeStatus) {
            this.writeEXTDTAStatus(status);
        }
    }

    private final void writeExtendedLengthBytes(int extendedLengthByteCount, long length) {
        int shiftSize = (extendedLengthByteCount - 1) * 8;
        for (int i = 0; i < extendedLengthByteCount; ++i) {
            this.buffer.put((byte)(length >>> shiftSize));
            shiftSize -= 8;
        }
    }

    private final void finalizePreviousChainedDss(boolean dssHasSameCorrelator) {
        this.finalizeDssLength();
        int pos = this.dssLengthLocation_ + 3;
        byte value = this.buffer.get(pos);
        value = (byte)(value | 0x40);
        if (dssHasSameCorrelator) {
            value = (byte)(value | 0x10);
        }
        this.buffer.put(pos, value);
    }

    private final boolean doesRequestContainData() {
        return this.buffer.position() != 0;
    }

    private final void finalizeDssLength() {
        int totalSize = this.buffer.position() - this.dssLengthLocation_;
        int bytesRequiringContDssHeader = totalSize - Short.MAX_VALUE;
        if (bytesRequiringContDssHeader > 0) {
            int dataToShift;
            int contDssHeaderCount = bytesRequiringContDssHeader / 32765;
            if (bytesRequiringContDssHeader % 32765 != 0) {
                ++contDssHeaderCount;
            }
            int dataByte = this.buffer.position() - 1;
            int shiftOffset = contDssHeaderCount * 2;
            this.ensureLength(shiftOffset);
            this.buffer.position(this.buffer.position() + shiftOffset);
            boolean passOne = true;
            do {
                if ((dataToShift = bytesRequiringContDssHeader % 32765) == 0) {
                    dataToShift = 32765;
                }
                byte[] array = this.buffer.array();
                System.arraycopy(array, (dataByte -= dataToShift) + 1, array, dataByte + shiftOffset + 1, dataToShift);
                int twoByteContDssHeader = dataToShift + 2;
                if (passOne) {
                    passOne = false;
                } else if (twoByteContDssHeader == Short.MAX_VALUE) {
                    twoByteContDssHeader = 65535;
                }
                this.buffer.putShort(dataByte + shiftOffset - 1, (short)twoByteContDssHeader);
                shiftOffset -= 2;
            } while ((bytesRequiringContDssHeader -= dataToShift) > 0);
            totalSize = 65535;
        }
        this.buffer.putShort(this.dssLengthLocation_, (short)totalSize);
    }

    protected final void markLengthBytes(int codePoint) {
        this.ensureLength(4);
        this.mark();
        this.buffer.position(this.buffer.position() + 2);
        this.buffer.putShort((short)codePoint);
    }

    private final void mark() {
        this.markStack_[this.top_++] = this.buffer.position();
    }

    private final int popMark() {
        return this.markStack_[--this.top_];
    }

    protected final void markForCachingPKGNAMCSN() {
        this.mark();
    }

    protected final int popMarkForCachingPKGNAMCSN() {
        return this.popMark();
    }

    protected final void updateLengthBytes() throws SqlException {
        int lengthLocation = this.popMark();
        int length = this.buffer.position() - lengthLocation;
        int extendedLengthByteCount = this.calculateExtendedLengthByteCount(length);
        if (extendedLengthByteCount != 0) {
            this.ensureLength(extendedLengthByteCount);
            int extendedLength = length - 4;
            int extendedLengthLocation = lengthLocation + 4;
            byte[] array = this.buffer.array();
            System.arraycopy(array, extendedLengthLocation, array, extendedLengthLocation + extendedLengthByteCount, extendedLength);
            int shiftSize = (extendedLengthByteCount - 1) * 8;
            for (int i = 0; i < extendedLengthByteCount; ++i) {
                this.buffer.put(extendedLengthLocation++, (byte)(extendedLength >>> shiftSize));
                shiftSize -= 8;
            }
            this.buffer.position(this.buffer.position() + extendedLengthByteCount);
            length = extendedLengthByteCount + 4;
            length |= 0x8000;
        }
        this.buffer.putShort(lengthLocation, (short)length);
    }

    private final int calculateExtendedLengthByteCount(long ddmSize) {
        if (ddmSize <= 32767L) {
            return 0;
        }
        if (ddmSize <= Integer.MAX_VALUE) {
            return 4;
        }
        if (ddmSize <= 0x7FFFFFFFFFFFL) {
            return 6;
        }
        return 8;
    }

    private final void padBytes(byte padByte, int length) {
        this.ensureLength(length);
        for (int i = 0; i < length; ++i) {
            this.buffer.put(padByte);
        }
    }

    final void write1Byte(int value) {
        this.writeByte((byte)value);
    }

    final void buildTripletHeader(int tripletLength, int tripletType, int tripletId) {
        this.ensureLength(3);
        this.buffer.put((byte)tripletLength);
        this.buffer.put((byte)tripletType);
        this.buffer.put((byte)tripletId);
    }

    private void writeLidAndLengths(int[][] lidAndLengthOverrides, int count, int offset) {
        this.ensureLength(count * 3);
        int i = 0;
        while (i < count) {
            this.buffer.put((byte)lidAndLengthOverrides[offset][0]);
            this.buffer.putShort((short)lidAndLengthOverrides[offset][1]);
            ++i;
            ++offset;
        }
    }

    final void writeLidAndLengths(int[][] lidAndLengthOverrides, int count, int offset, boolean mddRequired, Hashtable map) {
        if (!mddRequired) {
            this.writeLidAndLengths(lidAndLengthOverrides, count, offset);
        } else {
            this.ensureLength(count * 3);
            int i = 0;
            while (i < count) {
                int protocolType = lidAndLengthOverrides[offset][0];
                Object entry = map.get(protocolType);
                int overrideLid = entry == null ? protocolType : (Integer)entry;
                this.buffer.put((byte)overrideLid);
                this.buffer.putShort((short)lidAndLengthOverrides[offset][1]);
                ++i;
                ++offset;
            }
        }
    }

    final void write2Bytes(int value) {
        this.writeShort((short)value);
    }

    final void write4Bytes(long value) {
        this.writeInt((int)value);
    }

    final void writeBytes(byte[] buf, int length) {
        this.ensureLength(length);
        this.buffer.put(buf, 0, length);
    }

    final void writeBytes(byte[] buf) {
        this.writeBytes(buf, buf.length);
    }

    final void writeCodePoint4Bytes(int codePoint, int value) {
        this.ensureLength(4);
        this.buffer.putShort((short)codePoint);
        this.buffer.putShort((short)value);
    }

    protected final void writeScalar1Byte(int codePoint, int value) {
        this.ensureLength(5);
        this.buffer.put((byte)0);
        this.buffer.put((byte)5);
        this.buffer.putShort((short)codePoint);
        this.buffer.put((byte)value);
    }

    final void writeScalar2Bytes(int codePoint, int value) {
        this.ensureLength(6);
        this.buffer.put((byte)0);
        this.buffer.put((byte)6);
        this.buffer.putShort((short)codePoint);
        this.buffer.putShort((short)value);
    }

    protected final void writeScalar4Bytes(int codePoint, long value) {
        this.ensureLength(8);
        this.buffer.put((byte)0);
        this.buffer.put((byte)8);
        this.buffer.putShort((short)codePoint);
        this.buffer.putInt((int)value);
    }

    final void writeScalar8Bytes(int codePoint, long value) {
        this.ensureLength(12);
        this.buffer.put((byte)0);
        this.buffer.put((byte)12);
        this.buffer.putShort((short)codePoint);
        this.buffer.putLong(value);
    }

    final void writeLengthCodePoint(int length, int codePoint) {
        this.ensureLength(4);
        this.buffer.putShort((short)length);
        this.buffer.putShort((short)codePoint);
    }

    final void writeScalarString(int codePoint, String string) throws SqlException {
        this.writeScalarString(codePoint, string, 0, Integer.MAX_VALUE, null);
    }

    final void writeScalarString(int codePoint, String string, int byteMinLength, int byteLengthLimit, String sqlState) throws SqlException {
        CcsidManager currentCcsidMgr = this.netAgent_.getCurrentCcsidManager();
        int lengthPos = this.buffer.position();
        this.writeLengthCodePoint(0, codePoint);
        int stringByteLength = this.encodeString(string);
        if (stringByteLength > byteLengthLimit) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId(sqlState), string);
        }
        if (stringByteLength < byteMinLength) {
            this.padBytes(currentCcsidMgr.space_, byteMinLength - stringByteLength);
            stringByteLength = byteMinLength;
        }
        this.buffer.putShort(lengthPos, (short)(stringByteLength + 4));
    }

    private int encodeString(String string) throws SqlException {
        int startPos = this.buffer.position();
        CharBuffer src = CharBuffer.wrap(string);
        CcsidManager ccsidMgr = this.netAgent_.getCurrentCcsidManager();
        ccsidMgr.startEncoding();
        while (!ccsidMgr.encode(src, this.buffer, this.netAgent_)) {
            this.ensureLength(this.buffer.remaining() + 1);
        }
        return this.buffer.position() - startPos;
    }

    final void writeScalarBytes(int codePoint, byte[] buff) {
        this.writeScalarBytes(codePoint, buff, 0, buff.length);
    }

    final void writeScalarBytes(int codePoint, byte[] buff, int start, int length) {
        this.writeLengthCodePoint(length + 4, codePoint);
        this.ensureLength(length);
        this.buffer.put(buff, start, length);
    }

    final void writeScalarPaddedBytes(byte[] buff, int paddedLength, byte padByte) {
        this.writeBytes(buff);
        this.padBytes(padByte, paddedLength - buff.length);
    }

    protected void flush(OutputStream socketOutputStream) throws IOException {
        if (this.doesRequestContainData()) {
            this.finalizeDssLength();
            this.sendBytes(socketOutputStream);
        }
    }

    private void sendBytes(OutputStream socketOutputStream) throws IOException {
        try {
            this.netAgent_.markWriteChainAsDirty();
            socketOutputStream.write(this.buffer.array(), 0, this.buffer.position());
            socketOutputStream.flush();
        }
        finally {
            if (this.netAgent_.logWriter_ != null && this.passwordIncluded_) {
                this.maskOutPassword();
                this.passwordIncluded_ = false;
            }
            if (this.netAgent_.loggingEnabled()) {
                ((NetLogWriter)this.netAgent_.logWriter_).traceProtocolFlow(this.buffer.array(), 0, this.buffer.position(), 1, "Request", "flush", 1);
            }
            this.clearBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maskOutPassword() {
        int savedPos = this.buffer.position();
        try {
            String maskChar = "*";
            StringBuffer mask = new StringBuffer();
            for (int i = 0; i < this.passwordLength_; ++i) {
                mask.append(maskChar);
            }
            this.buffer.position(this.passwordStart_);
            this.encodeString(mask.toString());
        }
        catch (SqlException sqle) {
            for (int i = 0; i < this.passwordLength_; ++i) {
                this.buffer.put(this.passwordStart_ + i, (byte)-1);
            }
        }
        finally {
            this.buffer.position(savedPos);
        }
    }

    private void writeByte(byte v) {
        this.ensureLength(1);
        this.buffer.put(v);
    }

    final void writeShort(short v) {
        this.ensureLength(2);
        this.buffer.putShort(v);
    }

    void writeInt(int v) {
        this.ensureLength(4);
        this.buffer.putInt(v);
    }

    final void writeLong6Bytes(long v) {
        this.ensureLength(6);
        this.buffer.putShort((short)(v >> 32));
        this.buffer.putInt((int)v);
    }

    final void writeLong(long v) {
        this.ensureLength(8);
        this.buffer.putLong(v);
    }

    protected void writeShortFdocaData(short v) {
        this.writeShort(v);
    }

    protected void writeIntFdocaData(int v) {
        this.writeInt(v);
    }

    protected void writeLongFdocaData(long v) {
        this.writeLong(v);
    }

    protected void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    protected void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    final void writeBigDecimal(BigDecimal v, int declaredPrecision, int declaredScale) throws SqlException {
        this.ensureLength(16);
        int length = Decimal.bigDecimalToPackedDecimalBytes(this.buffer.array(), this.buffer.position(), v, declaredPrecision, declaredScale);
        this.buffer.position(this.buffer.position() + length);
    }

    final void writeDate(DateTimeValue date) throws SqlException {
        this.ensureLength(10);
        DateTime.dateToDateBytes(this.buffer.array(), this.buffer.position(), date);
        this.buffer.position(this.buffer.position() + 10);
    }

    final void writeTime(DateTimeValue time) {
        this.ensureLength(8);
        DateTime.timeToTimeBytes(this.buffer.array(), this.buffer.position(), time);
        this.buffer.position(this.buffer.position() + 8);
    }

    final void writeTimestamp(DateTimeValue timestamp) throws SqlException {
        boolean supportsTimestampNanoseconds = this.netAgent_.netConnection_.serverSupportsTimestampNanoseconds();
        int length = DateTime.getTimestampLength(supportsTimestampNanoseconds);
        this.ensureLength(length);
        DateTime.timestampToTimestampBytes(this.buffer.array(), this.buffer.position(), timestamp, supportsTimestampNanoseconds);
        this.buffer.position(this.buffer.position() + length);
    }

    final void writeBoolean(boolean v) {
        this.write1Byte(v ? 1 : 0);
    }

    final void writeSingleorMixedCcsidLDString(String s, Charset encoding) throws SqlException {
        byte[] b = s.getBytes(encoding);
        if (b.length > Short.MAX_VALUE) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22028"), "32767");
        }
        this.writeLDBytes(b);
    }

    final void writeLDBytes(byte[] bytes) {
        this.writeLDBytesX(bytes.length, bytes);
    }

    private final void writeLDBytesX(int ldSize, byte[] bytes) {
        this.writeLDBytesXSubset(ldSize, bytes.length, bytes);
    }

    private final void writeLDBytesXSubset(int ldSize, int bytesToCopy, byte[] bytes) {
        this.writeShort((short)ldSize);
        this.writeBytes(bytes, bytesToCopy);
    }

    final void writeUDT(Object val) throws SqlException {
        byte[] buffer = null;
        int length = 0;
        try {
            PublicBufferOutputStream pbos = new PublicBufferOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(pbos);
            oos.writeObject(val);
            buffer = pbos.getBuffer();
            length = pbos.size();
        }
        catch (Exception e) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN020.S"), e, e.getMessage());
        }
        if (length > Short.MAX_VALUE) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("22003"), Integer.toString(Short.MAX_VALUE), val.getClass().getName());
        }
        this.writeLDBytesXSubset(length, length, buffer);
    }

    private void buildLengthAndCodePointForLob(int codePoint, long leftToRead, boolean writeNullByte, int extendedLengthByteCount) throws DisconnectException {
        int nullIndicatorSize;
        int n = nullIndicatorSize = writeNullByte ? 1 : 0;
        if (extendedLengthByteCount > 0) {
            this.writeLengthCodePoint(32772 + extendedLengthByteCount, codePoint);
            this.writeExtendedLengthBytes(extendedLengthByteCount, leftToRead + (long)nullIndicatorSize);
        } else {
            SanityManager.ASSERT(leftToRead + 4L + (long)nullIndicatorSize <= 32767L);
            this.writeLengthCodePoint((int)(leftToRead + 4L + (long)nullIndicatorSize), codePoint);
        }
        if (writeNullByte) {
            this.write1Byte(0);
        }
    }

    private void buildLengthAndCodePointForLob(int codePoint, boolean writeNullByte) throws DisconnectException {
        this.writeLengthCodePoint(32772, codePoint);
        if (writeNullByte) {
            this.write1Byte(0);
        }
    }

    private void writeEXTDTAStatus(byte flag) throws DisconnectException {
        if (this.buffer.remaining() == 0) {
            this.flushScalarStreamSegment(1L, 0);
        }
        this.buffer.put(flag);
    }

    public void setDssLengthLocation(int location) {
        this.dssLengthLocation_ = location;
    }

    public void setCorrelationID(int id) {
        this.correlationID_ = id;
    }

    private static boolean peekStream(BufferedInputStream in) throws IOException {
        in.mark(1);
        boolean notYet = in.read() > -1;
        in.reset();
        return notYet;
    }
}

