/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.ClientBlob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.shared.common.sanity.SanityManager;

class BlobLocatorInputStream
extends InputStream {
    private final ClientConnection connection;
    private final ClientBlob blob;
    private long currentPos;
    private final long maxPos;

    BlobLocatorInputStream(ClientConnection connection, ClientBlob blob) throws SqlException {
        SanityManager.ASSERT(blob.isLocator());
        this.connection = connection;
        this.blob = blob;
        this.currentPos = 1L;
        this.maxPos = -1L;
    }

    BlobLocatorInputStream(ClientConnection connection, ClientBlob blob, long position, long length) throws SqlException {
        SanityManager.ASSERT(blob.isLocator());
        this.connection = connection;
        this.blob = blob;
        this.currentPos = position;
        this.maxPos = length != -1L ? Math.min(blob.sqlLength(), position + length - 1L) : -1L;
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = this.readBytes(1);
        if (bytes.length == 0) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = this.readBytes(len);
        if (bytes.length == 0) {
            return -1;
        }
        System.arraycopy(bytes, 0, b, off, bytes.length);
        return bytes.length;
    }

    private byte[] readBytes(int len) throws IOException {
        try {
            int actualLength = -1;
            actualLength = this.maxPos != -1L ? (int)Math.min((long)len, this.maxPos - this.currentPos + 1L) : (int)Math.min((long)len, this.blob.sqlLength() - this.currentPos + 1L);
            byte[] result = this.connection.locatorProcedureCall().blobGetBytes(this.blob.getLocator(), this.currentPos, actualLength);
            this.currentPos += (long)result.length;
            return result;
        }
        catch (SqlException ex) {
            throw new IOException(ex);
        }
    }
}

