/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class WindowDefinitionNode
extends WindowNode {
    private boolean inlined;
    private OrderByList orderByList;

    WindowDefinitionNode(String windowName, OrderByList orderByList, ContextManager cm) throws StandardException {
        super(windowName != null ? windowName : "IN-LINE", cm);
        this.orderByList = orderByList;
        this.inlined = windowName == null;
        if (orderByList != null) {
            throw StandardException.newException("0A000.S", "WINDOW/ORDER BY");
        }
    }

    @Override
    public String toString() {
        return "name: " + this.getName() + "\ninlined: " + this.inlined + "\n()\n";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.orderByList != null) {
            this.printLabel(depth, "orderByList: " + depth);
            this.orderByList.treePrint(depth + 1);
        }
    }

    WindowDefinitionNode findEquivalentWindow(WindowList wl) {
        for (WindowDefinitionNode old : wl) {
            if (!this.isEquivalent(old)) continue;
            return old;
        }
        return null;
    }

    private boolean isEquivalent(WindowDefinitionNode other) {
        if (this.orderByList == null && other.getOrderByList() == null) {
            return true;
        }
        SanityManager.ASSERT(false, "FIXME: ordering in windows not implemented yet");
        return false;
    }

    OrderByList getOrderByList() {
        return this.orderByList;
    }
}

