/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.hll;

import java.io.IOException;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

abstract class AlgebraicIntermediate
extends EvalFunc<Tuple> {
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    private final int lgK_;
    private final TgtHllType tgtHllType_;
    private Tuple emptySketchTuple_;
    private boolean isFirstCall_ = true;

    public AlgebraicIntermediate(int lgK, TgtHllType tgtHllType) {
        this.lgK_ = lgK;
        this.tgtHllType_ = tgtHllType;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Algebraic was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return this.getEmptySketchTuple();
        }
        DataBag outerBag = (DataBag)inputTuple.get(0);
        if (outerBag == null) {
            return this.getEmptySketchTuple();
        }
        Union union = new Union(this.lgK_);
        for (Tuple dataTuple : outerBag) {
            Object f0 = dataTuple.get(0);
            if (f0 == null) continue;
            if (f0 instanceof DataBag) {
                DataBag innerBag = (DataBag)f0;
                if (innerBag.size() == 0L) continue;
                this.updateUnion(innerBag, union);
                continue;
            }
            if (f0 instanceof DataByteArray) {
                DataByteArray dba = (DataByteArray)f0;
                union.update(HllSketch.wrap((Memory)Memory.wrap((byte[])dba.get())));
                continue;
            }
            throw new IllegalArgumentException("dataTuple.Field0 is not a DataBag or DataByteArray: " + f0.getClass().getName());
        }
        return tupleFactory_.newTuple((Object)new DataByteArray(union.getResult(this.tgtHllType_).toCompactByteArray()));
    }

    abstract void updateUnion(DataBag var1, Union var2) throws ExecException;

    private Tuple getEmptySketchTuple() {
        if (this.emptySketchTuple_ == null) {
            this.emptySketchTuple_ = tupleFactory_.newTuple((Object)new DataByteArray(new HllSketch(this.lgK_, this.tgtHllType_).toCompactByteArray()));
        }
        return this.emptySketchTuple_;
    }
}

