/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import java.io.IOException;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.AlgebraicInitial;
import org.apache.datasketches.pig.cpc.DataToSketchAlgebraicFinal;
import org.apache.datasketches.pig.cpc.DataToSketchAlgebraicIntermediate;
import org.apache.log4j.Logger;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public class DataToSketch
extends EvalFunc<DataByteArray>
implements Accumulator<DataByteArray>,
Algebraic {
    private DataByteArray emptySketch_;
    private final int lgK_;
    private final long seed_;
    private CpcSketch accumSketch_;
    private boolean isFirstCall_;

    public DataToSketch() {
        this(11, 9001L);
    }

    public DataToSketch(String lgK) {
        this(Integer.parseInt(lgK), 9001L);
    }

    public DataToSketch(String lgK, String seed) {
        this(Integer.parseInt(lgK), Long.parseLong(seed));
    }

    public DataToSketch(int lgK, long seed) {
        this.lgK_ = lgK;
        this.seed_ = seed;
    }

    public DataByteArray exec(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Exec was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new CpcSketch(this.lgK_, this.seed_).toByteArray());
            }
            return this.emptySketch_;
        }
        CpcSketch sketch = new CpcSketch(this.lgK_, this.seed_);
        DataBag bag = (DataBag)inputTuple.get(0);
        DataToSketch.updateSketch(bag, sketch);
        return new DataByteArray(sketch.toByteArray());
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (this.isFirstCall_) {
            Logger.getLogger(((Object)((Object)this)).getClass()).info((Object)"Accumulator was used");
            this.isFirstCall_ = false;
        }
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumSketch_ == null) {
            this.accumSketch_ = new CpcSketch(this.lgK_);
        }
        DataToSketch.updateSketch(bag, this.accumSketch_);
    }

    public DataByteArray getValue() {
        if (this.accumSketch_ == null) {
            if (this.emptySketch_ == null) {
                this.emptySketch_ = new DataByteArray(new CpcSketch(this.lgK_, this.seed_).toByteArray());
            }
            return this.emptySketch_;
        }
        return new DataByteArray(this.accumSketch_.toByteArray());
    }

    public void cleanup() {
        this.accumSketch_ = null;
    }

    public String getInitial() {
        return AlgebraicInitial.class.getName();
    }

    public String getIntermed() {
        return DataToSketchAlgebraicIntermediate.class.getName();
    }

    public String getFinal() {
        return DataToSketchAlgebraicFinal.class.getName();
    }

    static void updateSketch(DataBag bag, CpcSketch sketch) throws ExecException {
        block10: for (Tuple innerTuple : bag) {
            Object f0 = innerTuple.get(0);
            if (f0 == null) continue;
            byte type = innerTuple.getType(0);
            switch (type) {
                case 1: {
                    continue block10;
                }
                case 6: {
                    sketch.update((long)((Byte)f0).byteValue());
                    continue block10;
                }
                case 10: {
                    sketch.update((long)((Integer)f0).intValue());
                    continue block10;
                }
                case 15: {
                    sketch.update(((Long)f0).longValue());
                    continue block10;
                }
                case 20: {
                    sketch.update((double)((Float)f0).floatValue());
                    continue block10;
                }
                case 25: {
                    sketch.update(((Double)f0).doubleValue());
                    continue block10;
                }
                case 50: {
                    DataByteArray dba = (DataByteArray)f0;
                    sketch.update(dba.get());
                    continue block10;
                }
                case 55: {
                    String str = (String)f0;
                    sketch.update(str.toCharArray());
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Field 0 of innerTuple must be one of NULL, BYTE, INTEGER, LONG, FLOAT, DOUBLE, BYTEARRAY or CHARARRAY. Given Type = " + DataType.findTypeName((byte)type) + ", Object = " + f0.toString());
        }
    }
}

