/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.kll.UnionSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyBag() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execNormalCase() throws Exception {
        UnionSketch func = new UnionSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        KllFloatsSketch inputSketch = new KllFloatsSketch();
        inputSketch.update(1.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void accumulator() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.getValue();
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        result = (DataByteArray)func.getValue();
        sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple());
        result = (DataByteArray)func.getValue();
        sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        result = (DataByteArray)func.getValue();
        sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = BAG_FACTORY.newDefaultBag();
        KllFloatsSketch inputSketch = new KllFloatsSketch();
        inputSketch.update(1.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = UnionSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        func.cleanup();
        result = (DataByteArray)func.getValue();
        sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void accumulatorCustomK() throws Exception {
        UnionSketch func = new UnionSketch("400");
        KllFloatsSketch sketch = UnionSketchTest.getSketch((DataByteArray)func.getValue());
        Assert.assertEquals((int)sketch.getK(), (int)400);
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getInitial()).getConstructor(String.class).newInstance("400");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple());
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertTrue((boolean)(resultTuple.get(0) instanceof DataBag));
        Assert.assertEquals((long)((DataBag)resultTuple.get(0)).size(), (long)1L);
    }

    @Test
    public void algebraicIntermediateNullInputTupleCustomK() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).getConstructor(String.class).newInstance("400");
        Tuple resultTuple = (Tuple)func.exec(null);
        KllFloatsSketch sketch = UnionSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getK(), (int)400);
    }

    @Test
    public void algebraicIntermediateEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        KllFloatsSketch sketch = UnionSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateNormalCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        KllFloatsSketch qs = new KllFloatsSketch();
        qs.update(1.0f);
        innerBag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray())));
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        KllFloatsSketch qs2 = new KllFloatsSketch();
        qs2.update(2.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs2.toByteArray())));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = UnionSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateWrongType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)1.0));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void algebraicFinalNullInputTupleCustomK() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).getConstructor(String.class).newInstance("400");
        DataByteArray result = (DataByteArray)func.exec(null);
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getK(), (int)400);
    }

    @Test
    public void algebraicFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalNormalCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        KllFloatsSketch qs = new KllFloatsSketch();
        qs.update(1.0f);
        innerBag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray())));
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        KllFloatsSketch qs2 = new KllFloatsSketch();
        qs2.update(2.0f);
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs2.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        KllFloatsSketch sketch = UnionSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalWrongType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)1.0));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    private static KllFloatsSketch getSketch(Tuple tuple) throws Exception {
        Assert.assertNotNull((Object)tuple);
        Assert.assertEquals((int)tuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)tuple.get(0);
        return UnionSketchTest.getSketch(bytes);
    }

    private static KllFloatsSketch getSketch(DataByteArray bytes) throws Exception {
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        return KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])bytes.get()));
    }
}

