/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SpecificLeafTest {
    private static final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @Test
    public void checkByteBufferLeafs() {
        int bytes = 128;
        ByteBuffer bb = ByteBuffer.allocate(bytes);
        bb.order(ByteOrder.nativeOrder());
        Memory mem = Memory.wrap((ByteBuffer)bb).region(0L, (long)bytes, ByteOrder.nativeOrder());
        Assert.assertTrue((boolean)mem.hasByteBuffer());
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)mem.isMemory());
        Assert.assertFalse((boolean)mem.isDirect());
        Assert.assertFalse((boolean)mem.isMapped());
        SpecificLeafTest.checkCrossLeafTypeIds(mem);
        Buffer buf = mem.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
        Assert.assertEquals((Object)buf.getTypeByteOrder(), (Object)ResourceImpl.NATIVE_BYTE_ORDER);
        bb.order(ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Memory mem2 = Memory.wrap((ByteBuffer)bb).region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Buffer buf2 = mem2.asBuffer().region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Buffer buf3 = buf2.duplicate();
        Assert.assertTrue((boolean)mem.isRegion());
        Assert.assertTrue((boolean)mem2.isRegion());
        Assert.assertTrue((boolean)buf.isRegion());
        Assert.assertTrue((boolean)buf2.isRegion());
        Assert.assertTrue((boolean)buf3.isDuplicate());
    }

    @Test
    public void checkDirectLeafs() throws Exception {
        int bytes = 128;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.allocateDirect((long)bytes, (long)1L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)memReqSvr, (Arena)arena);
            Assert.assertFalse((boolean)((ResourceImpl)wmem).isReadOnly());
            Assert.assertTrue((boolean)wmem.isDirect());
            Assert.assertFalse((boolean)wmem.isHeap());
            Assert.assertFalse((boolean)wmem.isReadOnly());
            SpecificLeafTest.checkCrossLeafTypeIds((Memory)wmem);
            WritableMemory nnwmem = wmem.writableRegion(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Memory mem = wmem.region(0L, (long)bytes, ByteOrder.nativeOrder());
            Buffer buf = mem.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
            Memory mem2 = nnwmem.region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Buffer buf2 = mem2.asBuffer().region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Buffer buf3 = buf2.duplicate();
            Assert.assertTrue((boolean)mem.isRegion());
            Assert.assertTrue((boolean)mem2.isRegion());
            Assert.assertTrue((boolean)buf.isRegion());
            Assert.assertTrue((boolean)buf2.isRegion());
            Assert.assertTrue((boolean)buf3.isDuplicate());
            Assert.assertTrue((boolean)mem2.isMemory());
        }
    }

    @Test
    public void checkMapLeafs() throws IOException {
        File file = File.createTempFile("TestFile2", "bin");
        file.deleteOnExit();
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        long bytes = 128L;
        try (Arena arena = Arena.ofConfined();){
            WritableMemory mem = WritableMemory.writableMap((File)file, (long)0L, (long)128L, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
            Assert.assertTrue((boolean)mem.isMapped());
            Assert.assertFalse((boolean)mem.isReadOnly());
            SpecificLeafTest.checkCrossLeafTypeIds((Memory)mem);
            Memory nnreg = mem.region(0L, 128L, ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Memory reg = mem.region(0L, 128L, ByteOrder.nativeOrder());
            Buffer buf = reg.asBuffer().region(0L, 128L, ByteOrder.nativeOrder());
            Buffer buf4 = buf.duplicate();
            Memory reg2 = nnreg.region(0L, 128L, ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Buffer buf2 = reg2.asBuffer().region(0L, 128L, ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Buffer buf3 = buf2.duplicate();
            Assert.assertTrue((boolean)reg.isRegion());
            Assert.assertTrue((boolean)reg2.isRegion());
            Assert.assertEquals((Object)reg2.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
            Assert.assertTrue((boolean)buf.isRegion());
            Assert.assertFalse((boolean)buf.isMemory());
            Assert.assertTrue((boolean)buf2.isRegion());
            Assert.assertTrue((boolean)buf3.isDuplicate());
            Assert.assertTrue((boolean)buf4.isDuplicate());
        }
    }

    @Test
    public void checkHeapLeafs() {
        int bytes = 128;
        Memory mem = Memory.wrap((byte[])new byte[bytes]);
        Assert.assertTrue((boolean)mem.isHeap());
        Assert.assertTrue((boolean)((ResourceImpl)mem).isReadOnly());
        SpecificLeafTest.checkCrossLeafTypeIds(mem);
        Memory nnreg = mem.region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Memory reg = mem.region(0L, (long)bytes, ByteOrder.nativeOrder());
        Buffer buf = reg.asBuffer().region(0L, (long)bytes, ByteOrder.nativeOrder());
        Buffer buf4 = buf.duplicate();
        Memory reg2 = nnreg.region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Buffer buf2 = reg2.asBuffer().region(0L, (long)bytes, ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Buffer buf3 = buf2.duplicate();
        Assert.assertFalse((boolean)mem.isRegion());
        Assert.assertTrue((boolean)reg2.isRegion());
        Assert.assertTrue((boolean)buf.isRegion());
        Assert.assertTrue((boolean)buf2.isRegion());
        Assert.assertTrue((boolean)buf3.isDuplicate());
        Assert.assertTrue((boolean)buf4.isDuplicate());
    }

    private static void checkCrossLeafTypeIds(Memory mem) {
        Memory reg1 = mem.region(0L, mem.getCapacity());
        Assert.assertTrue((boolean)reg1.isRegion());
        Buffer buf1 = reg1.asBuffer();
        Assert.assertTrue((boolean)buf1.isRegion());
        Assert.assertTrue((boolean)buf1.isBuffer());
        Assert.assertTrue((boolean)buf1.isReadOnly());
        Buffer buf2 = buf1.duplicate();
        Assert.assertTrue((boolean)buf2.isRegion());
        Assert.assertTrue((boolean)buf2.isBuffer());
        Assert.assertTrue((boolean)buf2.isDuplicate());
        Assert.assertTrue((boolean)buf2.isReadOnly());
        Memory mem2 = buf1.asMemory();
        Assert.assertTrue((boolean)mem2.isRegion());
        Assert.assertFalse((boolean)mem2.isBuffer());
        Assert.assertFalse((boolean)mem2.isDuplicate());
        Assert.assertTrue((boolean)mem2.isReadOnly());
        Buffer buf3 = buf1.duplicate(ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertTrue((boolean)buf3.isRegion());
        Assert.assertTrue((boolean)buf3.isBuffer());
        Assert.assertTrue((boolean)buf3.isDuplicate());
        Assert.assertEquals((Object)buf3.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertTrue((boolean)buf3.isReadOnly());
        Memory mem3 = buf3.asMemory();
        Assert.assertTrue((boolean)mem3.isRegion());
        Assert.assertFalse((boolean)mem3.isBuffer());
        Assert.assertTrue((boolean)mem3.isDuplicate());
        Assert.assertEquals((Object)mem3.getTypeByteOrder(), (Object)ResourceImpl.NON_NATIVE_BYTE_ORDER);
        Assert.assertTrue((boolean)mem3.isReadOnly());
    }
}

