/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResourceTest {
    @Test
    public void checkNativeOverlap() {
        MemorySegment par = MemorySegment.allocateNative((long)100L, (ResourceScope)ResourceScope.newImplicitScope());
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 40L, 60L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 20L, 40L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 10L, 30L)), (long)10L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 10L, 30L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)-10L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 20L, 40L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 0L), (MemorySegment)ResourceTest.getSeg(par, 0L, 0L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 60L, 80L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 40L, 60L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 30L, 50L)), (long)10L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 20L, 40L)), (long)20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 10L, 30L)), (long)20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 40L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 10L, 50L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)-10L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 20L, 60L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 40L, 80L), (MemorySegment)ResourceTest.getSeg(par, 0L, 20L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 40L, 80L), (MemorySegment)ResourceTest.getSeg(par, 0L, 0L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 60L, 80L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 40L, 60L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 30L, 50L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)-10L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 20L, 40L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)-20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 10L, 30L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)-20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 0L, 40L)), (long)20L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 10L, 50L)), (long)10L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 20L, 60L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 20L), (MemorySegment)ResourceTest.getSeg(par, 40L, 80L)), (long)0L);
        Assert.assertEquals((long)ResourceImpl.nativeOverlap((MemorySegment)ResourceTest.getSeg(par, 0L, 0L), (MemorySegment)ResourceTest.getSeg(par, 40L, 80L)), (long)0L);
    }

    private static MemorySegment getSeg(MemorySegment parent, long left, long right) {
        return parent.asSlice(left, right - left);
    }

    @Test
    public void checkNotEqualTo() {
        byte[] arr1 = new byte[8];
        Memory mem = Memory.wrap((byte[])arr1);
        byte[] arr2 = new byte[8];
        arr2[7] = 1;
        Memory mem2 = Memory.wrap((byte[])arr2);
        Assert.assertFalse((boolean)mem.equalTo(0L, (Resource)mem2, 0L, 8L));
    }

    @Test
    public void checkIsByteOrderCompatible() {
        WritableMemory wmem = WritableMemory.allocate((int)8);
        Assert.assertTrue((boolean)wmem.isByteOrderCompatible(ByteOrder.nativeOrder()));
    }

    @Test
    public void checkXxHash64() {
        WritableMemory mem = WritableMemory.allocate((int)8);
        long out = mem.xxHash64(mem.getLong(0L), 1L);
        Assert.assertTrue((out != 0L ? 1 : 0) != 0);
    }

    @Test
    public void checkTypeDecode() {
        for (int i = 0; i < 256; ++i) {
            String str = ResourceImpl.typeDecode((int)i);
            ResourceTest.println(i + "\t" + str);
        }
    }

    @Test
    public void checkToHexString() {
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[16]);
        ResourceTest.println(mem.toString("baseMem", 0L, 16, true));
        for (int i = 0; i < 16; ++i) {
            mem.putByte((long)i, (byte)i);
        }
        Buffer buf = mem.asBuffer();
        ResourceTest.println(buf.toString("buffer", 0L, 16, true));
    }

    @Test
    public void checkToMemorySegment() {
        WritableMemory mem = WritableMemory.allocate((int)8);
        mem.toMemorySegment();
        mem.asByteBufferView(ByteOrder.nativeOrder());
    }

    @Test
    public void printlnTest() {
        ResourceTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

