/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.filters.bloomfilter.BloomFilter;
import org.apache.datasketches.filters.bloomfilter.BloomFilterBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BloomFilterTest {
    @Test
    public void createNewFilterTest() throws Exception {
        long numItems = 4000L;
        double targetFpp = 0.01;
        long numBits = BloomFilterBuilder.suggestNumFilterBits((long)4000L, (double)0.01);
        short numHashes = BloomFilterBuilder.suggestNumHashes((long)4000L, (long)numBits);
        int sizeBytes = (int)BloomFilterBuilder.getSerializedFilterSize((long)numBits);
        long seed = 89023L;
        BloomFilter bf1 = new BloomFilter(numBits, (int)numHashes, 89023L);
        Assert.assertTrue((boolean)bf1.isEmpty());
        Assert.assertFalse((boolean)bf1.hasMemorySegment());
        Assert.assertFalse((boolean)bf1.isOffHeap());
        Assert.assertFalse((boolean)bf1.isReadOnly());
        try (Arena arena = Arena.ofConfined();){
            MemorySegment wseg = arena.allocate(sizeBytes);
            BloomFilter bf2 = new BloomFilter(numBits, (int)numHashes, 89023L, wseg);
            Assert.assertTrue((boolean)bf2.isEmpty());
            Assert.assertTrue((boolean)bf2.hasMemorySegment());
            Assert.assertTrue((boolean)bf2.isOffHeap());
            Assert.assertFalse((boolean)bf2.isReadOnly());
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void tooSmallMemorySegmentTest() {
        new BloomFilter(65536L, 4, 1L, MemorySegment.ofArray(new byte[32]));
    }

    @Test
    public void wrapEmptyFilterTest() {
        long numBits = 8192L;
        int numHashes = 4;
        BloomFilter bf = BloomFilterBuilder.createBySize((long)8192L, (int)4);
        Assert.assertTrue((boolean)bf.isEmpty());
        Assert.assertEquals((long)bf.getBitsUsed(), (long)0L);
        Assert.assertEquals((long)bf.getCapacity(), (long)8192L);
        Assert.assertEquals((int)bf.getNumHashes(), (int)4);
        MemorySegment seg = MemorySegment.ofArray(bf.toByteArray());
        Assert.assertEquals((long)bf.getSerializedSizeBytes(), (long)seg.byteSize());
        MemorySegment wseg = MemorySegment.ofArray(bf.toByteArray());
        Assert.assertEquals((long)bf.getSerializedSizeBytes(), (long)wseg.byteSize());
        BloomFilter bfReadOnly = BloomFilter.wrap((MemorySegment)seg);
        Assert.assertTrue((boolean)bfReadOnly.isEmpty());
        Assert.assertEquals((long)bfReadOnly.getBitsUsed(), (long)0L);
        Assert.assertEquals((long)bfReadOnly.getCapacity(), (long)8192L);
        Assert.assertEquals((int)bfReadOnly.getNumHashes(), (int)4);
        Assert.assertTrue((boolean)bfReadOnly.isReadOnly());
        Assert.assertThrows(SketchesArgumentException.class, () -> BloomFilter.writableWrap((MemorySegment)wseg));
    }

    @Test
    public void wrapNonEmptyFilterTest() {
        long numBits = 8192L;
        int numHashes = 4;
        long seed = 52483905L;
        BloomFilter bf = BloomFilterBuilder.createBySize((long)8192L, (int)4, (long)52483905L);
        long valStart = 1024L;
        long valEnd = 2048L;
        for (long i = 1024L; i < 2048L; ++i) {
            bf.update(i);
        }
        MemorySegment wseg = MemorySegment.ofArray(bf.toByteArray());
        Assert.assertEquals((long)bf.getSerializedSizeBytes(), (long)wseg.byteSize());
        BloomFilter bfWritable = BloomFilter.writableWrap((MemorySegment)wseg);
        Assert.assertFalse((boolean)bfWritable.isEmpty());
        Assert.assertEquals((long)bfWritable.getBitsUsed(), (long)bf.getBitsUsed());
        Assert.assertEquals((long)bfWritable.getCapacity(), (long)bf.getCapacity());
        Assert.assertEquals((short)bfWritable.getNumHashes(), (short)bf.getNumHashes());
        Assert.assertFalse((boolean)bfWritable.isReadOnly());
        BloomFilter bfReadOnly = BloomFilter.wrap((MemorySegment)wseg);
        Assert.assertFalse((boolean)bfReadOnly.isEmpty());
        Assert.assertEquals((long)bfReadOnly.getBitsUsed(), (long)bf.getBitsUsed());
        Assert.assertEquals((long)bfReadOnly.getCapacity(), (long)bf.getCapacity());
        Assert.assertEquals((short)bfReadOnly.getNumHashes(), (short)bf.getNumHashes());
        Assert.assertTrue((boolean)bfReadOnly.isReadOnly());
        Assert.assertFalse((boolean)bfWritable.queryAndUpdate(32768L));
        Assert.assertTrue((boolean)bfReadOnly.query(32768L));
        Assert.assertThrows(SketchesReadOnlyException.class, () -> bfReadOnly.update(99999L));
    }

    @Test
    public void basicFilterOperationsTest() {
        long numBits = 8192L;
        int numHashes = 3;
        BloomFilter bf = BloomFilterBuilder.createBySize((long)8192L, (int)3);
        Assert.assertTrue((boolean)bf.isEmpty());
        Assert.assertEquals((long)bf.getCapacity(), (long)8192L);
        Assert.assertEquals((int)bf.getNumHashes(), (int)3);
        Assert.assertEquals((long)bf.getBitsUsed(), (long)0L);
        long n = 1000L;
        for (long i = 0L; i < 1000L; ++i) {
            bf.queryAndUpdate(i);
        }
        Assert.assertFalse((boolean)bf.isEmpty());
        Assert.assertTrue((bf.getBitsUsed() <= 3000L ? 1 : 0) != 0);
        Assert.assertTrue((bf.getBitsUsed() >= 2000L ? 1 : 0) != 0);
        int numFound = 0;
        for (long i = 0L; i < 2000L; ++i) {
            if (!bf.query(i)) continue;
            ++numFound;
        }
        Assert.assertTrue(((long)numFound >= 1000L ? 1 : 0) != 0);
        Assert.assertTrue(((double)numFound < 1100.0 ? 1 : 0) != 0);
        assert (String.valueOf(bf).length() > 0);
        bf.reset();
        Assert.assertTrue((boolean)bf.isEmpty());
        Assert.assertEquals((long)bf.getCapacity(), (long)8192L);
        Assert.assertEquals((int)bf.getNumHashes(), (int)3);
        Assert.assertEquals((long)bf.getBitsUsed(), (long)0L);
    }

    @Test
    public void inversionTest() {
        int i;
        long numBits = 8192L;
        int numHashes = 3;
        BloomFilter bf = BloomFilterBuilder.createBySize((long)8192L, (int)3);
        int n = 500;
        for (int i2 = 0; i2 < 500; ++i2) {
            bf.queryAndUpdate(Integer.toString(i2));
        }
        long numBitsSet = bf.getBitsUsed();
        bf.invert();
        Assert.assertEquals((long)bf.getBitsUsed(), (long)(8192L - numBitsSet));
        int count = 0;
        for (i = 0; i < 500; ++i) {
            count += bf.query(Integer.toString(i)) ? 1 : 0;
        }
        Assert.assertTrue(((long)count < 819L ? 1 : 0) != 0);
        count = 0;
        i = 500;
        while ((long)i < 8192L) {
            count += bf.query(Integer.toString(i)) ? 1 : 0;
            ++i;
        }
        Assert.assertTrue((count > 500 ? 1 : 0) != 0);
    }

    @Test
    public void incompatibleSetOperationsTest() {
        int numBits = 128;
        int numHashes = 4;
        BloomFilter bf1 = BloomFilterBuilder.createBySize((long)128L, (int)4);
        BloomFilter bf2 = BloomFilterBuilder.createBySize((long)256L, (int)4, (long)bf1.getSeed());
        Assert.assertThrows(SketchesArgumentException.class, () -> bf1.union(bf2));
        BloomFilter bf3 = BloomFilterBuilder.createBySize((long)128L, (int)8, (long)bf1.getSeed());
        Assert.assertThrows(SketchesArgumentException.class, () -> bf1.intersect(bf3));
        BloomFilter bf4 = BloomFilterBuilder.createBySize((long)128L, (int)4, (long)(bf1.getSeed() - 1L));
        Assert.assertThrows(SketchesArgumentException.class, () -> bf1.union(bf4));
    }

    @Test
    public void basicUnionTest() {
        int i;
        long numBits = 12288L;
        int numHashes = 4;
        BloomFilter bf1 = BloomFilterBuilder.createBySize((long)12288L, (int)4);
        BloomFilter bf2 = BloomFilterBuilder.createBySize((long)12288L, (int)4, (long)bf1.getSeed());
        int n = 1000;
        int maxItem = 1499;
        for (i = 0; i < 1000; ++i) {
            bf1.queryAndUpdate((long)i);
            bf2.queryAndUpdate((long)(500 + i));
        }
        bf1.union(null);
        bf1.union(bf2);
        for (i = 0; i < 1499; ++i) {
            Assert.assertTrue((boolean)bf1.query((long)i));
        }
        int count = 0;
        int i2 = 1499;
        while ((long)i2 < 12288L) {
            count += bf1.query((long)i2) ? 1 : 0;
            ++i2;
        }
        Assert.assertTrue(((long)count < 1228L ? 1 : 0) != 0);
    }

    @Test
    public void basicIntersectionTest() {
        int i;
        int i2;
        long numBits = 8192L;
        int numHashes = 5;
        BloomFilter bf1 = BloomFilterBuilder.createBySize((long)8192L, (int)5);
        BloomFilter bf2 = BloomFilterBuilder.createBySize((long)8192L, (int)5, (long)bf1.getSeed());
        int n = 1024;
        int maxItem = 1535;
        for (i2 = 0; i2 < 1024; ++i2) {
            bf1.queryAndUpdate((long)i2);
            bf2.queryAndUpdate((long)(512 + i2));
        }
        bf1.intersect(null);
        bf1.intersect(bf2);
        for (i2 = 512; i2 < 1024; ++i2) {
            Assert.assertTrue((boolean)bf1.query((long)i2));
        }
        int count = 0;
        for (i = 0; i < 512; ++i) {
            count += bf1.query((long)i) ? 1 : 0;
        }
        i = 1535;
        while ((long)i < 8192L) {
            count += bf1.query((long)i) ? 1 : 0;
            ++i;
        }
        Assert.assertTrue(((long)count < 819L ? 1 : 0) != 0);
    }

    @Test
    public void emptySerializationTest() {
        long numBits = 32768L;
        int numHashes = 7;
        BloomFilter bf = BloomFilterBuilder.createBySize((long)32768L, (int)7);
        byte[] bytes = bf.toByteArray();
        MemorySegment segBytes = MemorySegment.ofArray(bytes);
        BloomFilter fromBytes = BloomFilter.heapify((MemorySegment)segBytes);
        Assert.assertTrue((boolean)fromBytes.isEmpty());
        Assert.assertEquals((long)fromBytes.getCapacity(), (long)32768L);
        Assert.assertEquals((int)fromBytes.getNumHashes(), (int)7);
        long[] longs = bf.toLongArray();
        MemorySegment segLongs = MemorySegment.ofArray(longs);
        BloomFilter fromLongs = BloomFilter.heapify((MemorySegment)segLongs);
        Assert.assertTrue((boolean)fromLongs.isEmpty());
        Assert.assertEquals((long)fromLongs.getCapacity(), (long)32768L);
        Assert.assertEquals((int)fromLongs.getNumHashes(), (int)7);
        Assert.assertEquals((long)segBytes.byteSize(), (long)segLongs.byteSize());
        for (long i = 0L; i < segBytes.byteSize(); ++i) {
            Assert.assertEquals((byte)segBytes.get(ValueLayout.JAVA_BYTE, i), (byte)segLongs.get(ValueLayout.JAVA_BYTE, i));
        }
    }

    @Test
    public void nonEmptySerializationTest() {
        long numBits = 32768L;
        int numHashes = 5;
        BloomFilter bf = BloomFilterBuilder.createBySize((long)32768L, (int)5);
        int n = 2500;
        for (int i = 0; i < 2500; ++i) {
            bf.queryAndUpdate(0.5 + (double)i);
        }
        long numBitsSet = bf.getBitsUsed();
        int count = 0;
        int i = 2500;
        while ((long)i < 32768L) {
            count += bf.query(0.5 + (double)i) ? 1 : 0;
            ++i;
        }
        byte[] bytes = bf.toByteArray();
        MemorySegment segBytes = MemorySegment.ofArray(bytes);
        BloomFilter fromBytes = BloomFilter.heapify((MemorySegment)segBytes);
        Assert.assertFalse((boolean)fromBytes.isEmpty());
        Assert.assertEquals((long)fromBytes.getCapacity(), (long)32768L);
        Assert.assertEquals((long)fromBytes.getBitsUsed(), (long)numBitsSet);
        Assert.assertEquals((int)fromBytes.getNumHashes(), (int)5);
        int fromBytesCount = 0;
        int i2 = 0;
        while ((long)i2 < 32768L) {
            boolean val = fromBytes.query(0.5 + (double)i2);
            if (val) {
                ++fromBytesCount;
            }
            if (i2 < 2500) {
                Assert.assertTrue((boolean)val);
            }
            ++i2;
        }
        Assert.assertEquals((int)fromBytesCount, (int)(2500 + count));
        long[] longs = bf.toLongArray();
        MemorySegment segLongs = MemorySegment.ofArray(longs);
        BloomFilter fromLongs = BloomFilter.heapify((MemorySegment)segLongs);
        Assert.assertFalse((boolean)fromLongs.isEmpty());
        Assert.assertEquals((long)fromLongs.getCapacity(), (long)32768L);
        Assert.assertEquals((long)fromLongs.getBitsUsed(), (long)numBitsSet);
        Assert.assertEquals((int)fromLongs.getNumHashes(), (int)5);
        int fromLongsCount = 0;
        int i3 = 0;
        while ((long)i3 < 32768L) {
            boolean val = fromLongs.query(0.5 + (double)i3);
            if (val) {
                ++fromLongsCount;
            }
            if (i3 < 2500) {
                Assert.assertTrue((boolean)val);
            }
            ++i3;
        }
        Assert.assertEquals((int)fromLongsCount, (int)(2500 + count));
        Assert.assertEquals((long)segBytes.byteSize(), (long)segLongs.byteSize());
        for (long i4 = 0L; i4 < segBytes.byteSize(); ++i4) {
            Assert.assertEquals((byte)segBytes.get(ValueLayout.JAVA_BYTE, i4), (byte)segLongs.get(ValueLayout.JAVA_BYTE, i4));
        }
    }

    @Test
    public void heapifyFromDirectTest() {
        long numDistinct = 10000L;
        double targetFpp = 0.001;
        int numBytes = (int)BloomFilterBuilder.getSerializedFilterSizeByAccuracy((long)10000L, (double)0.001);
        MemorySegment wseg = MemorySegment.ofArray(new byte[numBytes]);
        BloomFilter bf = BloomFilterBuilder.initializeByAccuracy((long)10000L, (double)0.001, (long)89540235L, (MemorySegment)wseg);
        byte[] bytes = bf.toByteArray();
        Assert.assertEquals((int)bytes.length, (int)(Family.BLOOMFILTER.getMinPreLongs() * 8));
        BloomFilter bfBytes = BloomFilter.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertTrue((boolean)bfBytes.isEmpty());
        Assert.assertEquals((short)bfBytes.getNumHashes(), (short)bf.getNumHashes());
        Assert.assertEquals((long)bfBytes.getBitsUsed(), (long)0L);
        Assert.assertEquals((long)bfBytes.getCapacity(), (long)bf.getCapacity());
        long[] longs = bf.toLongArray();
        Assert.assertEquals((int)longs.length, (int)Family.BLOOMFILTER.getMinPreLongs());
        BloomFilter bfLongs = BloomFilter.heapify((MemorySegment)MemorySegment.ofArray(longs));
        Assert.assertTrue((boolean)bfLongs.isEmpty());
        Assert.assertEquals((short)bfLongs.getNumHashes(), (short)bf.getNumHashes());
        Assert.assertEquals((long)bfLongs.getBitsUsed(), (long)0L);
        Assert.assertEquals((long)bfLongs.getCapacity(), (long)bf.getCapacity());
        for (int i = 0; i < 10000; ++i) {
            bf.queryAndUpdate(Integer.toString(i));
        }
        bytes = bf.toByteArray();
        Assert.assertEquals((long)bytes.length, (long)bf.getSerializedSizeBytes());
        bfBytes = BloomFilter.heapify((MemorySegment)MemorySegment.ofArray(bytes));
        Assert.assertFalse((boolean)bfBytes.isEmpty());
        Assert.assertEquals((short)bfBytes.getNumHashes(), (short)bf.getNumHashes());
        Assert.assertEquals((long)bfBytes.getBitsUsed(), (long)bf.getBitsUsed());
        Assert.assertEquals((long)bfBytes.getCapacity(), (long)bf.getCapacity());
        Assert.assertTrue((boolean)bfBytes.query(Integer.toString(5000)));
        Assert.assertFalse((boolean)bfBytes.query(Integer.toString(50000)));
        longs = bf.toLongArray();
        Assert.assertEquals((long)longs.length, (long)(bf.getSerializedSizeBytes() / 8L));
        bfLongs = BloomFilter.heapify((MemorySegment)MemorySegment.ofArray(longs));
        Assert.assertFalse((boolean)bfLongs.isEmpty());
        Assert.assertEquals((short)bfLongs.getNumHashes(), (short)bf.getNumHashes());
        Assert.assertEquals((long)bfLongs.getBitsUsed(), (long)bf.getBitsUsed());
        Assert.assertEquals((long)bfLongs.getCapacity(), (long)bf.getCapacity());
        Assert.assertTrue((boolean)bfBytes.query(Integer.toString(7500)));
        Assert.assertFalse((boolean)bfBytes.query(Integer.toString(75000)));
    }

    @Test
    public void testBasicUpdateMethods() {
        int numDistinct = 100;
        double fpp = 1.0E-6;
        BloomFilter bf = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6);
        bf.update("");
        bf.update((String)null);
        Assert.assertFalse((boolean)bf.queryAndUpdate(""));
        Assert.assertFalse((boolean)bf.queryAndUpdate((String)null));
        Assert.assertEquals((long)bf.getBitsUsed(), (long)0L);
        bf.update("abc");
        Assert.assertFalse((boolean)bf.queryAndUpdate("def"));
        bf.update(932L);
        Assert.assertFalse((boolean)bf.queryAndUpdate(543L));
        bf.update(Double.NaN);
        Assert.assertFalse((boolean)bf.queryAndUpdate(Double.POSITIVE_INFINITY));
        Assert.assertTrue((bf.getBitsUsed() <= (long)(bf.getNumHashes() * 6) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)bf.isEmpty());
    }

    @Test
    public void testArrayUpdateMethods() {
        double[] rawData = new double[]{1.414, 2.71, 3.1415926538};
        MemorySegment seg = MemorySegment.ofArray(rawData);
        int numDistinct = 100;
        double fpp = 1.0E-6;
        BloomFilter bfSeg = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6);
        bfSeg.update(seg);
        Assert.assertTrue((boolean)bfSeg.queryAndUpdate(seg));
        Assert.assertTrue((boolean)bfSeg.query(seg));
        long numBitsSet = bfSeg.getBitsUsed();
        long seed = bfSeg.getSeed();
        BloomFilter bfBytes = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6, (long)seed);
        byte[] bytes = seg.toArray(ValueLayout.JAVA_BYTE);
        bfBytes.update(bytes);
        Assert.assertTrue((boolean)bfBytes.queryAndUpdate(bytes));
        Assert.assertTrue((boolean)bfBytes.query(bytes));
        Assert.assertEquals((long)bfBytes.getBitsUsed(), (long)numBitsSet);
        BloomFilter bfChars = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6, (long)seed);
        char[] chars = seg.toArray(ValueLayout.JAVA_CHAR_UNALIGNED);
        bfChars.update(chars);
        Assert.assertTrue((boolean)bfChars.queryAndUpdate(chars));
        Assert.assertTrue((boolean)bfChars.query(chars));
        Assert.assertEquals((long)bfChars.getBitsUsed(), (long)numBitsSet);
        BloomFilter bfShorts = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6, (long)seed);
        short[] shorts = seg.toArray(ValueLayout.JAVA_SHORT_UNALIGNED);
        bfShorts.update(shorts);
        Assert.assertTrue((boolean)bfShorts.queryAndUpdate(shorts));
        Assert.assertTrue((boolean)bfShorts.query(shorts));
        Assert.assertEquals((long)bfShorts.getBitsUsed(), (long)numBitsSet);
        BloomFilter bfInts = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6, (long)seed);
        int[] ints = seg.toArray(ValueLayout.JAVA_INT_UNALIGNED);
        bfInts.update(ints);
        Assert.assertTrue((boolean)bfInts.queryAndUpdate(ints));
        Assert.assertTrue((boolean)bfInts.query(ints));
        Assert.assertEquals((long)bfInts.getBitsUsed(), (long)numBitsSet);
        BloomFilter bfLongs = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6, (long)seed);
        long[] longs = seg.toArray(ValueLayout.JAVA_LONG_UNALIGNED);
        bfLongs.update(longs);
        Assert.assertTrue((boolean)bfLongs.queryAndUpdate(longs));
        Assert.assertTrue((boolean)bfLongs.query(longs));
        Assert.assertEquals((long)bfLongs.getBitsUsed(), (long)numBitsSet);
        BloomFilter bf = BloomFilterBuilder.createByAccuracy((long)100L, (double)1.0E-6, (long)seed);
        bf.intersect(bfSeg);
        bf.intersect(bfBytes);
        bf.intersect(bfChars);
        bf.intersect(bfShorts);
        bf.intersect(bfInts);
        bf.intersect(bfLongs);
        Assert.assertEquals((long)bfLongs.getBitsUsed(), (long)numBitsSet);
    }
}

