/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import java.util.Random;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Filter;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FilterTest {
    private static final int numberOfElements = 100;
    private static final Random random = new Random(1L);
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void emptySketch() {
        Sketch sketch = Sketches.createEmptySketch();
        Filter filter = new Filter(o -> true);
        CompactSketch filteredSketch = filter.filter(sketch);
        Assert.assertEquals((double)filteredSketch.getEstimate(), (double)0.0);
        Assert.assertEquals((long)filteredSketch.getThetaLong(), (long)sketch.getThetaLong());
        Assert.assertTrue((boolean)filteredSketch.isEmpty());
        Assert.assertEquals((double)filteredSketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)filteredSketch.getUpperBound(1), (double)0.0);
    }

    @Test
    public void nullSketch() {
        Filter filter = new Filter(o -> true);
        CompactSketch filteredSketch = filter.filter(null);
        Assert.assertEquals((double)filteredSketch.getEstimate(), (double)0.0);
        Assert.assertEquals((long)filteredSketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertTrue((boolean)filteredSketch.isEmpty());
        Assert.assertEquals((double)filteredSketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)filteredSketch.getUpperBound(1), (double)0.0);
    }

    @Test
    public void filledSketchShouldBehaveTheSame() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        FilterTest.fillSketch((UpdatableSketch<Double, DoubleSummary>)sketch, 100, 0.0);
        Filter filter = new Filter(o -> true);
        CompactSketch filteredSketch = filter.filter((Sketch)sketch);
        Assert.assertEquals((double)filteredSketch.getEstimate(), (double)sketch.getEstimate());
        Assert.assertEquals((long)filteredSketch.getThetaLong(), (long)sketch.getThetaLong());
        Assert.assertFalse((boolean)filteredSketch.isEmpty());
        Assert.assertEquals((double)filteredSketch.getLowerBound(1), (double)sketch.getLowerBound(1));
        Assert.assertEquals((double)filteredSketch.getUpperBound(1), (double)sketch.getUpperBound(1));
    }

    @Test
    public void filledSketchShouldFilterOutElements() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        FilterTest.fillSketch((UpdatableSketch<Double, DoubleSummary>)sketch, 100, 0.0);
        FilterTest.fillSketch((UpdatableSketch<Double, DoubleSummary>)sketch, 200, 1.0);
        Filter filter = new Filter(o -> o.getValue() < 0.5);
        CompactSketch filteredSketch = filter.filter((Sketch)sketch);
        Assert.assertEquals((double)filteredSketch.getEstimate(), (double)100.0);
        Assert.assertEquals((long)filteredSketch.getThetaLong(), (long)sketch.getThetaLong());
        Assert.assertFalse((boolean)filteredSketch.isEmpty());
        Assert.assertTrue((filteredSketch.getLowerBound(1) <= filteredSketch.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((filteredSketch.getUpperBound(1) >= filteredSketch.getEstimate() ? 1 : 0) != 0);
    }

    @Test
    public void filteringInEstimationMode() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        int n = 10000;
        FilterTest.fillSketch((UpdatableSketch<Double, DoubleSummary>)sketch, 10000, 0.0);
        FilterTest.fillSketch((UpdatableSketch<Double, DoubleSummary>)sketch, 20000, 1.0);
        Filter filter = new Filter(o -> o.getValue() < 0.5);
        CompactSketch filteredSketch = filter.filter((Sketch)sketch);
        Assert.assertEquals((double)filteredSketch.getEstimate(), (double)10000.0, (double)500.0);
        Assert.assertEquals((long)filteredSketch.getThetaLong(), (long)sketch.getThetaLong());
        Assert.assertFalse((boolean)filteredSketch.isEmpty());
        Assert.assertTrue((filteredSketch.getLowerBound(1) <= filteredSketch.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((filteredSketch.getUpperBound(1) >= filteredSketch.getEstimate() ? 1 : 0) != 0);
    }

    @Test
    public void nonEmptySketchWithNoEntries() {
        UpdatableSketch sketch = new UpdatableSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(1.0E-4f).build();
        sketch.update(0L, (Object)0.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)0);
        Filter filter = new Filter(o -> true);
        CompactSketch filteredSketch = filter.filter((Sketch)sketch);
        Assert.assertFalse((boolean)filteredSketch.isEmpty());
        Assert.assertEquals((double)filteredSketch.getEstimate(), (double)sketch.getEstimate());
        Assert.assertEquals((long)filteredSketch.getThetaLong(), (long)sketch.getThetaLong());
        Assert.assertEquals((double)filteredSketch.getLowerBound(1), (double)sketch.getLowerBound(1));
        Assert.assertEquals((double)filteredSketch.getUpperBound(1), (double)sketch.getUpperBound(1));
    }

    private static void fillSketch(UpdatableSketch<Double, DoubleSummary> sketch, int numberOfElements, Double sketchValue) {
        for (int cont = 0; cont < numberOfElements; ++cont) {
            sketch.update(random.nextLong(), (Object)sketchValue);
        }
    }
}

