/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchToValuesUDTF;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.Collector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesSketchToValuesUDTFTest {
    static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("a"), Arrays.asList(stringInspector));

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeNoInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        ArrayOfDoublesSketchToValuesUDTF func = new ArrayOfDoublesSketchToValuesUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void initializeTooManyInspectors() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector, binaryInspector};
        ArrayOfDoublesSketchToValuesUDTF func = new ArrayOfDoublesSketchToValuesUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initializeWrongCategory() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        ArrayOfDoublesSketchToValuesUDTF func = new ArrayOfDoublesSketchToValuesUDTF();
        func.initialize(inspectors);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void initializeWrongType() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{stringInspector};
        ArrayOfDoublesSketchToValuesUDTF func = new ArrayOfDoublesSketchToValuesUDTF();
        func.initialize(inspectors);
    }

    @Test
    public void normalCase() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{binaryInspector};
        ArrayOfDoublesSketchToValuesUDTF func = new ArrayOfDoublesSketchToValuesUDTF();
        StructObjectInspector resultInspector = func.initialize(inspectors);
        ArrayOfDoublesSketchToValuesUDTFTest.checkResultInspector((ObjectInspector)resultInspector);
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        sketch.update(1L, new double[]{1.0, 2.0});
        sketch.update(2L, new double[]{1.0, 2.0});
        MockCollector collector = new MockCollector();
        func.setCollector((Collector)collector);
        func.process(new Object[]{new BytesWritable(sketch.toByteArray())});
        Assert.assertEquals((int)collector.list.size(), (int)2);
        Assert.assertEquals((int)((Object[])collector.list.get(0)).length, (int)1);
        Assert.assertEquals((Collection)((List)((Object[])collector.list.get(0))[0]), Arrays.asList(1.0, 2.0));
        Assert.assertEquals((Collection)((List)((Object[])collector.list.get(1))[0]), Arrays.asList(1.0, 2.0));
    }

    private static void checkResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        List fields = ((StructObjectInspector)resultInspector).getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)1);
        Assert.assertEquals((Object)((StructField)fields.get(0)).getFieldObjectInspector().getCategory(), (Object)ObjectInspector.Category.LIST);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)((ListObjectInspector)((StructField)fields.get(0)).getFieldObjectInspector()).getListElementObjectInspector()).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
    }

    private static class MockCollector
    implements Collector {
        List<Object> list = new ArrayList<Object>();

        private MockCollector() {
        }

        public void collect(Object object) throws HiveException {
            this.list.add(object);
        }
    }
}

