/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.theta.ExcludeSketchUDF;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ExcludeSketchUDFTest {
    @Test
    public void evaluateNull() {
        ExcludeSketchUDF testObject = new ExcludeSketchUDF();
        try {
            BytesWritable intermResult = testObject.evaluate(null, null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void evaluateEmpty() {
        ExcludeSketchUDF testObject = new ExcludeSketchUDF();
        try {
            BytesWritable intermResult = testObject.evaluate(new BytesWritable(), new BytesWritable());
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void evaluateValidSketch() {
        ExcludeSketchUDF testObject = new ExcludeSketchUDF();
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 100; i < 128; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact(true, null).toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact(true, null).toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output));
        AssertJUnit.assertEquals((Object)100.0, (Object)result.getEstimate());
    }

    @Test
    public void evaluateValidSketchWithDefaultSeed() {
        ExcludeSketchUDF testObject = new ExcludeSketchUDF();
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setNominalEntries(1024).build();
        for (int i = 100; i < 128; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact(true, null).toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact(true, null).toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2, 9001L);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output));
        AssertJUnit.assertEquals((Object)100.0, (Object)result.getEstimate());
    }

    @Test
    public void evaluateValidSketchWithCustomSeed() {
        ExcludeSketchUDF testObject = new ExcludeSketchUDF();
        long seed = 1L;
        UpdateSketch sketch1 = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        UpdateSketch sketch2 = Sketches.updateSketchBuilder().setSeed(1L).setNominalEntries(1024).build();
        for (int i = 100; i < 128; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.compact(true, null).toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.compact(true, null).toByteArray());
        BytesWritable output = testObject.evaluate(input1, input2, 1L);
        Sketch result = Sketches.wrapSketch((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)output), (long)1L);
        AssertJUnit.assertEquals((Object)100.0, (Object)result.getEstimate());
    }
}

