/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.hive.quantiles.GetQuantileFromStringsSketchUDF;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantileFromStringsSketchUDFTest {
    static final Comparator<String> comparator = Comparator.naturalOrder();
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();

    @Test
    public void nullSketch() {
        String result = new GetQuantileFromStringsSketchUDF().evaluate(null, 0.0);
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        sketch.update((Object)"d");
        String result = new GetQuantileFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), 0.5);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"b");
        result = new GetQuantileFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)), Boolean.valueOf(false), 0.5);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)result, (String)"c");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void fractionsWrongSketchType() {
        ItemsSketch sketch = ItemsSketch.getInstance(Long.class, Comparator.naturalOrder());
        sketch.update((Object)1L);
        sketch.update((Object)2L);
        sketch.update((Object)3L);
        new GetQuantileFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe())), 0.5);
    }
}

