/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.hive.quantiles.GetNFromStringsSketchUDF;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetNFromStringsSketchUDFTest {
    static final Comparator<String> comparator = Comparator.naturalOrder();
    static final ArrayOfItemsSerDe<String> serDe = new ArrayOfStringsSerDe();

    @Test
    public void nullSketch() {
        Long result = new GetNFromStringsSketchUDF().evaluate(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        ItemsSketch sketch = ItemsSketch.getInstance(String.class, comparator);
        sketch.update((Object)"a");
        sketch.update((Object)"b");
        sketch.update((Object)"c");
        Long result = new GetNFromStringsSketchUDF().evaluate(new BytesWritable(sketch.toByteArray(serDe)));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)3L);
    }
}

