/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import java.util.List;
import org.apache.datasketches.hive.kll.GetPmfUDF;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetPmfUDFTest {
    @Test
    public void nullSketch() {
        List result = new GetPmfUDF().evaluate(null, new Float[]{Float.valueOf(0.0f)});
        Assert.assertNull((Object)result);
    }

    @Test
    public void emptyListOfSplitPoints() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        List result = new GetPmfUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Float[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Assert.assertEquals((double)((Double)result.get(0)), (double)1.0);
    }

    @Test
    public void emptySketch() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        List result = new GetPmfUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Float[]{Float.valueOf(0.0f)});
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.update(2.0f);
        sketch.update(3.0f);
        sketch.update(4.0f);
        List result = new GetPmfUDF().evaluate(new BytesWritable(sketch.toByteArray()), new Float[]{Float.valueOf(1.0f), Float.valueOf(3.0f), Float.valueOf(5.0f)});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)4);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.25);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.25);
        Assert.assertEquals((double)((Double)result.get(3)), (double)0.0);
        result = new GetPmfUDF().evaluate(new BytesWritable(sketch.toByteArray()), Boolean.valueOf(false), new Float[]{Float.valueOf(1.0f), Float.valueOf(3.0f), Float.valueOf(5.0f)});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)4);
        Assert.assertEquals((double)((Double)result.get(0)), (double)0.0);
        Assert.assertEquals((double)((Double)result.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(2)), (double)0.5);
        Assert.assertEquals((double)((Double)result.get(3)), (double)0.0);
    }
}

