/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.cpc.UnionSketchUDF;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.io.BytesWritable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchUDFTest {
    @Test
    public void nullInputs() {
        UnionSketchUDF udf = new UnionSketchUDF();
        BytesWritable result = udf.evaluate(null, null);
        CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertTrue((boolean)resultSketch.isEmpty());
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)0.0);
    }

    @Test
    public void validSketches() {
        UnionSketchUDF udf = new UnionSketchUDF();
        CpcSketch sketch1 = new CpcSketch(11);
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        CpcSketch sketch2 = new CpcSketch(11);
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.toByteArray());
        BytesWritable result = udf.evaluate(input1, input2);
        CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)256.0, (double)5.12);
    }

    @Test
    public void validSketchesExplicitLgK() {
        UnionSketchUDF udf = new UnionSketchUDF();
        int lgK = 10;
        CpcSketch sketch1 = new CpcSketch(10);
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        CpcSketch sketch2 = new CpcSketch(10);
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.toByteArray());
        BytesWritable result = udf.evaluate(input1, input2, 10);
        CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result));
        Assert.assertEquals((int)resultSketch.getLgK(), (int)10);
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)256.0, (double)5.12);
    }

    @Test
    public void validSketchesExplicitLgKAndSeed() {
        UnionSketchUDF udf = new UnionSketchUDF();
        int lgK = 10;
        long seed = 123L;
        CpcSketch sketch1 = new CpcSketch(10, 123L);
        for (int i = 0; i < 128; ++i) {
            sketch1.update((long)i);
        }
        CpcSketch sketch2 = new CpcSketch(10, 123L);
        for (int i = 100; i < 256; ++i) {
            sketch2.update((long)i);
        }
        BytesWritable input1 = new BytesWritable(sketch1.toByteArray());
        BytesWritable input2 = new BytesWritable(sketch2.toByteArray());
        BytesWritable result = udf.evaluate(input1, input2, 10, 123L);
        CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)result), (long)123L);
        Assert.assertEquals((int)resultSketch.getLgK(), (int)10);
        Assert.assertEquals((double)resultSketch.getEstimate(), (double)256.0, (double)5.12);
    }
}

