/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.cpc;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.cpc.DataToSketchUDAF;
import org.apache.datasketches.hive.cpc.State;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DataToSketchUDAFTest {
    private static final ObjectInspector intInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT);
    private static final ObjectInspector longInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.LONG);
    private static final ObjectInspector doubleInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
    private static final ObjectInspector stringInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING);
    private static final ObjectInspector binaryInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    private static final ObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("lgK", "seed", "sketch"), Arrays.asList(intInspector, longInspector, binaryInspector));
    static final ObjectInspector intConstantInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, null);
    static final ObjectInspector longConstantInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.longTypeInfo, null);

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooFewArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void tooManyArguments() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intConstantInspector, longConstantInspector, longConstantInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg1() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void invalidCategoryArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void invalidTypeArg2() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, stringInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentException.class})
    public void arg2notConst() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidCategoryArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intConstantInspector, structInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void invalidTypeArg3() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intConstantInspector, doubleInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test(expectedExceptions={UDFArgumentTypeException.class})
    public void arg3notConst() throws SemanticException {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector, intConstantInspector, longInspector};
        SimpleGenericUDAFParameterInfo params = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)params);
    }

    @Test
    public void partial1ModeIntKeysDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)11);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)9001L);
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.01);
        }
    }

    @Test
    public void partial1ModeStringKeysExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{stringInspector, intConstantInspector, longConstantInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL1, inspectors);
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            int lgK = 10;
            long seed = 123L;
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("a"), new IntWritable(10), new LongWritable(123L)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new Text("b"), new IntWritable(10), new LongWritable(123L)});
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)10);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)123L);
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))), (long)123L);
            Assert.assertEquals((int)resultSketch.getLgK(), (int)10);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.01);
        }
    }

    @Test
    public void partial2Mode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.PARTIAL2, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkIntermediateResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            CpcSketch sketch1 = new CpcSketch(11);
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(11), new LongWritable(9001L), new BytesWritable(sketch1.toByteArray())));
            CpcSketch sketch2 = new CpcSketch(11);
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(11), new LongWritable(9001L), new BytesWritable(sketch2.toByteArray())));
            Object result = eval.terminatePartial((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof List));
            List r = (List)result;
            Assert.assertEquals((int)r.size(), (int)3);
            Assert.assertEquals((int)((IntWritable)r.get(0)).get(), (int)11);
            Assert.assertEquals((long)((LongWritable)r.get(1)).get(), (long)9001L);
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)r.get(2))));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.01);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void finalMode() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            CpcSketch sketch1 = new CpcSketch(11);
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(11), new LongWritable(9001L), new BytesWritable(sketch1.toByteArray())));
            CpcSketch sketch2 = new CpcSketch(11);
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(11), new LongWritable(9001L), new BytesWritable(sketch2.toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.01);
        }
    }

    @Test
    public void finalModeCustomSeed() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.FINAL, new ObjectInspector[]{structInspector});
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            long seed = 123L;
            State state = (State)eval.getNewAggregationBuffer();
            CpcSketch sketch1 = new CpcSketch(11, 123L);
            sketch1.update(1L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(11), new LongWritable(123L), new BytesWritable(sketch1.toByteArray())));
            CpcSketch sketch2 = new CpcSketch(11, 123L);
            sketch2.update(2L);
            eval.merge((GenericUDAFEvaluator.AggregationBuffer)state, Arrays.asList(new IntWritable(11), new LongWritable(123L), new BytesWritable(sketch2.toByteArray())));
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (long)123L);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.01);
        }
    }

    @Test
    public void completeModeIntKeysDefaultParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{intInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(1)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new IntWritable(2)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)));
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.01);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    @Test
    public void completeModeDoubleKeysExplicitParams() throws Exception {
        ObjectInspector[] inspectors = new ObjectInspector[]{doubleInspector, intConstantInspector, longConstantInspector};
        SimpleGenericUDAFParameterInfo info = new SimpleGenericUDAFParameterInfo(inspectors, false, false, false);
        try (GenericUDAFEvaluator eval = new DataToSketchUDAF().getEvaluator((GenericUDAFParameterInfo)info);){
            ObjectInspector resultInspector = eval.init(GenericUDAFEvaluator.Mode.COMPLETE, inspectors);
            DataToSketchUDAFTest.checkFinalResultInspector(resultInspector);
            int lgK = 4;
            long seed = 123L;
            State state = (State)eval.getNewAggregationBuffer();
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(1.0), new IntWritable(4), new LongWritable(123L)});
            eval.iterate((GenericUDAFEvaluator.AggregationBuffer)state, new Object[]{new DoubleWritable(2.0), new IntWritable(4), new LongWritable(123L)});
            Object result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof BytesWritable));
            CpcSketch resultSketch = CpcSketch.heapify((Memory)BytesWritableHelper.wrapAsMemory((BytesWritable)((BytesWritable)result)), (long)123L);
            Assert.assertEquals((int)resultSketch.getLgK(), (int)4);
            Assert.assertEquals((double)resultSketch.getEstimate(), (double)2.0, (double)0.03);
            eval.reset((GenericUDAFEvaluator.AggregationBuffer)state);
            result = eval.terminate((GenericUDAFEvaluator.AggregationBuffer)state);
            Assert.assertNull((Object)result);
        }
    }

    static void checkIntermediateResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.STRUCT);
        StructObjectInspector structResultInspector = (StructObjectInspector)resultInspector;
        List fields = structResultInspector.getAllStructFieldRefs();
        Assert.assertEquals((int)fields.size(), (int)3);
        ObjectInspector inspector1 = ((StructField)fields.get(0)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector1.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector1 = (PrimitiveObjectInspector)inspector1;
        Assert.assertEquals((Object)primitiveInspector1.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        ObjectInspector inspector2 = ((StructField)fields.get(1)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector2.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector2 = (PrimitiveObjectInspector)inspector2;
        Assert.assertEquals((Object)primitiveInspector2.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.LONG);
        ObjectInspector inspector3 = ((StructField)fields.get(2)).getFieldObjectInspector();
        Assert.assertEquals((Object)inspector3.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        PrimitiveObjectInspector primitiveInspector3 = (PrimitiveObjectInspector)inspector3;
        Assert.assertEquals((Object)primitiveInspector3.getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    static void checkFinalResultInspector(ObjectInspector resultInspector) {
        Assert.assertNotNull((Object)resultInspector);
        Assert.assertEquals((Object)resultInspector.getCategory(), (Object)ObjectInspector.Category.PRIMITIVE);
        Assert.assertEquals((Object)((PrimitiveObjectInspector)resultInspector).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }
}

