/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.dpath;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.runtime1.dpath.ByteToLong$;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.DFDLConstructorFunction;
import org.apache.daffodil.runtime1.dpath.DFDLUnsignedLong$;
import org.apache.daffodil.runtime1.dpath.DState;
import org.apache.daffodil.runtime1.dpath.DecimalToUnsignedLong$;
import org.apache.daffodil.runtime1.dpath.HexStringToUnsignedLong$;
import org.apache.daffodil.runtime1.dpath.IntToLong$;
import org.apache.daffodil.runtime1.dpath.IntegerToUnsignedLong$;
import org.apache.daffodil.runtime1.dpath.LongToUnsignedLong$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.ShortToLong$;
import org.apache.daffodil.runtime1.dpath.StringToUnsignedLong$;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class DFDLUnsignedLong
extends DFDLConstructorFunction
implements Product {
    private final CompiledDPath recipe;
    private final NodeInfo.Kind argType;
    private final String constructorName;
    private final int maxHexDigits;

    public static DFDLUnsignedLong apply(CompiledDPath compiledDPath, NodeInfo.Kind kind) {
        return DFDLUnsignedLong$.MODULE$.apply(compiledDPath, kind);
    }

    public static DFDLUnsignedLong fromProduct(Product product) {
        return DFDLUnsignedLong$.MODULE$.fromProduct(product);
    }

    public static DFDLUnsignedLong unapply(DFDLUnsignedLong dFDLUnsignedLong) {
        return DFDLUnsignedLong$.MODULE$.unapply(dFDLUnsignedLong);
    }

    public DFDLUnsignedLong(CompiledDPath recipe, NodeInfo.Kind argType) {
        this.recipe = recipe;
        this.argType = argType;
        super(recipe, argType);
        this.constructorName = "unsignedLong";
        this.maxHexDigits = 16;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DFDLUnsignedLong)) return false;
        DFDLUnsignedLong dFDLUnsignedLong = (DFDLUnsignedLong)object;
        CompiledDPath compiledDPath = this.recipe();
        CompiledDPath compiledDPath2 = dFDLUnsignedLong.recipe();
        if (compiledDPath == null) {
            if (compiledDPath2 != null) {
                return false;
            }
        } else if (!compiledDPath.equals(compiledDPath2)) return false;
        NodeInfo.Kind kind = this.argType();
        NodeInfo.Kind kind2 = dFDLUnsignedLong.argType();
        if (kind == null) {
            if (kind2 != null) {
                return false;
            }
        } else if (!kind.equals(kind2)) return false;
        if (!dFDLUnsignedLong.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DFDLUnsignedLong;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "DFDLUnsignedLong";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "recipe";
        }
        if (1 == n2) {
            return "argType";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public CompiledDPath recipe() {
        return this.recipe;
    }

    public NodeInfo.Kind argType() {
        return this.argType;
    }

    @Override
    public String constructorName() {
        return this.constructorName;
    }

    @Override
    public int maxHexDigits() {
        return this.maxHexDigits;
    }

    @Override
    public BigInteger convert(Long longValue, DState dstate) {
        return DataValue$.MODULE$.toDataValue(Numbers$.MODULE$.asBigInt(DataValue$.MODULE$.getLong$extension(longValue)));
    }

    @Override
    public Object computeValue(Object a, DState dstate) {
        BigInteger bigInteger;
        Object object = DataValue$.MODULE$.getAnyRef$extension(a);
        if (object instanceof Byte) {
            Long l = ByteToLong$.MODULE$.computeValue(a, dstate);
            bigInteger = LongToUnsignedLong$.MODULE$.computeValue(l, dstate);
        } else if (object instanceof Short) {
            Long l = ShortToLong$.MODULE$.computeValue(a, dstate);
            bigInteger = LongToUnsignedLong$.MODULE$.computeValue(l, dstate);
        } else if (object instanceof Integer) {
            Long l = IntToLong$.MODULE$.computeValue(a, dstate);
            bigInteger = LongToUnsignedLong$.MODULE$.computeValue(l, dstate);
        } else if (object instanceof String) {
            String s = (String)object;
            if (s.startsWith("x")) {
                String hexStr = s.substring(1);
                if (hexStr.length() > this.maxHexDigits()) {
                    throw new NumberFormatException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this.hexMsg()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)hexStr.length())})));
                }
                bigInteger = HexStringToUnsignedLong$.MODULE$.computeValue(DataValue$.MODULE$.toDataValue(hexStr), dstate);
            } else {
                bigInteger = StringToUnsignedLong$.MODULE$.computeValue(a, dstate);
            }
        } else if (object instanceof BigInteger) {
            bigInteger = IntegerToUnsignedLong$.MODULE$.computeValue(a, dstate);
        } else if (object instanceof BigDecimal) {
            bigInteger = DecimalToUnsignedLong$.MODULE$.computeValue(a, dstate);
        } else {
            Object x = object;
            throw new NumberFormatException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(this.nfeMsg()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x})));
        }
        BigInteger ulong = bigInteger;
        return ulong;
    }

    public DFDLUnsignedLong copy(CompiledDPath recipe, NodeInfo.Kind argType) {
        return new DFDLUnsignedLong(recipe, argType);
    }

    public CompiledDPath copy$default$1() {
        return this.recipe();
    }

    public NodeInfo.Kind copy$default$2() {
        return this.argType();
    }

    public CompiledDPath _1() {
        return this.recipe();
    }

    public NodeInfo.Kind _2() {
        return this.argType();
    }
}

