/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.javascript.BasicNameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.service.ServiceJavascriptBuilder;
import org.apache.cxf.javascript.types.SchemaJavascriptBuilder;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;

public class JavascriptGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final Interceptor<? extends Message> INSTANCE = new JavascriptGetInterceptor();
    private static final String JS_UTILS_PATH = "/org/apache/cxf/javascript/cxf-utils.js";
    private static final String NO_UTILS_QUERY_KEY = "nojsutils";
    private static final String CODE_QUERY_KEY = "js";

    public JavascriptGetInterceptor() {
        super("read");
        this.getAfter().add(EndpointSelectionInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        URI uri;
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty((String)query)) {
            return;
        }
        String baseUri = (String)message.get((Object)"org.apache.cxf.request.url");
        try {
            uri = URI.create(baseUri);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        Map map = UrlUtils.parseQueryString((String)query);
        if (this.isRecognizedQuery(map, uri, message.getExchange().getEndpoint().getEndpointInfo())) {
            try {
                Conduit c = message.getExchange().getDestination().getBackChannel(message);
                MessageImpl mout = new MessageImpl();
                mout.setExchange(message.getExchange());
                message.getExchange().setOutMessage((Message)mout);
                mout.put((Object)"Content-Type", (Object)"application/javascript;charset=UTF-8");
                c.prepare((Message)mout);
                OutputStream os = (OutputStream)mout.getContent(OutputStream.class);
                this.writeResponse(uri, map, os, message.getExchange().getEndpoint());
                message.getInterceptorChain().pause();
            }
            catch (IOException ioe) {
                throw new Fault((Throwable)ioe);
            }
        }
    }

    private boolean isRecognizedQuery(Map<String, String> map, URI uri, EndpointInfo endpointInfo) {
        if (uri == null) {
            return false;
        }
        return map.containsKey(CODE_QUERY_KEY);
    }

    public static void writeUtilsToResponseStream(Class<?> referenceClass, OutputStream outputStream) {
        try (InputStream utils = referenceClass.getResourceAsStream(JS_UTILS_PATH);){
            if (utils == null) {
                throw new RuntimeException("Unable to get stream for /org/apache/cxf/javascript/cxf-utils.js");
            }
            IOUtils.copy((InputStream)utils, (OutputStream)outputStream, (int)4096);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write javascript utils to HTTP response.", e);
        }
    }

    private void writeResponse(URI uri, Map<String, String> map, OutputStream os, Endpoint serverEndpoint) {
        if (!map.containsKey(NO_UTILS_QUERY_KEY)) {
            JavascriptGetInterceptor.writeUtilsToResponseStream(JavascriptGetInterceptor.class, os);
        }
        if (map.containsKey(CODE_QUERY_KEY)) {
            ServiceInfo serviceInfo = (ServiceInfo)serverEndpoint.getService().getServiceInfos().get(0);
            List schemata = serviceInfo.getSchemas();
            BasicNameManager nameManager = BasicNameManager.newNameManager(serviceInfo, serverEndpoint);
            NamespacePrefixAccumulator prefixManager = new NamespacePrefixAccumulator(serviceInfo.getXmlSchemaCollection());
            try {
                OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                for (SchemaInfo schema : schemata) {
                    SchemaJavascriptBuilder builder = new SchemaJavascriptBuilder(serviceInfo.getXmlSchemaCollection(), prefixManager, nameManager);
                    String allThatJavascript = builder.generateCodeForSchema(schema.getSchema());
                    writer.append(allThatJavascript);
                }
                ServiceJavascriptBuilder serviceBuilder = new ServiceJavascriptBuilder(serviceInfo, serverEndpoint.getEndpointInfo().getAddress(), prefixManager, nameManager);
                serviceBuilder.walk();
                String serviceJavascript = serviceBuilder.getCode();
                writer.append(serviceJavascript);
                writer.flush();
            }
            catch (IOException e) {
                throw new UncheckedException((Throwable)e);
            }
        } else {
            throw new RuntimeException("Invalid query " + uri.toString());
        }
    }
}

