/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V4;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateAddressMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSharedQueueMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectConsumerWithKillMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.DisconnectMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.FederationDownstreamConnectMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.NullResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.PacketsConfirmedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.Ping;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.RollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionAddMetaDataMessageV2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V4;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionBindingQueryResponseMessage_V5;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCommitMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerCloseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionConsumerFlowCreditMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCreateConsumerMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionDeleteQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionExpireMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionForceConsumerDelivery;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionIndividualAcknowledgeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsFailMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionQueueQueryResponseMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionReceiveContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionRequestProducerCreditsMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionSendContinuationMessage_V3;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionUniqueAddMetaDataMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAAfterFailedMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXACommitMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAEndMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAForgetMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetInDoubtXidsResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAGetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAJoinMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAPrepareMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResponseMessage_V2;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAResumeMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXARollbackMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXASetTimeoutResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionXAStartMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;

public abstract class PacketDecoder
implements Serializable {
    public abstract Packet decode(ActiveMQBuffer var1, CoreRemotingConnection var2);

    public Packet decode(byte packetType, CoreRemotingConnection connection) {
        return switch (packetType) {
            case 10 -> new Ping();
            case 11 -> new DisconnectMessage();
            case 124 -> new DisconnectMessage_V2();
            case 12 -> new DisconnectConsumerMessage();
            case 20 -> {
                if (connection.isVersionBeforeAsyncResponseChange()) {
                    yield new ActiveMQExceptionMessage();
                }
                yield new ActiveMQExceptionMessage_V2();
            }
            case 22 -> new PacketsConfirmedMessage();
            case 21 -> {
                if (connection.isVersionBeforeAsyncResponseChange()) {
                    yield new NullResponseMessage();
                }
                yield new NullResponseMessage_V2();
            }
            case 30 -> new CreateSessionMessage();
            case -4 -> new CheckFailoverMessage();
            case 31 -> new CreateSessionResponseMessage();
            case 32 -> new ReattachSessionMessage();
            case 33 -> new ReattachSessionResponseMessage();
            case 69 -> new SessionCloseMessage();
            case 40 -> new SessionCreateConsumerMessage();
            case 41 -> new SessionAcknowledgeMessage();
            case 42 -> new SessionExpireMessage();
            case 43 -> {
                if (!connection.isVersionSupportCommitV2()) {
                    yield new SessionCommitMessage();
                }
                yield new SessionCommitMessage_V2();
            }
            case 44 -> new RollbackMessage();
            case 45 -> new SessionQueueQueryMessage();
            case 46 -> new SessionQueueQueryResponseMessage();
            case -7 -> new SessionQueueQueryResponseMessage_V2();
            case -14 -> new SessionQueueQueryResponseMessage_V3();
            case -11 -> new CreateAddressMessage();
            case 34 -> new CreateQueueMessage();
            case -12 -> new CreateQueueMessage_V2();
            case 36 -> new CreateSharedQueueMessage();
            case -13 -> new CreateSharedQueueMessage_V2();
            case 35 -> new SessionDeleteQueueMessage();
            case 49 -> new SessionBindingQueryMessage();
            case 50 -> new SessionBindingQueryResponseMessage();
            case -8 -> new SessionBindingQueryResponseMessage_V2();
            case -10 -> new SessionBindingQueryResponseMessage_V3();
            case -15 -> new SessionBindingQueryResponseMessage_V4();
            case -22 -> new SessionBindingQueryResponseMessage_V5();
            case 51 -> new SessionXAStartMessage();
            case 39 -> new SessionXAAfterFailedMessage();
            case 52 -> new SessionXAEndMessage();
            case 53 -> new SessionXACommitMessage();
            case 54 -> new SessionXAPrepareMessage();
            case 55 -> {
                if (connection.isVersionBeforeAsyncResponseChange()) {
                    yield new SessionXAResponseMessage();
                }
                yield new SessionXAResponseMessage_V2();
            }
            case 56 -> new SessionXARollbackMessage();
            case 57 -> new SessionXAJoinMessage();
            case 58 -> new PacketImpl(58);
            case 59 -> new SessionXAResumeMessage();
            case 60 -> new SessionXAForgetMessage();
            case 61 -> new PacketImpl(61);
            case 62 -> new SessionXAGetInDoubtXidsResponseMessage();
            case 63 -> new SessionXASetTimeoutMessage();
            case 64 -> new SessionXASetTimeoutResponseMessage();
            case 65 -> new PacketImpl(65);
            case 66 -> new SessionXAGetTimeoutResponseMessage();
            case 67 -> new PacketImpl(67);
            case 68 -> new PacketImpl(68);
            case 70 -> new SessionConsumerFlowCreditMessage();
            case 74 -> new SessionConsumerCloseMessage();
            case 81 -> new SessionIndividualAcknowledgeMessage();
            case 77 -> new SessionReceiveContinuationMessage();
            case 73 -> {
                if (connection.isVersionBeforeAsyncResponseChange()) {
                    yield new SessionSendContinuationMessage();
                }
                if (connection.isBeforeProducerMetricsChanged()) {
                    yield new SessionSendContinuationMessage_V2();
                }
                yield new SessionSendContinuationMessage_V3();
            }
            case 79 -> new SessionRequestProducerCreditsMessage();
            case 80 -> new SessionProducerCreditsMessage();
            case 82 -> new SessionProducerCreditsFailMessage();
            case 78 -> new SessionForceConsumerDelivery();
            case 110 -> new ClusterTopologyChangeMessage();
            case 114 -> new ClusterTopologyChangeMessage_V2();
            case 122 -> new ClusterTopologyChangeMessage_V3();
            case 112 -> new SubscribeClusterTopologyUpdatesMessage();
            case 113 -> new SubscribeClusterTopologyUpdatesMessageV2();
            case 104 -> new SessionAddMetaDataMessage();
            case 105 -> new SessionAddMetaDataMessageV2();
            case 106 -> new SessionUniqueAddMetaDataMessage();
            case -5 -> new CheckFailoverReplyMessage();
            case 13 -> new DisconnectConsumerWithKillMessage();
            case -16 -> new FederationDownstreamConnectMessage();
            case -17 -> new ClusterTopologyChangeMessage_V4();
            case -18 -> new CreateSessionMessage_V2();
            case -19 -> new DisconnectMessage_V3();
            default -> throw ActiveMQClientMessageBundle.BUNDLE.invalidType(packetType);
        };
    }
}

