/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public final class DiscoveryGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 8657206421727863400L;
    private String name = UUIDGenerator.getInstance().generateStringUUID();
    private long refreshTimeout = 10000L;
    private long discoveryInitialWaitTimeout = 10000L;
    private BroadcastEndpointFactory endpointFactory;

    public String getName() {
        return this.name;
    }

    public long getRefreshTimeout() {
        return this.refreshTimeout;
    }

    public DiscoveryGroupConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public DiscoveryGroupConfiguration setRefreshTimeout(long refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
        return this;
    }

    public long getDiscoveryInitialWaitTimeout() {
        return this.discoveryInitialWaitTimeout;
    }

    public DiscoveryGroupConfiguration setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
        return this;
    }

    public BroadcastEndpointFactory getBroadcastEndpointFactory() {
        return this.endpointFactory;
    }

    public DiscoveryGroupConfiguration setBroadcastEndpointFactory(BroadcastEndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryGroupConfiguration that = (DiscoveryGroupConfiguration)o;
        if (this.discoveryInitialWaitTimeout != that.discoveryInitialWaitTimeout) {
            return false;
        }
        if (this.refreshTimeout != that.refreshTimeout) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (int)(this.refreshTimeout ^ this.refreshTimeout >>> 32);
        result = 31 * result + (int)(this.discoveryInitialWaitTimeout ^ this.discoveryInitialWaitTimeout >>> 32);
        return result;
    }

    public String toString() {
        return "DiscoveryGroupConfiguration{name='" + this.name + "', refreshTimeout=" + this.refreshTimeout + ", discoveryInitialWaitTimeout=" + this.discoveryInitialWaitTimeout + "}";
    }
}

