/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.activemq.artemis.api.core.management.RemoteBrokerConnectionControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.RemoteBrokerConnection;
import org.apache.activemq.artemis.logs.AuditLogger;

public class RemoteBrokerConnectionControlImpl
extends AbstractControl
implements RemoteBrokerConnectionControl {
    private final RemoteBrokerConnection connection;

    public RemoteBrokerConnectionControlImpl(RemoteBrokerConnection connection, StorageManager storageManager) throws NotCompliantMBeanException {
        super(RemoteBrokerConnectionControl.class, storageManager);
        this.connection = connection;
    }

    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.connection);
        }
        this.clearIO();
        try {
            String string = this.connection.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getNodeId() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getNodeID((Object)this.connection);
        }
        this.clearIO();
        try {
            String string = this.connection.getNodeId();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getProtocol() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getProtocol((Object)this.connection);
        }
        this.clearIO();
        try {
            String string = this.connection.getProtocol();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(RemoteBrokerConnectionControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(RemoteBrokerConnectionControl.class);
    }
}

