/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.resourceadapter.AbstractManagedConnectionFactoryImpl;
import org.apache.cxf.jca.core.resourceadapter.AbstractManagedConnectionImpl;
import org.apache.cxf.jca.cxf.CXFManagedConnectionFactory;
import org.apache.cxf.jca.cxf.ConnectionFactoryImpl;
import org.apache.cxf.jca.cxf.JCABusFactory;
import org.apache.cxf.jca.cxf.ManagedConnectionImpl;

public class ManagedConnectionFactoryImpl
extends AbstractManagedConnectionFactoryImpl
implements CXFManagedConnectionFactory {
    private static final long serialVersionUID = -891927761318109853L;
    private static final Logger LOG = LogUtils.getL7dLogger(ManagedConnectionFactoryImpl.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ManagedConnectionFactoryImpl.class);
    protected JCABusFactory jcaBusFactory;

    public ManagedConnectionFactoryImpl() {
        LOG.info("ManagedConnectionFactoryImpl constructed without props by appserver...");
    }

    public ManagedConnectionFactoryImpl(Properties props) {
        super(props);
        LOG.info("ManagedConnectionFactoryImpl constructed with props by appserver. props = " + props);
    }

    public void setLogLevel(String logLevel) {
        this.setProperty("log.level", logLevel);
    }

    public void setEJBServicePropertiesURL(String name) {
        this.setProperty("ejb.service.properties.url", name);
    }

    public void setMonitorEJBServiceProperties(Boolean monitor) {
        this.setProperty("monitor.ejb.service.properties", monitor.toString());
    }

    public void setEJBServicePropertiesPollInterval(Integer pollInterval) {
        this.setProperty("monitor.poll.interval", pollInterval.toString());
    }

    public String getLogLevel() {
        return this.getPluginProps().getProperty("log.level");
    }

    public String getEJBServicePropertiesURL() {
        return this.getPluginProps().getProperty("ejb.service.properties.url");
    }

    public Boolean getMonitorEJBServiceProperties() {
        return Boolean.valueOf(this.getPluginProps().getProperty("monitor.ejb.service.properties"));
    }

    public Integer getEJBServicePropertiesPollInterval() {
        return Integer.valueOf(this.getPluginProps().getProperty("monitor.poll.interval", "120"));
    }

    public URL getEJBServicePropertiesURLInstance() throws ResourceException {
        return this.getPropsURL(this.getEJBServicePropertiesURL());
    }

    public String getEJBServantBaseURL() throws ResourceException {
        return this.getPluginProps().getProperty("ejb.servant.base.url");
    }

    public void setEJBServantBaseURL(String url) throws ResourceException {
        this.setProperty("ejb.servant.base.url", url);
    }

    @Override
    protected void validateReference(AbstractManagedConnectionImpl conn, Subject subj) {
    }

    @Override
    public Object createConnectionFactory() throws ResourceException {
        throw new org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException(new Message("NON_MANAGED_CONNECTION_IS_NOT_SUPPORTED", BUNDLE, new Object[0]).toString());
    }

    @Override
    public Object createConnectionFactory(ConnectionManager connMgr) throws ResourceException {
        LOG.info("connManager=" + connMgr);
        if (connMgr == null) {
            throw new org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException(new Message("NON_MANAGED_CONNECTION_IS_NOT_SUPPORTED", BUNDLE, new Object[0]).toString());
        }
        this.init(connMgr.getClass().getClassLoader());
        LOG.fine("Setting AppServer classloader in jcaBusFactory. " + connMgr.getClass().getClassLoader());
        return new ConnectionFactoryImpl(this, connMgr);
    }

    @Override
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connReqInfo) throws ResourceException {
        LOG.info("create connection, subject=" + subject + " connReqInfo=" + connReqInfo);
        this.init(Thread.currentThread().getContextClassLoader());
        return new ManagedConnectionImpl(this, connReqInfo, subject);
    }

    @Override
    public void close() throws ResourceAdapterInternalException {
    }

    protected synchronized void init(ClassLoader appserverClassLoader) throws ResourceException {
        if (this.jcaBusFactory == null) {
            this.jcaBusFactory = new JCABusFactory(this);
            this.jcaBusFactory.create(appserverClassLoader, this.getBootstrapContext());
        }
    }

    public Bus getBus() {
        return this.jcaBusFactory != null ? this.jcaBusFactory.getBus() : null;
    }

    protected Object getBootstrapContext() {
        return null;
    }
}

