/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedBiPredicate<T, U>
extends AbstractScriptEvaluator
implements BiPredicate<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedBiPredicate.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    protected ScriptedBiPredicate(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
        this.setLogPrefix("Scripted BiPredicate from " + extraInfo + ":");
    }

    protected ScriptedBiPredicate(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
        this.setLogPrefix("Anonymous BiPredicate:");
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    public void setReturnOnError(boolean flag) {
        this.setReturnOnError((Object)flag);
    }

    @Override
    public boolean test(@Nullable T first, @Nullable U second) {
        Object result;
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            if (null != first && !types.getFirst().isInstance(first)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), first.getClass(), types.getFirst()});
                return (Boolean)this.getReturnOnError();
            }
            if (null != second && !types.getSecond().isInstance(second)) {
                this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), second.getClass(), types.getSecond()});
                return (Boolean)this.getReturnOnError();
            }
        }
        return (Boolean)((result = this.evaluate(first, second)) != null ? result : this.getReturnOnError());
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input1", input[0], 100);
        scriptContext.setAttribute("input2", input[1], 100);
    }

    public static <T, U> ScriptedBiPredicate<T, U> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedBiPredicate<T, U> scriptedBiPredicate = new ScriptedBiPredicate<T, U>(script, resource.getDescription());
            return scriptedBiPredicate;
        }
    }

    public static <T, U> ScriptedBiPredicate<T, U> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedBiPredicate.resourceScript("JavaScript", resource);
    }

    public static <T, U> ScriptedBiPredicate<T, U> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedBiPredicate<T, U>(script, "Inline");
    }

    public static <T, U> ScriptedBiPredicate<T, U> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedBiPredicate<T, U>(script, "Inline");
    }
}

