/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class UrlResource
extends AbstractFileResolvingResource {
    @Nullable
    private final URI uri;
    private final URL url;
    @Nullable
    private volatile String cleanedUrl;

    public UrlResource(URL url) {
        Assert.notNull((Object)url, "URL must not be null");
        this.uri = null;
        this.url = url;
    }

    public UrlResource(URI uri) throws MalformedURLException {
        Assert.notNull((Object)uri, "URI must not be null");
        this.uri = uri;
        this.url = uri.toURL();
    }

    public UrlResource(String path) throws MalformedURLException {
        Assert.notNull((Object)path, "Path must not be null");
        this.uri = null;
        this.url = ResourceUtils.toURL(path);
        this.cleanedUrl = StringUtils.cleanPath(path);
    }

    public UrlResource(String protocol, String location) throws MalformedURLException {
        this(protocol, location, null);
    }

    public UrlResource(String protocol, String location, @Nullable String fragment) throws MalformedURLException {
        try {
            this.uri = new URI(protocol, location, fragment);
            this.url = this.uri.toURL();
        }
        catch (URISyntaxException ex) {
            MalformedURLException exToThrow = new MalformedURLException(ex.getMessage());
            exToThrow.initCause(ex);
            throw exToThrow;
        }
    }

    public static UrlResource from(URI uri) throws UncheckedIOException {
        try {
            return new UrlResource(uri);
        }
        catch (MalformedURLException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static UrlResource from(String path) throws UncheckedIOException {
        try {
            return new UrlResource(path);
        }
        catch (MalformedURLException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private String getCleanedUrl() {
        String cleanedUrl = this.cleanedUrl;
        if (cleanedUrl != null) {
            return cleanedUrl;
        }
        String originalPath = (this.uri != null ? this.uri : this.url).toString();
        this.cleanedUrl = cleanedUrl = StringUtils.cleanPath(originalPath);
        return cleanedUrl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        this.customizeConnection(con);
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpConn = (HttpURLConnection)con;
                httpConn.disconnect();
            }
            throw ex;
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public URI getURI() throws IOException {
        if (this.uri != null) {
            return this.uri;
        }
        return super.getURI();
    }

    @Override
    public boolean isFile() {
        if (this.uri != null) {
            return super.isFile(this.uri);
        }
        return super.isFile();
    }

    @Override
    public File getFile() throws IOException {
        if (this.uri != null) {
            return super.getFile(this.uri);
        }
        return super.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws MalformedURLException {
        return new UrlResource(this.createRelativeURL(relativePath));
    }

    protected URL createRelativeURL(String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return ResourceUtils.toRelativeURL(this.url, relativePath);
    }

    @Override
    @Nullable
    public String getFilename() {
        if (this.uri != null) {
            return StringUtils.getFilename(this.uri.getPath());
        }
        String filename = StringUtils.getFilename(StringUtils.cleanPath(this.url.getPath()));
        return filename != null ? URLDecoder.decode(filename, StandardCharsets.UTF_8) : null;
    }

    @Override
    public String getDescription() {
        return "URL [" + (this.uri != null ? this.uri : this.url) + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof UrlResource)) return false;
        UrlResource that = (UrlResource)other;
        if (!this.getCleanedUrl().equals(that.getCleanedUrl())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.getCleanedUrl().hashCode();
    }
}

