/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ObjectMessage;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.RelayHeader;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.Relayer3;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteStatus;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.NameCache;
import org.jgroups.util.SuppressLog;
import org.jgroups.util.UUID;

@MBean(description="RELAY3 protocol")
public class RELAY3
extends RELAY {
    @ManagedAttribute(description="A cache maintaining a list of sites that are up")
    protected final SiteStatus site_status = new SiteStatus();

    public SiteStatus siteStatus() {
        return this.site_status;
    }

    @Override
    public void configure() throws Exception {
        super.configure();
        JChannel ch = this.getProtocolStack().getChannel();
        ch.addAddressGenerator(new AddressGenerator(){

            @Override
            public Address generateAddress() {
                return this.generateAddress(null);
            }

            @Override
            public Address generateAddress(String name) {
                SiteUUID uuid = new SiteUUID(UUID.randomUUID(), name, RELAY3.this.site);
                if (RELAY3.this.can_become_site_master) {
                    uuid.setFlag((short)2);
                }
                return uuid;
            }
        });
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printTopology(boolean all_sites) {
        if (!all_sites) {
            return this.printLocalTopology();
        }
        return this.topo.print();
    }

    @ManagedOperation(description="Prints the topology (site masters and local members) of this site")
    public String printLocalTopology() {
        return this.topo.print(this.site);
    }

    @Override
    public Object down(Message msg) {
        msg.src(this.local_addr);
        return this.process(true, msg);
    }

    @Override
    public Object up(Message msg) {
        Message copy = msg;
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        if (hdr != null) {
            if (hdr.getType() == 2) {
                this.triggerSiteUnreachableEvent((SiteAddress)hdr.final_dest);
                return null;
            }
            copy = this.copy(msg).dest(hdr.final_dest).src(hdr.original_sender).putHeader(this.id, hdr);
        }
        return this.process(false, copy);
    }

    @Override
    public void up(MessageBatch batch) {
        ArrayList<SiteAddress> unreachable_sites = null;
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg;
            Message copy = msg = it.next();
            RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
            it.remove();
            if (hdr != null) {
                if (hdr.getType() == 2) {
                    boolean contains;
                    SiteAddress site_addr = (SiteAddress)hdr.final_dest;
                    String site_name = site_addr.getSite();
                    if (unreachable_sites == null) {
                        unreachable_sites = new ArrayList<SiteAddress>();
                    }
                    if (contains = unreachable_sites.stream().anyMatch(sa -> sa.getSite().equals(site_name))) continue;
                    unreachable_sites.add(site_addr);
                    continue;
                }
                copy = this.copy(msg).dest(hdr.final_dest).src(hdr.original_sender).putHeader(this.id, hdr);
            }
            this.process(false, copy);
        }
        if (unreachable_sites != null) {
            for (SiteAddress sa2 : unreachable_sites) {
                this.triggerSiteUnreachableEvent(sa2);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void sendResponseTo(Address dest, boolean all_sites) {
        if (all_sites) {
            this.sendResponsesForAllSites(dest);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("%s: sending topo response to %s: %s", this.local_addr, dest, this.view);
        }
        RelayHeader hdr = new RelayHeader(7, dest, this.local_addr).addToSites(this.site);
        Message rsp = new ObjectMessage(dest, this.view).putHeader(this.id, hdr);
        this.down(rsp);
    }

    protected void sendResponsesForAllSites(Address dest) {
        for (Map.Entry<String, View> e : this.topo.cache().entrySet()) {
            String site_name = e.getKey();
            View v = e.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug("%s: sending topo response to %s: %s", this.local_addr, dest, this.view);
            }
            RelayHeader hdr = new RelayHeader(7, dest, this.local_addr).addToSites(site_name);
            Message rsp = new ObjectMessage(dest, v).putHeader(this.id, hdr);
            this.down(rsp);
        }
    }

    @Override
    public void handleView(View view) {
        View old_view = this.view;
        this.view = view;
        this.members = view.getMembers();
        int max_num_site_masters = this.max_site_masters;
        if (this.site_masters_ratio > 0.0) {
            max_num_site_masters = (int)Math.max((double)this.max_site_masters, this.site_masters_ratio * (double)view.size());
        }
        List old_site_masters = this.site_masters;
        List<Address> new_site_masters = RELAY3.determineSiteMasters(view, max_num_site_masters);
        boolean become_site_master = new_site_masters.contains(this.local_addr) && (old_site_masters == null || !old_site_masters.contains(this.local_addr));
        boolean cease_site_master = old_site_masters != null && old_site_masters.contains(this.local_addr) && !new_site_masters.contains(this.local_addr);
        this.site_masters = new_site_masters;
        if (!this.site_masters.isEmpty() && ((Address)this.site_masters.get(0)).equals(this.local_addr)) {
            this.broadcast_route_notifications = true;
        }
        if (become_site_master) {
            this.is_site_master = true;
            String bridge_name = "_" + NameCache.get(this.local_addr);
            if (this.relayer != null) {
                this.relayer.stop();
            }
            this.relayer = new Relayer3(this, this.log);
            Relayer3 tmp = (Relayer3)this.relayer;
            long start = System.currentTimeMillis();
            if (this.async_relay_creation) {
                this.timer.execute(() -> this.startRelayer(tmp, bridge_name).handleAsync((r, t) -> this.handleRelayerStarted(this.relayer, start, (Object)r, (Throwable)t)));
            } else {
                this.startRelayer(tmp, bridge_name).handleAsync((r, t) -> this.handleRelayerStarted(this.relayer, start, (Object)r, (Throwable)t));
            }
            this.notifySiteMasterListener(true);
        } else if (cease_site_master) {
            this.is_site_master = false;
            this.notifySiteMasterListener(false);
            this.log.trace(this.local_addr + ": ceased to be site master; closing bridges");
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
        this.suppress_log_no_route.removeExpired(this.suppress_time_no_route_errors);
        this.topo.put(this.site, view);
        if (!this.topo.globalViews()) {
            return;
        }
        if (this.is_site_master) {
            if (!become_site_master) {
                this.sendResponseTo(new SiteMaster(null), false);
            }
        } else if (old_view == null && !cease_site_master) {
            this.topo.refresh(this.site, true);
        }
    }

    protected <T> Object handleRelayerStarted(Relayer r, long start, T ignored, Throwable t) {
        if (t != null) {
            this.log.error(this.local_addr + ": failed starting relayer", t);
        } else {
            this.log.info("%s: relayer was started in %d ms: %s", this.local_addr, System.currentTimeMillis() - start, r);
            if (this.topo.globalViews()) {
                this.topo.refresh(null);
                this.sendResponseTo(new SiteMaster(null), true);
            }
        }
        return null;
    }

    @Override
    protected void handleRelayMessage(Message msg) {
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        if (hdr == null) {
            this.log.warn("%s: received a message without a relay header; discarding it", this.local_addr);
            return;
        }
        Message copy = this.copy(msg).dest(hdr.final_dest).src(hdr.original_sender).putHeader(this.id, hdr);
        this.process(true, copy);
    }

    protected boolean handleAdminMessage(RelayHeader hdr, Message msg) {
        switch (hdr.type) {
            case 4: 
            case 5: {
                HashSet<String> tmp_sites = new HashSet<String>();
                if (hdr.hasSites()) {
                    tmp_sites.addAll(hdr.getSites());
                }
                tmp_sites.remove(this.site);
                if (tmp_sites != null && !tmp_sites.isEmpty()) {
                    SiteStatus.Status status = hdr.type == 4 ? SiteStatus.Status.up : SiteStatus.Status.down;
                    Set<String> tmp = this.site_status.add(tmp_sites, status);
                    if (status == SiteStatus.Status.down) {
                        this.topo.removeAll(tmp_sites);
                    }
                    if (this.route_status_listener != null && !tmp.isEmpty()) {
                        String[] t = tmp.toArray(new String[0]);
                        if (hdr.type == 4) {
                            this.route_status_listener.sitesUp(t);
                        } else {
                            this.route_status_listener.sitesDown(t);
                        }
                    }
                }
                return true;
            }
            case 6: {
                this.sendResponseTo(msg.src(), hdr.returnEntireCache());
                return true;
            }
            case 7: {
                View v = (View)msg.getObject();
                String site_name = Objects.requireNonNull(hdr.getSite());
                if (v != null) {
                    this.topo.put(site_name, v);
                    if (!this.topo.globalViews()) {
                        return true;
                    }
                    Address dest = msg.getDest();
                    if (dest != null && ((SiteAddress)dest).type() == SiteAddress.Type.SM_ALL) {
                        Message local_mcast = new ObjectMessage(null, v).putHeader(this.id, hdr);
                        this.deliver(null, local_mcast, true, true);
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected Object routeThen(Message msg, List<String> sites, Supplier<Object> action) {
        if (!msg.isFlagSet(Message.Flag.NO_RELAY)) {
            this.route(msg, sites);
        }
        return action != null ? action.get() : null;
    }

    protected Object process(boolean down2, Message msg) {
        SiteAddress.Type type;
        SiteAddress.Type type2;
        Address dest = msg.dest();
        SiteAddress dst = null;
        if (dest == null) {
            type2 = SiteAddress.Type.ALL;
        } else {
            dst = (SiteAddress)dest;
            type2 = type = dst.type();
        }
        if (this.is_site_master) {
            switch (type) {
                case ALL: {
                    if (down2) {
                        return this.routeThen(msg, null, () -> this.deliver(null, msg, true));
                    }
                    return this.dontRoute(msg) ? this.passUp(msg) : this.routeThen(msg, null, () -> this.passUp(msg));
                }
                case SM_ALL: {
                    return this.routeThen(msg, null, () -> this.passUp(msg));
                }
                case SM: {
                    if (this.sameSite(dst)) {
                        return this.passUp(msg);
                    }
                    return this.route(msg, Arrays.asList(dst.getSite()));
                }
                case UNICAST: {
                    if (this.sameSite(dst)) {
                        if (down2) {
                            return this.deliver(dst, msg, false);
                        }
                        return this.passUp(msg);
                    }
                    return this.route(msg, Arrays.asList(dst.getSite()));
                }
            }
        } else {
            switch (type) {
                case ALL: {
                    if (down2) {
                        return this.deliver(null, msg, false);
                    }
                    return this.passUp(msg);
                }
                case SM_ALL: 
                case SM: {
                    if (down2) {
                        return this.sendToLocalSiteMaster(this.local_addr, msg);
                    }
                    throw new IllegalStateException(String.format("non site master received a msg with dst %s", dst));
                }
                case UNICAST: {
                    if (down2) {
                        if (this.sameSite(dst)) {
                            return this.deliver(dst, msg, false);
                        }
                        return this.sendToLocalSiteMaster(this.local_addr, msg);
                    }
                    return this.passUp(msg);
                }
            }
        }
        return null;
    }

    protected boolean dontRoute(Message msg) {
        if (msg.isFlagSet(Message.Flag.NO_RELAY)) {
            return true;
        }
        List sms = this.site_masters;
        if (sms == null || sms.size() < 2) {
            return false;
        }
        Address first_sm = (Address)sms.get(0);
        return this.local_addr.equals(first_sm);
    }

    protected Object route(Message msg, Collection<String> sites) {
        Relayer r = this.relayer;
        if (r == null) {
            this.log.warn("%s: not site master; dropping message", this.local_addr);
            return null;
        }
        if (sites == null) {
            sites = new ArrayList<String>(r.routes.keySet());
        }
        sites.remove(this.site);
        if (sites.isEmpty()) {
            return null;
        }
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        Address dest = msg.dest();
        Address sender = hdr != null && hdr.original_sender != null ? ((ExtendedUUID)hdr.getOriginalSender()).addContents((ExtendedUUID)this.local_addr) : this.local_addr;
        HashSet<String> visited_sites = null;
        if (dest == null || dest instanceof SiteMaster && ((SiteMaster)dest).getSite() == null) {
            visited_sites = new HashSet<String>(sites);
            visited_sites.add(this.site);
            if (hdr != null && hdr.hasVisitedSites()) {
                visited_sites.addAll(hdr.getVisitedSites());
                sites.removeAll(hdr.getVisitedSites());
            }
        }
        for (String s : sites) {
            Route route = r.getRoute(s, sender);
            if (route == null) {
                route = r.getForwardingRouteMatching(s, sender);
            }
            if (route == null) {
                this.suppress_log_no_route.log(SuppressLog.Level.error, s, this.suppress_time_no_route_errors, sender, s);
                this.sendSiteUnreachableTo(msg.getSrc(), s);
                continue;
            }
            route.send(dest, sender, msg, visited_sites);
        }
        return null;
    }

    protected Object deliver(Address next_dest, Message msg, boolean dont_relay) {
        return this.deliver(next_dest, msg, dont_relay, false);
    }

    protected Object deliver(Address next_dest, Message msg, boolean dont_relay, boolean dont_loopback) {
        RelayHeader tmp;
        this.checkLocalAddress(next_dest);
        Address final_dest = msg.dest();
        Address original_sender = msg.src();
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: forwarding message to final destination %s to %s", this.local_addr, final_dest, next_dest);
        }
        RelayHeader hdr = (tmp = (RelayHeader)msg.getHeader(this.id)) != null ? tmp.copy().setOriginalSender(original_sender).setFinalDestination(final_dest) : new RelayHeader(1, final_dest, original_sender);
        Message copy = this.copy(msg).setDest(next_dest).setSrc(null).putHeader(this.id, hdr);
        if (dont_relay) {
            copy.setFlag(Message.Flag.NO_RELAY);
        }
        if (dont_loopback) {
            copy.setFlag(Message.TransientFlag.DONT_LOOPBACK);
        }
        return this.down_prot.down(copy);
    }

    protected Object sendToLocalSiteMaster(Address sender, Message msg) {
        long start = this.stats ? System.nanoTime() : 0L;
        Address site_master = this.pickSiteMaster(sender);
        if (site_master == null) {
            throw new IllegalStateException("site master is null");
        }
        Object ret = this.deliver(site_master, msg, false);
        if (this.stats) {
            this.forward_sm_time.add(System.nanoTime() - start);
            this.forward_to_site_master.increment();
        }
        return ret;
    }

    protected Object passUp(Message msg) {
        RelayHeader hdr = (RelayHeader)msg.getHeader(this.id);
        Message copy = this.copy(msg);
        if (hdr != null) {
            copy.dest(hdr.final_dest).src(hdr.original_sender);
            if (this.handleAdminMessage(hdr, copy)) {
                return null;
            }
        }
        return this.up_prot.up(copy);
    }

    protected Address checkLocalAddress(Address dest) {
        if (dest == null) {
            return dest;
        }
        SiteAddress s = (SiteAddress)dest;
        String dest_site = s.getSite();
        if (dest_site != null && !this.site.equals(dest_site)) {
            throw new IllegalArgumentException(String.format("destination %s it not the same as the local site %s", dest_site, this.site));
        }
        return dest;
    }

    protected boolean sameSite(SiteAddress addr) {
        if (addr == null) {
            return true;
        }
        String dest_site = addr.getSite();
        return dest_site == null || this.site.equals(dest_site);
    }

    protected void sendSiteUnreachableTo(Address src, String target_site) {
        if (src == null || src.equals(this.local_addr)) {
            this.triggerSiteUnreachableEvent(new SiteMaster(target_site));
            return;
        }
        Message msg = new EmptyMessage(src).setFlag(Message.Flag.OOB).putHeader(this.id, new RelayHeader(2).addToSites(target_site));
        this.down(msg);
    }

    protected CompletableFuture<Relayer> startRelayer(Relayer3 rel, String bridge_name) {
        try {
            this.log.trace(this.local_addr + ": became site master; starting bridges");
            return rel.start(this.site_config, bridge_name, this.site);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }
}

