/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.ha;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;

public class ReplicationPrimaryPolicyConfiguration
implements HAPolicyConfiguration {
    private String groupName = null;
    private String clusterName = null;
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private Long retryReplicationWait = ActiveMQDefaultConfiguration.getDefaultRetryReplicationWait();
    private DistributedPrimitiveManagerConfiguration distributedManagerConfiguration = null;
    private String coordinationId = null;
    private int maxSavedReplicatedJournalsSize = ActiveMQDefaultConfiguration.getDefaultMaxSavedReplicatedJournalsSize();

    public static ReplicationPrimaryPolicyConfiguration withDefault() {
        return new ReplicationPrimaryPolicyConfiguration();
    }

    private ReplicationPrimaryPolicyConfiguration() {
    }

    @Override
    public HAPolicyConfiguration.TYPE getType() {
        return HAPolicyConfiguration.TYPE.PRIMARY;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ReplicationPrimaryPolicyConfiguration setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ReplicationPrimaryPolicyConfiguration setClusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public ReplicationPrimaryPolicyConfiguration setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        return this;
    }

    public void setRetryReplicationWait(Long retryReplicationWait) {
        this.retryReplicationWait = retryReplicationWait;
    }

    public Long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }

    public ReplicationPrimaryPolicyConfiguration setDistributedManagerConfiguration(DistributedPrimitiveManagerConfiguration configuration) {
        this.distributedManagerConfiguration = configuration;
        return this;
    }

    public DistributedPrimitiveManagerConfiguration getDistributedManagerConfiguration() {
        return this.distributedManagerConfiguration;
    }

    public String getCoordinationId() {
        return this.coordinationId;
    }

    public void setCoordinationId(String newCoordinationId) {
        if (newCoordinationId == null) {
            return;
        }
        int len = newCoordinationId.length();
        if (len >= 16) {
            this.coordinationId = newCoordinationId.substring(0, 16);
        } else if (len % 2 != 0) {
            this.coordinationId = newCoordinationId + "+";
        } else if (len > 0) {
            this.coordinationId = newCoordinationId;
        }
        if (this.coordinationId != null) {
            this.coordinationId = this.coordinationId.replace('-', '.');
        }
    }

    public int getMaxSavedReplicatedJournalsSize() {
        return this.maxSavedReplicatedJournalsSize;
    }

    public ReplicationPrimaryPolicyConfiguration setMaxSavedReplicatedJournalsSize(int maxSavedReplicatedJournalsSize) {
        this.maxSavedReplicatedJournalsSize = maxSavedReplicatedJournalsSize;
        return this;
    }
}

