/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServerEngine;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletHandler;
import org.apache.cxf.transport.http.netty.server.interceptor.ChannelInterceptor;
import org.apache.cxf.transport.http.netty.server.interceptor.HttpSessionInterceptor;
import org.apache.cxf.transport.http.netty.server.session.DefaultHttpSessionStore;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;
import org.apache.cxf.transport.https.SSLContextInitParameters;
import org.apache.cxf.transport.https.SSLUtils;

public class NettyHttpServletPipelineFactory
extends ChannelInitializer<Channel> {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServletPipelineFactory.class);
    private final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private final HttpSessionWatchdog watchdog;
    private final TLSServerParameters tlsServerParameters;
    private final boolean supportSession;
    private final Map<String, NettyHttpContextHandler> handlerMap;
    private final int maxChunkContentSize;
    private final EventExecutorGroup applicationExecutor;
    private final NettyHttpServerEngine nettyHttpServerEngine;
    private final boolean enableHttp2;

    @Deprecated
    public NettyHttpServletPipelineFactory(TLSServerParameters tlsServerParameters, boolean supportSession, int threadPoolSize, int maxChunkContentSize, Map<String, NettyHttpContextHandler> handlerMap, NettyHttpServerEngine engine) {
        this(tlsServerParameters, supportSession, maxChunkContentSize, handlerMap, engine, (EventExecutorGroup)new DefaultEventExecutorGroup(threadPoolSize));
    }

    public NettyHttpServletPipelineFactory(TLSServerParameters tlsServerParameters, boolean supportSession, int maxChunkContentSize, Map<String, NettyHttpContextHandler> handlerMap, NettyHttpServerEngine engine, EventExecutorGroup applicationExecutor) {
        this(tlsServerParameters, supportSession, maxChunkContentSize, handlerMap, engine, applicationExecutor, false);
    }

    public NettyHttpServletPipelineFactory(TLSServerParameters tlsServerParameters, boolean supportSession, int maxChunkContentSize, Map<String, NettyHttpContextHandler> handlerMap, NettyHttpServerEngine engine, EventExecutorGroup applicationExecutor, boolean enableHttp2) {
        this.supportSession = supportSession;
        this.watchdog = new HttpSessionWatchdog();
        this.handlerMap = handlerMap;
        this.tlsServerParameters = tlsServerParameters;
        this.maxChunkContentSize = maxChunkContentSize;
        this.nettyHttpServerEngine = engine;
        this.applicationExecutor = applicationExecutor;
        this.enableHttp2 = enableHttp2;
    }

    public Map<String, NettyHttpContextHandler> getHttpContextHandlerMap() {
        return this.handlerMap;
    }

    public ChannelGroup getAllChannels() {
        return this.allChannels;
    }

    public NettyHttpContextHandler getNettyHttpHandler(String url) {
        for (Map.Entry<String, NettyHttpContextHandler> entry : this.handlerMap.entrySet()) {
            if (!url.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public void start() {
        if (this.supportSession) {
            new Thread(this.watchdog).start();
        }
    }

    public void shutdown() {
        this.allChannels.close().awaitUninterruptibly();
        this.watchdog.stopWatching();
        this.applicationExecutor.shutdownGracefully();
    }

    protected HttpSessionStore getHttpSessionStore() {
        return new DefaultHttpSessionStore();
    }

    protected NettyHttpServletHandler getServletHandler() {
        NettyHttpServletHandler handler = new NettyHttpServletHandler(this);
        handler.addInterceptor(new ChannelInterceptor());
        if (this.supportSession) {
            handler.addInterceptor(new HttpSessionInterceptor(this.getHttpSessionStore()));
        }
        return handler;
    }

    protected ChannelPipeline getDefaultHttpChannelPipeline(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        SslHandler sslHandler = this.configureServerHttpSSLOnDemand();
        if (sslHandler != null) {
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        this.configureDefaultHttpPipeline(pipeline);
        return pipeline;
    }

    protected void configureDefaultHttp2Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{Http2FrameCodecBuilder.forServer().build()}).addLast(new ChannelHandler[]{new Http2MultiplexHandler(this.createHttp2ChannelInitializer())});
    }

    protected void configureDefaultHttpPipeline(ChannelPipeline pipeline) {
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxChunkContentSize));
        pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(this.nettyHttpServerEngine.getReadIdleTime(), this.nettyHttpServerEngine.getWriteIdleTime(), 0));
    }

    private SslHandler configureServerHttpSSLOnDemand() throws Exception {
        if (this.tlsServerParameters != null) {
            SSLEngine sslEngine = SSLUtils.createServerSSLEngine((TLSServerParameters)this.tlsServerParameters);
            return new SslHandler(sslEngine);
        }
        return null;
    }

    private SslContext configureServerHttp2SSLOnDemand() throws Exception {
        if (this.tlsServerParameters != null) {
            ClientAuthentication clientAuth;
            SSLContextInitParameters initParams = SSLUtils.getSSLContextInitParameters((TLSParameterBase)this.tlsServerParameters);
            SslProvider provider = SslProvider.JDK;
            KeyManager[] keyManagers = initParams.getKeyManagers();
            if (keyManagers == null || keyManagers.length == 0) {
                throw new IllegalStateException("No KeyManagers are configured, unable to create Netty's SslContext instance");
            }
            String[] cipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude((List)this.tlsServerParameters.getCipherSuites(), (FiltersType)this.tlsServerParameters.getCipherSuitesFilter(), (String[])SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites(), (String[])Http2SecurityUtil.CIPHERS.toArray(new String[0]), (Logger)LOG);
            SslContextBuilder builder = SslContextBuilder.forServer((KeyManager)keyManagers[0]).sslProvider(provider).ciphers(Arrays.asList(cipherSuites), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
            TrustManager[] trustManagers = initParams.getTrustManagers();
            if (trustManagers != null && trustManagers.length > 0) {
                builder.trustManager(trustManagers[0]);
            }
            if ((clientAuth = this.tlsServerParameters.getClientAuthentication()) != null) {
                if (clientAuth.isSetRequired() && clientAuth.isRequired().booleanValue()) {
                    builder.clientAuth(ClientAuth.REQUIRE);
                } else if (clientAuth.isSetWant() && clientAuth.isWant().booleanValue()) {
                    builder.clientAuth(ClientAuth.OPTIONAL);
                }
            }
            return builder.build();
        }
        return null;
    }

    protected void initChannel(Channel ch) throws Exception {
        if (!this.enableHttp2) {
            ChannelPipeline pipeline = this.getDefaultHttpChannelPipeline(ch);
            pipeline.addLast(this.applicationExecutor, "handler", (ChannelHandler)this.getServletHandler());
        } else {
            this.getDefaultHttp2ChannelPipeline(ch);
        }
    }

    protected ChannelPipeline getDefaultHttp2ChannelPipeline(Channel channel) throws Exception {
        ChannelPipeline pipeline = channel.pipeline();
        SslContext sslCtx = this.configureServerHttp2SSLOnDemand();
        if (sslCtx != null) {
            SslHandler sslHandler = sslCtx.newHandler(channel.alloc());
            LOG.log(Level.FINE, "Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", sslHandler);
            pipeline.addLast(new ChannelHandler[]{sslHandler, new Http2OrHttpHandler()});
            return pipeline;
        }
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

            public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
                if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                    return new Http2ServerUpgradeCodec(Http2FrameCodecBuilder.forServer().build(), new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)NettyHttpServletPipelineFactory.this.createHttp2ChannelInitializer())});
                }
                return null;
            }
        };
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory);
        CleartextHttp2ServerUpgradeHandler cleartextUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(sourceCodec, upgradeHandler, this.createHttp2ChannelInitializerPriorKnowledge());
        pipeline.addLast(new ChannelHandler[]{cleartextUpgradeHandler});
        pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<HttpMessage>(){

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                ChannelPipeline pipeline = ctx.pipeline();
                pipeline.addAfter(NettyHttpServletPipelineFactory.this.applicationExecutor, ctx.name(), "handler", (ChannelHandler)NettyHttpServletPipelineFactory.this.getServletHandler());
                pipeline.replace((ChannelHandler)this, "aggregator", (ChannelHandler)new HttpObjectAggregator(NettyHttpServletPipelineFactory.this.maxChunkContentSize));
                pipeline.addLast("deflater", (ChannelHandler)new HttpContentCompressor());
                pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(NettyHttpServletPipelineFactory.this.nettyHttpServerEngine.getReadIdleTime(), NettyHttpServletPipelineFactory.this.nettyHttpServerEngine.getWriteIdleTime(), 0));
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        }});
        return pipeline;
    }

    private ChannelInitializer<Channel> createHttp2ChannelInitializer() {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel childChannel) throws Exception {
                childChannel.pipeline().addLast(new ChannelHandler[]{new Http2StreamFrameToHttpObjectCodec(true)}).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(NettyHttpServletPipelineFactory.this.maxChunkContentSize)).addLast(NettyHttpServletPipelineFactory.this.applicationExecutor, new ChannelHandler[]{NettyHttpServletPipelineFactory.this.getServletHandler()});
            }
        };
    }

    private ChannelInitializer<Channel> createHttp2ChannelInitializerPriorKnowledge() {
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel childChannel) throws Exception {
                NettyHttpServletPipelineFactory.this.configureDefaultHttp2Pipeline(childChannel.pipeline());
            }
        };
    }

    private class Http2OrHttpHandler
    extends ApplicationProtocolNegotiationHandler {
        protected Http2OrHttpHandler() {
            super("http/1.1");
        }

        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
            if ("h2".equals(protocol)) {
                NettyHttpServletPipelineFactory.this.configureDefaultHttp2Pipeline(ctx.pipeline());
            } else if ("http/1.1".equals(protocol)) {
                NettyHttpServletPipelineFactory.this.configureDefaultHttpPipeline(ctx.pipeline());
                ctx.pipeline().addLast(NettyHttpServletPipelineFactory.this.applicationExecutor, "handler", (ChannelHandler)NettyHttpServletPipelineFactory.this.getServletHandler());
            } else {
                throw new IllegalStateException("Unknown application protocol: " + protocol);
            }
        }
    }

    private final class HttpSessionWatchdog
    implements Runnable {
        private boolean shouldStopWatching;

        private HttpSessionWatchdog() {
        }

        @Override
        public void run() {
            while (!this.shouldStopWatching) {
                try {
                    HttpSessionStore store = NettyHttpServletPipelineFactory.this.getHttpSessionStore();
                    if (store != null) {
                        store.destroyInactiveSessions();
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void stopWatching() {
            this.shouldStopWatching = true;
        }
    }
}

