/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.config.exclusion.FileProcessor;
import org.apache.rat.config.exclusion.fileProcessors.DescendingFileProcessor;
import org.apache.rat.document.DocumentName;
import org.apache.rat.utils.ExtendedIterator;

public class CVSFileProcessor
extends DescendingFileProcessor {
    public CVSFileProcessor() {
        super(".cvsignore", (String)null);
    }

    @Override
    protected List<String> process(DocumentName documentName) {
        File dir = new File(documentName.getName());
        ArrayList<String> result = new ArrayList<String>();
        ExtendedIterator<String> iter = ExclusionUtils.asIterator(dir, StringUtils::isNotBlank);
        while (iter.hasNext()) {
            String[] parts;
            String line = (String)iter.next();
            for (String part : parts = line.split("\\s+")) {
                if (part.isEmpty()) continue;
                result.add(FileProcessor.localizePattern(documentName, part).getName());
            }
        }
        return result;
    }
}

