/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.documentation.velocity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.Defaults;
import org.apache.rat.OptionCollection;
import org.apache.rat.api.EnvVar;
import org.apache.rat.commandline.StyleSheets;
import org.apache.rat.config.exclusion.StandardCollection;
import org.apache.rat.config.parameters.ComponentType;
import org.apache.rat.config.parameters.Description;
import org.apache.rat.config.parameters.DescriptionBuilder;
import org.apache.rat.configuration.MatcherBuilderTracker;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.documentation.options.AntOption;
import org.apache.rat.documentation.options.CLIOption;
import org.apache.rat.documentation.options.MavenOption;
import org.apache.rat.documentation.velocity.License;
import org.apache.rat.documentation.velocity.Matcher;
import org.apache.rat.help.AbstractHelp;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.velocity.tools.config.DefaultKey;
import org.apache.velocity.tools.config.ValidScope;

@DefaultKey(value="rat")
@ValidScope(value={"application"})
public class RatTool {
    private static final String[] MARKDOWN_CHARS = RatTool.charParser("\\`*_{}[]<>()#+-.!|");
    private static final String[] APT_CHARS = RatTool.charParser("\\~=-+*[]<>{}");
    private final LicenseSetFactory licenseSetFactory;

    private static String[] charParser(String charText) {
        char[] chars = charText.toCharArray();
        String[] result = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = String.valueOf(chars[i]);
        }
        return result;
    }

    public RatTool() {
        Defaults defaults = Defaults.builder().build();
        this.licenseSetFactory = defaults.getLicenseSetFactory();
    }

    public List<Option> options() {
        ArrayList<Option> lst = new ArrayList<Option>(OptionCollection.buildOptions().getOptions());
        lst.sort(Comparator.comparing(CLIOption::createName));
        return lst;
    }

    public Map<String, AntOption> antOptions() {
        TreeMap<String, AntOption> result = new TreeMap<String, AntOption>();
        for (AntOption antOption : AntOption.getAntOptions()) {
            result.put(CLIOption.createName(antOption.getOption()), antOption);
        }
        return result;
    }

    public Map<String, CLIOption> cliOptions() {
        TreeMap<String, CLIOption> result = new TreeMap<String, CLIOption>();
        for (Option option : OptionCollection.buildOptions().getOptions()) {
            CLIOption cliOption = new CLIOption(option);
            result.put(cliOption.getName(), cliOption);
        }
        return result;
    }

    public Map<String, MavenOption> mvnOptions() {
        TreeMap<String, MavenOption> result = new TreeMap<String, MavenOption>();
        for (MavenOption mavenOption : MavenOption.getMavenOptions()) {
            result.put(CLIOption.createName(mavenOption.getOption()), mavenOption);
        }
        return result;
    }

    private String escape(String text, String[] chars) {
        if (text == null) {
            return "";
        }
        String result = text;
        for (String c : chars) {
            result = result.replace(c, "\\" + c);
        }
        return result;
    }

    public String markdownEscape(String text) {
        return this.escape(text, MARKDOWN_CHARS);
    }

    public String aptEscape(String text) {
        return this.escape(text, APT_CHARS);
    }

    public List<OptionCollection.ArgumentType> argumentTypes() {
        return Arrays.stream(OptionCollection.ArgumentType.values()).filter(t -> t != OptionCollection.ArgumentType.NONE).sorted(Comparator.comparing(OptionCollection.ArgumentType::getDisplayName)).collect(Collectors.toList());
    }

    public List<EnvVar> environmentVariables() {
        return Arrays.stream(EnvVar.values()).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
    }

    public Set<Matcher> matchers() {
        MatcherBuilderTracker tracker = MatcherBuilderTracker.instance();
        TreeSet<Matcher> documentationSet = new TreeSet<Matcher>(Comparator.comparing(Matcher::getName));
        for (Class<? extends AbstractBuilder> clazz : tracker.getClasses()) {
            Description desc = DescriptionBuilder.buildMap(clazz);
            documentationSet.add(new Matcher(desc, null));
        }
        return documentationSet;
    }

    public List<StandardCollection> standardCollections() {
        return Arrays.stream(StandardCollection.values()).sorted(Comparator.comparing(Enum::name)).collect(Collectors.toList());
    }

    public List<StyleSheets> styleSheets() {
        return Arrays.stream(StyleSheets.values()).sorted(Comparator.comparing(StyleSheets::arg)).collect(Collectors.toList());
    }

    public StringUtils stringUtils() {
        return new StringUtils();
    }

    public String tab() {
        return "\t";
    }

    public String doubleLine() {
        return "\n\n";
    }

    public List<Description> licenseProperties() {
        SortedSet<ILicense> licenses = this.licenseSetFactory.getLicenses(LicenseSetFactory.LicenseFilter.ALL);
        Description licenseDescription = DescriptionBuilder.build(licenses.first());
        ArrayList<Description> descriptions = new ArrayList<Description>(licenseDescription.filterChildren(d -> d.getType() == ComponentType.PARAMETER));
        descriptions.sort(Comparator.comparing(Description::getCommonName));
        return descriptions;
    }

    public List<License> licenses() {
        SortedSet<ILicense> licenses = this.licenseSetFactory.getLicenses(LicenseSetFactory.LicenseFilter.ALL);
        return licenses.stream().map(License::new).collect(Collectors.toList());
    }

    public String pad(int length) {
        return AbstractHelp.createPadding(length);
    }
}

