/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.operations;

import java.io.File;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.operations.FileOperation;
import org.apache.commons.vfs2.operations.FileOperationProvider;
import org.apache.commons.vfs2.operations.FileOperations;
import org.apache.commons.vfs2.operations.vcs.VcsLog;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BasicOperationsTest {
    private DefaultFileSystemManager manager;

    @BeforeEach
    public void setUp() throws FileSystemException {
        this.manager = new DefaultFileSystemManager();
        DefaultLocalFileProvider fp = new DefaultLocalFileProvider();
        this.manager.addProvider("file", (FileProvider)fp);
        this.manager.init();
    }

    @AfterEach
    public void tearDown() {
        if (this.manager != null) {
            this.manager.close();
            this.manager = null;
        }
    }

    @Test
    public void testLifecycleComp() throws FileSystemException {
        try (MyFileOperationProviderComp myop = new MyFileOperationProviderComp();){
            Assertions.assertEquals((int)0, (int)myop.ops);
            this.manager.addOperationProvider("file", (FileOperationProvider)myop);
            Assertions.assertEquals((int)7, (int)myop.ops);
            this.manager.close();
            Assertions.assertEquals((int)15, (int)myop.ops, (String)"close() not called");
        }
    }

    @Test
    public void testLifecycleNoncomp() throws FileSystemException {
        MyFileOperationProviderNoncomp myop = new MyFileOperationProviderNoncomp();
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        FileOperationProvider[] ops = this.manager.getOperationProviders("file");
        Assertions.assertSame((Object)1, (Object)ops.length, (String)"exactly one provider registered");
        Assertions.assertSame((Object)myop, (Object)ops[0]);
        Assertions.assertEquals((int)0, (int)myop.ops);
    }

    @Test
    public void testNotFoundAny() throws FileSystemException {
        MyFileOperationProviderNoncomp myop = new MyFileOperationProviderNoncomp();
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        try (FileObject fo = this.manager.toFileObject(new File("."));){
            FileOperations ops = fo.getFileOperations();
            Assertions.assertNotNull((Object)ops);
            Class[] oparray = ops.getOperations();
            Assertions.assertSame((Object)0, (Object)oparray.length, (String)"no ops should be found");
            Assertions.assertSame((Object)16, (Object)myop.ops);
        }
    }

    @Test
    public void testNotFoundOperation() throws FileSystemException {
        MyFileOperationProviderNoncomp myop = new MyFileOperationProviderNoncomp();
        this.manager.addOperationProvider("file", (FileOperationProvider)myop);
        try (FileObject fo = this.manager.toFileObject(new File("."));){
            FileOperations ops = fo.getFileOperations();
            Assertions.assertNotNull((Object)ops);
            FileSystemException thrown = (FileSystemException)Assertions.assertThrows(FileSystemException.class, () -> ops.getOperation(VcsLog.class));
            Assertions.assertEquals((Object)"vfs.operation/operation-not-supported.error", (Object)thrown.getCode());
            Assertions.assertSame((Object)32, (Object)myop.ops);
        }
    }

    static class MyFileOperationProviderComp
    extends MyFileOperationProviderBase
    implements VfsComponent {
        MyFileOperationProviderComp() {
        }

        public void close() {
            this.ops |= 8;
        }

        public void init() throws FileSystemException {
            this.ops |= 4;
        }

        public void setContext(VfsComponentContext context) {
            Assertions.assertNotNull((Object)context, (String)"setContext");
            this.ops |= 2;
        }

        public void setLogger(Log logger) {
            Assertions.assertNotNull((Object)logger, (String)"setLogger");
            this.ops |= 1;
        }
    }

    static class MyFileOperationProviderNoncomp
    extends MyFileOperationProviderBase {
        MyFileOperationProviderNoncomp() {
        }
    }

    static class MyFileOperationProviderBase
    implements FileOperationProvider {
        int ops;

        MyFileOperationProviderBase() {
        }

        public void collectOperations(Collection<Class<? extends FileOperation>> operationsList, FileObject file) throws FileSystemException {
            Assertions.assertNotNull(operationsList, (String)"collect operationsList");
            Assertions.assertNotNull((Object)file, (String)"collect file");
            this.ops |= 0x10;
        }

        public FileOperation getOperation(FileObject file, Class<? extends FileOperation> operationClass) throws FileSystemException {
            Assertions.assertNotNull((Object)file, (String)"file object");
            Assertions.assertNotNull(operationClass, (String)"operationClass");
            this.ops |= 0x20;
            return null;
        }
    }
}

