/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FileTypeSelectorTest {
    private static FileObject baseFolder;

    @BeforeAll
    public static void setUpClass() throws Exception {
        baseFolder = VFS.getManager().resolveFile("ram://" + FileTypeSelectorTest.class.getName());
        baseFolder.resolveFile("root1.html").createFile();
        baseFolder.resolveFile("root2.html").createFile();
        baseFolder.resolveFile("f1/a.html").createFile();
        baseFolder.resolveFile("f2/b.html").createFile();
        baseFolder.resolveFile("f3/c.html").createFile();
        baseFolder.resolveFile("f4/").createFolder();
        baseFolder.resolveFile("f5/").createFolder();
        baseFolder.resolveFile("f6/f7").createFolder();
    }

    @AfterAll
    public static void tearDownClass() throws Exception {
        if (baseFolder != null) {
            baseFolder.deleteAll();
        }
    }

    @Test
    public void testFileOrFolders() throws Exception {
        FileTypeSelector selector = new FileTypeSelector(FileType.FILE_OR_FOLDER);
        FileObject[] foList = baseFolder.findFiles((FileSelector)selector);
        Assertions.assertEquals((int)0, (int)foList.length);
    }

    @Test
    public void testFiles() throws Exception {
        FileTypeSelector selector = new FileTypeSelector(FileType.FILE);
        FileObject[] foList = baseFolder.findFiles((FileSelector)selector);
        Assertions.assertEquals((int)5, (int)foList.length);
    }

    @Test
    public void testFolders() throws Exception {
        FileTypeSelector selector = new FileTypeSelector(FileType.FOLDER);
        FileObject[] foList = baseFolder.findFiles((FileSelector)selector);
        Assertions.assertEquals((int)8, (int)foList.length);
    }
}

