/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import junit.framework.Test;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.IPv6LocalConnectionTests;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpProviderTestCase;
import org.mockito.Mockito;

public class FtpProviderIPv6TestCase
extends FtpProviderTestCase {
    public static Test suite() throws Exception {
        return FtpProviderIPv6TestCase.getSystemTestUriOverride() == null ? FtpProviderIPv6TestCase.suite(new FtpProviderIPv6TestCase(), FtpProviderIPv6TestCase.class, IPv6LocalConnectionTests.class) : FtpProviderIPv6TestCase.suite(new FtpProviderIPv6TestCase(), FtpProviderIPv6TestCase.class);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("ftp", (FileProvider)new MockedClientFtpFileProvider());
    }

    @org.junit.Test
    public void testResolveIPv6Url() throws Exception {
        String ipv6Url = "ftp://[fe80::1c42:dae:8370:aea6%en1]/file.txt";
        FtpFileObject fileObject = (FtpFileObject)this.getManager().resolveFile("ftp://[fe80::1c42:dae:8370:aea6%en1]/file.txt", new FileSystemOptions());
        FtpProviderIPv6TestCase.assertEquals((String)"ftp://[fe80::1c42:dae:8370:aea6%en1]/", (String)fileObject.getFileSystem().getRootURI());
        FtpProviderIPv6TestCase.assertEquals((String)"file.txt", (String)fileObject.getRelPath());
    }

    private static class MockedClientFtpFileProvider
    extends FtpFileProvider {
        private MockedClientFtpFileProvider() {
        }

        protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) {
            GenericFileName rootName = (GenericFileName)name;
            return new FtpFileSystem(rootName, (FtpClient)Mockito.mock(FtpClient.class), fileSystemOptions);
        }
    }
}

