/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav;

import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystem;

public final class WebdavFileSystemConfigBuilder
extends HttpFileSystemConfigBuilder {
    private static final WebdavFileSystemConfigBuilder BUILDER = new WebdavFileSystemConfigBuilder();
    private static final boolean DEFAULT_FOLLOW_REDIRECT = false;

    public static HttpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private WebdavFileSystemConfigBuilder() {
        super("webdav.");
    }

    protected Class<? extends FileSystem> getConfigClass() {
        return WebdavFileSystem.class;
    }

    public String getCreatorName(FileSystemOptions opts) {
        return this.getString(opts, "creatorName");
    }

    public boolean getFollowRedirect(FileSystemOptions opts) {
        return this.getBoolean(opts, "followRedirect", false);
    }

    public boolean isVersioning(FileSystemOptions opts) {
        return this.getBoolean(opts, "versioning", false);
    }

    public void setCreatorName(FileSystemOptions opts, String creatorName) {
        this.setParam(opts, "creatorName", creatorName);
    }

    public void setVersioning(FileSystemOptions opts, boolean versioning) {
        this.setParam(opts, "versioning", versioning);
    }
}

