/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.combinatorics;

import org.apache.commons.numbers.combinatorics.BinomialCoefficient;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import org.apache.commons.numbers.gamma.LogBeta;

public final class LogBinomialCoefficient {
    private static final int LIMIT_N_LONG = 66;
    private static final int LIMIT_N_DOUBLE = 1029;
    private static final int LIMIT_M_DOUBLE = 37;

    private LogBinomialCoefficient() {
    }

    public static double value(int n, int k) {
        int m = BinomialCoefficient.checkBinomial(n, k);
        if (m == 0) {
            return 0.0;
        }
        if (m == 1) {
            return Math.log(n);
        }
        if (n <= 66) {
            return Math.log(BinomialCoefficient.value(n, k));
        }
        if (n <= 1029 || m <= 37) {
            return Math.log(BinomialCoefficientDouble.value(n, k));
        }
        return -Math.log(m) - LogBeta.value((double)m, (double)(n - m + 1));
    }
}

