/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import java.util.ArrayList;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math3.stat.regression.SimpleRegression;

@Deprecated
class StraightLineProblem
implements MultivariateDifferentiableVectorFunction {
    private final ArrayList<double[]> points = new ArrayList();
    private final double sigma;

    public StraightLineProblem(double error) {
        this.sigma = error;
    }

    public void addPoint(double px, double py) {
        this.points.add(new double[]{px, py});
    }

    public double[] x() {
        double[] v = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            v[i] = p[0];
        }
        return v;
    }

    public double[] y() {
        double[] v = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            v[i] = p[1];
        }
        return v;
    }

    public double[] target() {
        return this.y();
    }

    public double[] weight() {
        double weight = 1.0 / (this.sigma * this.sigma);
        double[] w = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            w[i] = weight;
        }
        return w;
    }

    public double[] value(double[] params) {
        Model line = new Model(new DerivativeStructure(0, 0, params[0]), new DerivativeStructure(0, 0, params[1]));
        double[] model = new double[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            double[] p = this.points.get(i);
            model[i] = line.value(p[0]);
        }
        return model;
    }

    public DerivativeStructure[] value(DerivativeStructure[] params) {
        Model line = new Model(params[0], params[1]);
        DerivativeStructure[] model = new DerivativeStructure[this.points.size()];
        for (int i = 0; i < this.points.size(); ++i) {
            DerivativeStructure p0 = ((DerivativeStructure)params[0].getField().getZero()).add(this.points.get(i)[0]);
            model[i] = line.value(p0);
        }
        return model;
    }

    public double[] solve() {
        SimpleRegression regress = new SimpleRegression(true);
        for (double[] d : this.points) {
            regress.addData(d[0], d[1]);
        }
        double[] result = new double[]{regress.getSlope(), regress.getIntercept()};
        return result;
    }

    public static class Model
    implements UnivariateDifferentiableFunction {
        final DerivativeStructure a;
        final DerivativeStructure b;

        public Model(DerivativeStructure a, DerivativeStructure b) {
            this.a = a;
            this.b = b;
        }

        public double value(double x) {
            return this.a.getValue() * x + this.b.getValue();
        }

        public DerivativeStructure value(DerivativeStructure x) {
            return x.multiply(this.a).add(this.b);
        }
    }
}

