/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.special;

import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.special.BesselJ;
import org.junit.Assert;
import org.junit.Test;

public class BesselJTest {
    private static final double[][] BESSEL_J_REF = new double[][]{{0.0, 1.0E-8, 1.0}, {0.0, 3.16227766016838E-8, 0.9999999999999998}, {0.0, 1.0E-7, 0.9999999999999974}, {0.0, 3.16227766016838E-7, 0.999999999999975}, {0.0, 1.0E-6, 0.99999999999975}, {0.0, 3.16227766016838E-6, 0.9999999999975}, {0.0, 1.0E-5, 0.999999999975}, {0.0, 3.16227766016838E-5, 0.99999999975}, {0.0, 1.0E-4, 0.9999999975}, {0.0, 3.16227766016838E-4, 0.9999999750000002}, {0.0, 0.001, 0.9999997500000156}, {0.0, 0.00316227766016838, 0.9999975000015625}, {0.0, 0.01, 0.9999750001562495}, {0.0, 0.0316227766016838, 0.999750015624566}, {0.0, 0.1, 0.99750156206604}, {0.0, 0.316227766016838, 0.975155816649713}, {0.0, 1.0, 0.7651976865579665}, {0.0, 2.0, 0.22389077914123567}, {0.0, 3.0, -0.26005195490193345}, {0.0, 4.0, -0.39714980986384735}, {0.0, 5.0, -0.1775967713143383}, {0.0, 6.0, 0.15064525725099692}, {0.0, 7.0, 0.30007927051955563}, {0.0, 7.5, 0.2663396578803784}, {0.0, 7.6, 0.25160183384997636}, {0.0, 7.7, 0.23455913958646438}, {0.0, 7.8, 0.21540780774626292}, {0.0, 7.9, 0.19436184484127825}, {0.0, 8.0, 0.1716508071375539}, {0.0, 8.1, 0.14751745404437766}, {0.0, 8.2, 0.12221530178413774}, {0.0, 8.3, 0.09600610089501023}, {0.0, 8.4, 0.06915726165698519}, {0.0, 8.5, 0.041939251842934504}, {0.0, 9.0, -0.09033361118287614}, {0.0, 10.0, -0.24593576445134832}, {0.0, 11.0, -0.1711903004071961}, {0.0, 12.0, 0.047689310796833535}, {0.0, 13.0, 0.20692610237706782}, {0.0, 14.0, 0.17107347611045864}, {0.0, 15.0, -0.014224472826780772}, {0.0, 16.0, -0.1748990739836292}, {0.0, 17.0, -0.16985425215118355}, {0.0, 18.0, -0.013355805721984111}, {0.0, 19.0, 0.1466294396596512}, {0.0, 20.0, 0.16702466434058313}, {0.0, 30.0, -0.08636798358104024}, {0.0, 100.0, 0.01998585030422312}, {0.0, 300.0, -0.03329855487630566}, {0.0, 1000.0, 0.024786686152420176}, {1.0, 1.0E-8, 5.0E-9}, {1.0, 3.16227766016838E-8, 1.5811388300841893E-8}, {1.0, 1.0E-7, 4.999999999999994E-8}, {1.0, 3.16227766016838E-7, 1.5811388300841697E-7}, {1.0, 1.0E-6, 4.999999999999375E-7}, {1.0, 3.16227766016838E-6, 1.5811388300822133E-6}, {1.0, 1.0E-5, 4.9999999999375E-6}, {1.0, 3.16227766016838E-5, 1.5811388298865475E-5}, {1.0, 1.0E-4, 4.99999999375E-5}, {1.0, 3.16227766016838E-4, 1.5811388103199544E-4}, {1.0, 0.001, 4.999999375000025E-4}, {1.0, 0.00316227766016838, 0.0015811368536614756}, {1.0, 0.01, 0.004999937500260416}, {1.0, 0.0316227766016838, 0.015809411959653557}, {1.0, 0.1, 0.049937526036242}, {1.0, 0.316227766016838, 0.15614567743386049}, {1.0, 1.0, 0.44005058574493355}, {1.0, 2.0, 0.5767248077568734}, {1.0, 3.0, 0.3390589585259364}, {1.0, 4.0, -0.06604332802354913}, {1.0, 5.0, -0.32757913759146523}, {1.0, 6.0, -0.27668385812756563}, {1.0, 7.0, -0.004682823482345833}, {1.0, 7.5, 0.1352484275797055}, {1.0, 7.6, 0.15921376839635668}, {1.0, 7.7, 0.181312715324588}, {1.0, 7.8, 0.20135687275589612}, {1.0, 7.9, 0.21917939992175123}, {1.0, 8.0, 0.23463634685391463}, {1.0, 8.1, 0.24760776698159284}, {1.0, 8.2, 0.2579985976486808}, {1.0, 8.3, 0.2657393020418643}, {1.0, 8.4, 0.2707862682768354}, {1.0, 8.5, 0.2731219636740537}, {1.0, 9.0, 0.24531178657332528}, {1.0, 10.0, 0.04347274616886144}, {1.0, 11.0, -0.17678529895672151}, {1.0, 12.0, -0.2234471044906276}, {1.0, 13.0, -0.07031805212177837}, {1.0, 14.0, 0.13337515469879324}, {1.0, 15.0, 0.20510403861352278}, {1.0, 16.0, 0.09039717566130419}, {1.0, 17.0, -0.09766849275778064}, {1.0, 18.0, -0.18799488548806959}, {1.0, 19.0, -0.10570143114240928}, {1.0, 20.0, 0.06683312417585004}, {1.0, 30.0, -0.11875106261662295}, {1.0, 100.0, -0.07714535201411216}, {1.0, 300.0, -0.031887431377499956}, {1.0, 1000.0, 0.004728311907089525}, {2.0, 1.0E-8, 1.25E-17}, {2.0, 3.16227766016838E-8, 1.2499999999999999E-16}, {2.0, 1.0E-7, 1.2499999999999988E-15}, {2.0, 3.16227766016838E-7, 1.2499999999999895E-14}, {2.0, 1.0E-6, 1.2499999999998957E-13}, {2.0, 3.16227766016838E-6, 1.2499999999989583E-12}, {2.0, 1.0E-5, 1.2499999999895835E-11}, {2.0, 3.16227766016838E-5, 1.2499999998958335E-10}, {2.0, 1.0E-4, 1.2499999989583335E-9}, {2.0, 3.16227766016838E-4, 1.2499999895833333E-8}, {2.0, 0.001, 1.2499998958333368E-7}, {2.0, 0.00316227766016838, 1.249998958333659E-6}, {2.0, 0.01, 1.2499895833658854E-5}, {2.0, 0.0316227766016838, 1.2498958365884873E-4}, {2.0, 0.1, 0.001248958658799919}, {2.0, 0.316227766016838, 0.01239615831219668}, {2.0, 1.0, 0.11490348493190047}, {2.0, 2.0, 0.35283402861563773}, {2.0, 3.0, 0.4860912605858911}, {2.0, 4.0, 0.3641281458520728}, {2.0, 5.0, 0.046565116277752214}, {2.0, 6.0, -0.24287320996018547}, {2.0, 7.0, -0.30141722008594013}, {2.0, 7.5, -0.23027341052579026}, {2.0, 7.6, -0.20970347374567197}, {2.0, 7.7, -0.1874649278138441}, {2.0, 7.8, -0.16377784037295623}, {2.0, 7.9, -0.13887338916488554}, {2.0, 8.0, -0.11299172042407524}, {2.0, 8.1, -0.08637973380200906}, {2.0, 8.2, -0.05928881455275216}, {2.0, 8.3, -0.03197253413793451}, {2.0, 8.4, -0.004684340638691052}, {2.0, 8.5, 0.022324739609784025}, {2.0, 9.0, 0.14484734153250398}, {2.0, 10.0, 0.2546303136851206}, {2.0, 11.0, 0.13904751877870125}, {2.0, 12.0, -0.08493049487860481}, {2.0, 13.0, -0.21774426424195678}, {2.0, 14.0, -0.15201988258205965}, {2.0, 15.0, 0.04157167797525047}, {2.0, 16.0, 0.18619872094129222}, {2.0, 17.0, 0.15836384123850347}, {2.0, 18.0, -0.0075325148878014}, {2.0, 19.0, -0.1577559060956943}, {2.0, 20.0, -0.16034135192299814}, {2.0, 30.0, 0.07845124607326538}, {2.0, 100.0, -0.02152875734450536}, {2.0, 300.0, 0.03308597200045566}, {2.0, 1000.0, -0.024777229528605997}, {3.0, 1.0E-8, 2.0833333333333335E-26}, {3.0, 3.16227766016838E-8, 6.588078458684122E-25}, {3.0, 1.0E-7, 2.0833333333333318E-23}, {3.0, 3.16227766016838E-7, 6.588078458684082E-22}, {3.0, 1.0E-6, 2.0833333333332028E-20}, {3.0, 3.16227766016838E-6, 6.588078458680005E-19}, {3.0, 1.0E-5, 2.083333333320313E-17}, {3.0, 3.16227766016838E-5, 6.58807845827237E-16}, {3.0, 1.0E-4, 2.0833333320312503E-14}, {3.0, 3.16227766016838E-4, 6.588078417508634E-13}, {3.0, 0.001, 2.0833332031250032E-11}, {3.0, 0.00316227766016838, 6.588074341136116E-10}, {3.0, 0.01, 2.083320312532552E-8}, {3.0, 0.0316227766016838, 6.587666714074185E-7}, {3.0, 0.1, 2.0820315754756265E-5}, {3.0, 0.316227766016838, 6.547005764200386E-4}, {3.0, 1.0, 0.019563353982668404}, {3.0, 2.0, 0.12894324947440206}, {3.0, 3.0, 0.30906272225525167}, {3.0, 4.0, 0.43017147387562193}, {3.0, 5.0, 0.36483123061366696}, {3.0, 6.0, 0.1147683848207753}, {3.0, 7.0, -0.16755558799533424}, {3.0, 7.5, -0.2580609131934603}, {3.0, 7.6, -0.269584017736184}, {3.0, 7.7, -0.27869709340970183}, {3.0, 7.8, -0.2853455088445916}, {3.0, 7.9, -0.2894950400052375}, {3.0, 8.0, -0.2911322070659522}, {3.0, 8.1, -0.29026442564925165}, {3.0, 8.2, -0.2869199706012429}, {3.0, 8.3, -0.2811477522288207}, {3.0, 8.4, -0.27301690667621203}, {3.0, 8.5, -0.2626162038576848}, {3.0, 9.0, -0.18093519033665686}, {3.0, 10.0, 0.058379379305186815}, {3.0, 11.0, 0.22734803305806742}, {3.0, 12.0, 0.19513693953109268}, {3.0, 13.0, 0.0033198169704070513}, {3.0, 14.0, -0.176809406865096}, {3.0, 15.0, -0.19401825782012264}, {3.0, 16.0, -0.04384749542598114}, {3.0, 17.0, 0.13493057304919323}, {3.0, 18.0, 0.1863209932907804}, {3.0, 19.0, 0.07248966143805258}, {3.0, 20.0, -0.09890139456044968}, {3.0, 30.0, 0.12921122875972502}, {3.0, 100.0, 0.07628420172033194}, {3.0, 300.0, 0.03232857767083937}, {3.0, 1000.0, -0.004827420825203948}, {4.0, 1.0E-8, 2.6041666666666666E-35}, {4.0, 3.16227766016838E-8, 2.604166666666666E-33}, {4.0, 1.0E-7, 2.604166666666665E-31}, {4.0, 3.16227766016838E-7, 2.604166666666653E-29}, {4.0, 1.0E-6, 2.604166666666536E-27}, {4.0, 3.16227766016838E-6, 2.604166666665364E-25}, {4.0, 1.0E-5, 2.6041666666536466E-23}, {4.0, 3.16227766016838E-5, 2.604166666536459E-21}, {4.0, 1.0E-4, 2.604166665364584E-19}, {4.0, 3.16227766016838E-4, 2.604166653645834E-17}, {4.0, 0.001, 2.604166536458337E-15}, {4.0, 0.00316227766016838, 2.604165364583605E-13}, {4.0, 0.01, 2.6041536458604605E-11}, {4.0, 0.0316227766016838, 2.6040364610459736E-9}, {4.0, 0.1, 2.602864854568404E-7}, {4.0, 0.316227766016838, 2.591172927800927E-5}, {4.0, 1.0, 0.0024766389641099553}, {4.0, 2.0, 0.03399571980756843}, {4.0, 3.0, 0.13203418392461222}, {4.0, 4.0, 0.2811290649613601}, {4.0, 5.0, 0.3912323604586482}, {4.0, 6.0, 0.3576415947809608}, {4.0, 7.0, 0.15779814466136793}, {4.0, 7.5, 0.02382467997102201}, {4.0, 7.6, -0.003126013940789121}, {4.0, 7.7, -0.029701638479430047}, {4.0, 7.8, -0.05571870489211423}, {4.0, 7.9, -0.08099626147200373}, {4.0, 8.0, -0.10535743487538893}, {4.0, 8.1, -0.1286309518641033}, {4.0, 8.2, -0.1506526273505963}, {4.0, 8.3, -0.17126680482265874}, {4.0, 8.4, -0.19032773555860327}, {4.0, 8.5, -0.20770088350932622}, {4.0, 9.0, -0.2654708017569419}, {4.0, 10.0, -0.21960268610200856}, {4.0, 11.0, -0.015039500747028133}, {4.0, 12.0, 0.18249896464415113}, {4.0, 13.0, 0.21927648745906775}, {4.0, 14.0, 0.07624442249701847}, {4.0, 15.0, -0.11917898110329952}, {4.0, 16.0, -0.20264153172603513}, {4.0, 17.0, -0.11074128604467057}, {4.0, 18.0, 0.06963951265139487}, {4.0, 19.0, 0.18064737812876355}, {4.0, 20.0, 0.13067093355486323}, {4.0, 30.0, -0.052609000321320376}, {4.0, 100.0, 0.026105809447725278}, {4.0, 300.0, -0.03243940044703887}, {4.0, 1000.0, 0.024748265003654773}, {5.0, 1.0E-8, 2.6041666666666667E-44}, {5.0, 3.16227766016838E-8, 8.235098073355152E-42}, {5.0, 1.0E-7, 2.604166666666665E-39}, {5.0, 3.16227766016838E-7, 8.235098073355119E-37}, {5.0, 1.0E-6, 2.6041666666665577E-34}, {5.0, 3.16227766016838E-6, 8.235098073351722E-32}, {5.0, 1.0E-5, 2.604166666655817E-29}, {5.0, 3.16227766016838E-5, 8.235098073012028E-27}, {5.0, 1.0E-4, 2.604166665581598E-24}, {5.0, 3.16227766016838E-4, 8.2350980390422475E-22}, {5.0, 0.001, 2.6041665581597246E-19}, {5.0, 0.00316227766016838, 8.235094642064904E-17}, {5.0, 0.01, 2.6041558159915982E-14}, {5.0, 0.0316227766016838, 8.234754950396005E-12}, {5.0, 0.1, 2.603081790964442E-9}, {5.0, 0.316227766016838, 8.200846373985524E-7}, {5.0, 1.0, 2.497577302112344E-4}, {5.0, 2.0, 0.007039629755871685}, {5.0, 3.0, 0.043028434877047585}, {5.0, 4.0, 0.13208665604709827}, {5.0, 5.0, 0.26114054612017007}, {5.0, 6.0, 0.3620870748871724}, {5.0, 7.0, 0.3478963247511833}, {5.0, 7.5, 0.28347390516255044}, {5.0, 7.6, 0.2662934767458797}, {5.0, 7.7, 0.24783824823626804}, {5.0, 7.8, 0.22819811921165392}, {5.0, 7.9, 0.20747350940067683}, {5.0, 8.0, 0.18577477219056332}, {5.0, 8.1, 0.16322151022791506}, {5.0, 8.2, 0.13994179757627084}, {5.0, 8.3, 0.11607131384553517}, {5.0, 8.4, 0.09175239662039944}, {5.0, 8.5, 0.06713301937831892}, {5.0, 9.0, -0.055038855669513706}, {5.0, 10.0, -0.23406152818679363}, {5.0, 11.0, -0.2382858517831788}, {5.0, 12.0, -0.07347096310165858}, {5.0, 13.0, 0.1316195599274808}, {5.0, 14.0, 0.22037764829196368}, {5.0, 15.0, 0.13045613456502955}, {5.0, 16.0, -0.057473270437036435}, {5.0, 17.0, -0.18704411942315585}, {5.0, 18.0, -0.15537009877904934}, {5.0, 19.0, 0.0035723925109004857}, {5.0, 20.0, 0.15116976798239498}, {5.0, 30.0, -0.14324029551207712}, {5.0, 100.0, -0.07419573696451393}, {5.0, 300.0, -0.03319362834942707}, {5.0, 1000.0, 0.0050254069452331865}, {6.0, 1.0E-8, 2.170138888888889E-53}, {6.0, 3.16227766016838E-8, 2.170138888888888E-50}, {6.0, 1.0E-7, 2.1701388888888875E-47}, {6.0, 3.16227766016838E-7, 2.1701388888888806E-44}, {6.0, 1.0E-6, 2.1701388888888107E-41}, {6.0, 3.16227766016838E-6, 2.1701388888881134E-38}, {6.0, 1.0E-5, 2.1701388888811394E-35}, {6.0, 3.16227766016838E-5, 2.1701388888113848E-32}, {6.0, 1.0E-4, 2.1701388881138396E-29}, {6.0, 3.16227766016838E-4, 2.1701388811383932E-26}, {6.0, 0.001, 2.1701388113839302E-23}, {6.0, 0.00316227766016838, 2.170138113839407E-20}, {6.0, 0.01, 2.1701311384049674E-17}, {6.0, 0.0316227766016838, 2.170061385139574E-14}, {6.0, 0.1, 2.1693639603760032E-11}, {6.0, 0.316227766016838, 2.162400491801096E-8}, {6.0, 1.0, 2.0938338002389273E-5}, {6.0, 2.0, 0.0012024289717899933}, {6.0, 3.0, 0.01139393233221307}, {6.0, 4.0, 0.04908757515638558}, {6.0, 5.0, 0.13104873178169202}, {6.0, 6.0, 0.24583686336432653}, {6.0, 7.0, 0.33919660498317966}, {6.0, 7.5, 0.35414052691237863}, {6.0, 7.6, 0.3535121675537887}, {6.0, 7.7, 0.3515694933317262}, {6.0, 7.8, 0.3482803961891064}, {6.0, 7.9, 0.34362095691589845}, {6.0, 8.0, 0.3375759001135931}, {6.0, 8.1, 0.330138989182517}, {6.0, 8.2, 0.3213133561021461}, {6.0, 8.3, 0.31111176126306256}, {6.0, 8.4, 0.2995567791543169}, {6.0, 8.5, 0.28668090630734855}, {6.0, 9.0, 0.2043165176797044}, {6.0, 10.0, -0.014458842084785107}, {6.0, 11.0, -0.2015840008740435}, {6.0, 12.0, -0.24372476722886663}, {6.0, 13.0, -0.11803067213023637}, {6.0, 14.0, 0.08116818342581274}, {6.0, 15.0, 0.2061497374799859}, {6.0, 16.0, 0.16672073770288737}, {6.0, 17.0, 7.153334428141831E-4}, {6.0, 18.0, -0.15595623419531116}, {6.0, 19.0, -0.17876717154407903}, {6.0, 20.0, -0.055086049563665765}, {6.0, 30.0, 0.004862235150628003}, {6.0, 100.0, -0.03352538314417667}, {6.0, 300.0, 0.03133294616872464}, {6.0, 1000.0, -0.02469801093420244}, {7.0, 1.0E-8, 1.5500992063492067E-62}, {7.0, 3.16227766016838E-8, 4.901844091282828E-59}, {7.0, 1.0E-7, 1.5500992063492053E-55}, {7.0, 3.16227766016838E-7, 4.901844091282813E-52}, {7.0, 1.0E-6, 1.5500992063491574E-48}, {7.0, 3.16227766016838E-6, 4.9018440912812965E-45}, {7.0, 1.0E-5, 1.5500992063443631E-41}, {7.0, 3.16227766016838E-5, 4.90184409112965E-38}, {7.0, 1.0E-4, 1.550099205864801E-34}, {7.0, 3.16227766016838E-4, 4.901844075964569E-31}, {7.0, 0.001, 1.5500991579086071E-27}, {7.0, 0.00316227766016838, 4.901842559456765E-24}, {7.0, 0.01, 1.5500943622959147E-20}, {7.0, 0.0316227766016838, 4.901690910782493E-17}, {7.0, 0.1, 1.5496148676202282E-13}, {7.0, 0.316227766016838, 4.886547086143151E-10}, {7.0, 1.0, 1.5023258174368078E-6}, {7.0, 2.0, 1.7494407486827416E-4}, {7.0, 3.0, 0.002547294451804693}, {7.0, 4.0, 0.01517606942205845}, {7.0, 5.0, 0.053376410155890716}, {7.0, 6.0, 0.1295866518414807}, {7.0, 7.0, 0.23358356950569606}, {7.0, 7.5, 0.2831509378972553}, {7.0, 7.6, 0.29188362991799727}, {7.0, 7.7, 0.3000622608521364}, {7.0, 7.8, 0.30761787492543297}, {7.0, 7.9, 0.31448237452220684}, {7.0, 8.0, 0.32058907797982633}, {7.0, 8.1, 0.325873288560999}, {7.0, 8.2, 0.33027286989028454}, {7.0, 8.3, 0.3337288229203384}, {7.0, 8.4, 0.336185859314339}, {7.0, 8.5, 0.3375929659967613}, {7.0, 9.0, 0.32746087924245293}, {7.0, 10.0, 0.21671091768505152}, {7.0, 11.0, 0.018376032647858614}, {7.0, 12.0, -0.17025380412720803}, {7.0, 13.0, -0.2405709495861605}, {7.0, 14.0, -0.15080491964126708}, {7.0, 15.0, 0.03446365541895916}, {7.0, 16.0, 0.18251382371420197}, {7.0, 17.0, 0.18754906067690702}, {7.0, 18.0, 0.05139927598217523}, {7.0, 19.0, -0.11647797453873988}, {7.0, 20.0, -0.18422139772059445}, {7.0, 30.0, 0.14518518957232832}, {7.0, 100.0, 0.07017269098721272}, {7.0, 300.0, 0.03444694619617606}, {7.0, 1000.0, -0.005321783076443615}, {8.0, 1.0E-8, 9.688120039682541E-72}, {8.0, 3.16227766016838E-8, 9.688120039682536E-68}, {8.0, 1.0E-7, 9.688120039682534E-64}, {8.0, 3.16227766016838E-7, 9.688120039682509E-60}, {8.0, 1.0E-6, 9.688120039682267E-56}, {8.0, 3.16227766016838E-6, 9.688120039679845E-52}, {8.0, 1.0E-5, 9.688120039655635E-48}, {8.0, 3.16227766016838E-5, 9.68812003941343E-44}, {8.0, 1.0E-4, 9.6881200369914E-40}, {8.0, 3.16227766016838E-4, 9.688120012771098E-36}, {8.0, 0.001, 9.688119770568101E-32}, {8.0, 0.00316227766016838, 9.688117348538422E-28}, {8.0, 0.01, 9.688093128271625E-24}, {8.0, 0.0316227766016838, 9.687850928600891E-20}, {8.0, 0.1, 9.685429231594653E-16}, {8.0, 0.316227766016838, 9.661242208962509E-12}, {8.0, 1.0, 9.4223441726045E-8}, {8.0, 2.0, 2.2179552287925905E-5}, {8.0, 3.0, 4.934417762088348E-4}, {8.0, 4.0, 0.004028667820819004}, {8.0, 5.0, 0.018405216654802003}, {8.0, 6.0, 0.056531990932461786}, {8.0, 7.0, 0.12797053402821254}, {8.0, 7.5, 0.17440789049583127}, {8.0, 7.6, 0.18416820334778525}, {8.0, 7.7, 0.19399825367215817}, {8.0, 7.8, 0.2038542511129527}, {8.0, 7.9, 0.21368958021206302}, {8.0, 8.0, 0.22345498635110295}, {8.0, 8.1, 0.233098793515506}, {8.0, 8.2, 0.24256715346663235}, {8.0, 8.3, 0.2518043255905202}, {8.0, 8.4, 0.26075298636958133}, {8.0, 8.5, 0.2693545670990819}, {8.0, 9.0, 0.3050670722530001}, {8.0, 10.0, 0.3178541268438573}, {8.0, 11.0, 0.2249716787894999}, {8.0, 12.0, 0.04509532908045724}, {8.0, 13.0, -0.14104573511639804}, {8.0, 14.0, -0.23197310306707983}, {8.0, 15.0, -0.17398365908895733}, {8.0, 16.0, -0.007021141952960652}, {8.0, 17.0, 0.1537368341734622}, {8.0, 18.0, 0.19593344884811412}, {8.0, 19.0, 0.09294129556816545}, {8.0, 20.0, -0.07386892884075034}, {8.0, 30.0, 0.06289085331645855}, {8.0, 100.0, 0.04334955988238645}, {8.0, 300.0, -0.02972542201290309}, {8.0, 1000.0, 0.02462350597113223}, {9.0, 1.0E-8, 5.382288910934745E-81}, {9.0, 3.16227766016838E-8, 1.702029198362093E-76}, {9.0, 1.0E-7, 5.38228891093474E-72}, {9.0, 3.16227766016838E-7, 1.702029198362089E-67}, {9.0, 1.0E-6, 5.382288910934608E-63}, {9.0, 3.16227766016838E-6, 1.7020291983616675E-58}, {9.0, 1.0E-5, 5.382288910921292E-54}, {9.0, 3.16227766016838E-5, 1.702029198319544E-49}, {9.0, 1.0E-4, 5.382288909589175E-45}, {9.0, 3.16227766016838E-4, 1.702029194107021E-40}, {9.0, 0.001, 5.382288776377523E-36}, {9.0, 0.00316227766016838, 1.7020287728548428E-31}, {9.0, 0.01, 5.382275455227759E-27}, {9.0, 0.0316227766016838, 1.7019866481156612E-22}, {9.0, 0.1, 5.380943491602331E-18}, {9.0, 0.316227766016838, 1.6977789573201714E-13}, {9.0, 1.0, 5.249250179911876E-9}, {9.0, 2.0, 2.492343435133064E-6}, {9.0, 3.0, 8.439502130909177E-5}, {9.0, 4.0, 9.38601861217564E-4}, {9.0, 5.0, 0.005520283139475687}, {9.0, 6.0, 0.021165323978417364}, {9.0, 7.0, 0.05892050827307543}, {9.0, 7.5, 0.08891922849385146}, {9.0, 7.6, 0.09583890344576113}, {9.0, 7.7, 0.10305099353156888}, {9.0, 7.8, 0.11054469146011103}, {9.0, 7.9, 0.11830664869209805}, {9.0, 8.0, 0.1263208947223796}, {9.0, 8.1, 0.13456877270419806}, {9.0, 8.2, 0.14302889297143717}, {9.0, 8.3, 0.1516771059288571}, {9.0, 8.4, 0.16048649567533976}, {9.0, 8.5, 0.1694273956015105}, {9.0, 9.0, 0.21488058254065845}, {9.0, 10.0, 0.29185568526512007}, {9.0, 11.0, 0.3088555001368685}, {9.0, 12.0, 0.23038090956781773}, {9.0, 13.0, 0.06697619867367062}, {9.0, 14.0, -0.11430719814968128}, {9.0, 15.0, -0.220046225113847}, {9.0, 16.0, -0.1895349656671626}, {9.0, 17.0, -0.04285556969011908}, {9.0, 18.0, 0.12276378966059287}, {9.0, 19.0, 0.19474432870140554}, {9.0, 20.0, 0.12512625464799415}, {9.0, 30.0, -0.11164340113688376}, {9.0, 100.0, -0.06323676140603089}, {9.0, 300.0, -0.03603230203686422}, {9.0, 1000.0, 0.005715759171981731}, {10.0, 1.0E-8, 2.6911444554673727E-90}, {10.0, 3.16227766016838E-8, 2.691144455467371E-85}, {10.0, 1.0E-7, 2.6911444554673704E-80}, {10.0, 3.16227766016838E-7, 2.6911444554673646E-75}, {10.0, 1.0E-6, 2.6911444554673096E-70}, {10.0, 3.16227766016838E-6, 2.691144455466759E-65}, {10.0, 1.0E-5, 2.6911444554612583E-60}, {10.0, 3.16227766016838E-5, 2.6911444554062113E-55}, {10.0, 1.0E-4, 2.6911444548557503E-50}, {10.0, 3.16227766016838E-4, 2.6911444493511355E-45}, {10.0, 0.001, 2.691144394304999E-40}, {10.0, 0.00316227766016838, 2.6911438438436965E-35}, {10.0, 0.01, 2.6911383392363445E-30}, {10.0, 0.0316227766016838, 2.691083293730486E-25}, {10.0, 0.1, 2.6905328954342172E-20}, {10.0, 0.316227766016838, 2.685034585067004E-15}, {10.0, 1.0, 2.630615123687453E-10}, {10.0, 2.0, 2.515386282716737E-7}, {10.0, 3.0, 1.2928351645715883E-5}, {10.0, 4.0, 1.9504055466003448E-4}, {10.0, 5.0, 0.0014678026473104744}, {10.0, 6.0, 0.006963981002790316}, {10.0, 7.0, 0.02353934438826714}, {10.0, 7.5, 0.03899825788941221}, {10.0, 7.6, 0.04281867323428058}, {10.0, 7.7, 0.046900172765275555}, {10.0, 7.8, 0.051248883025765066}, {10.0, 7.9, 0.0558698725041097}, {10.0, 8.0, 0.060767026774251165}, {10.0, 8.1, 0.06594292360493414}, {10.0, 8.2, 0.07139870915359563}, {10.0, 8.3, 0.07713397642386874}, {10.0, 8.4, 0.08314664722043245}, {10.0, 8.5, 0.08943285888058738}, {10.0, 9.0, 0.12469409282831673}, {10.0, 10.0, 0.20748610663335887}, {10.0, 11.0, 0.2804282305253759}, {10.0, 12.0, 0.3004760352712693}, {10.0, 13.0, 0.2337820102030189}, {10.0, 14.0, 0.08500670544606101}, {10.0, 15.0, -0.09007181104765906}, {10.0, 16.0, -0.20620569442259729}, {10.0, 17.0, -0.19911331972770593}, {10.0, 18.0, -0.07316965918752125}, {10.0, 19.0, 0.09155333162263977}, {10.0, 20.0, 0.1864825580239451}, {10.0, 30.0, -0.12987689399858882}, {10.0, 100.0, -0.05473217693547201}, {10.0, 300.0, 0.027563483890691236}, {10.0, 1000.0, -0.02452062230603656}, {30.0, 1.0E-8, 3.5110745847373345E-282}, {30.0, 3.16227766016838E-8, 3.5110745847373277E-267}, {30.0, 1.0E-7, 3.511074584737327E-252}, {30.0, 3.16227766016838E-7, 3.5110745847373245E-237}, {30.0, 1.0E-6, 3.511074584737299E-222}, {30.0, 3.16227766016838E-6, 3.5110745847370446E-207}, {30.0, 1.0E-5, 3.5110745847345094E-192}, {30.0, 3.16227766016838E-5, 3.5110745847090236E-177}, {30.0, 1.0E-4, 3.5110745844541855E-162}, {30.0, 3.16227766016838E-4, 3.511074581905823E-147}, {30.0, 0.001, 3.511074556422216E-132}, {30.0, 0.00316227766016838, 3.511074301586169E-117}, {30.0, 0.01, 3.5110717532266786E-102}, {30.0, 0.0316227766016838, 3.5110462697303107E-87}, {30.0, 0.1, 3.5107914446214636E-72}, {30.0, 0.316227766016838, 3.5082441787554764E-57}, {30.0, 1.0, 3.4828697942514824E-42}, {30.0, 2.0, 3.650256266474096E-33}, {30.0, 3.0, 6.722339938146329E-28}, {30.0, 4.0, 3.5570357020361055E-24}, {30.0, 5.0, 2.671177278250799E-21}, {30.0, 6.0, 5.798468365278571E-19}, {30.0, 7.0, 5.3172607940100176E-17}, {30.0, 7.5, 3.9705139492720915E-16}, {30.0, 7.6, 5.835120623696973E-16}, {30.0, 7.7, 8.529504695436501E-16}, {30.0, 7.8, 1.2403000998620314E-15}, {30.0, 7.9, 1.7943809060373146E-15}, {30.0, 8.0, 2.5830997825663086E-15}, {30.0, 8.1, 3.70048108189465E-15}, {30.0, 8.2, 5.276130435058983E-15}, {30.0, 8.3, 7.487920729153833E-15}, {30.0, 8.4, 1.0578927729828908E-14}, {30.0, 8.5, 1.4879948521285088E-14}, {30.0, 9.0, 7.692156469335498E-14}, {30.0, 10.0, 1.5510960782574666E-12}, {30.0, 11.0, 2.2735383676316185E-11}, {30.0, 12.0, 2.5522590430344177E-10}, {30.0, 13.0, 2.2828783239868354E-9}, {30.0, 14.0, 1.6775399533577878E-8}, {30.0, 15.0, 1.0374710201078721E-7}, {30.0, 16.0, 5.505238664307638E-7}, {30.0, 17.0, 2.5460065118711982E-6}, {30.0, 18.0, 1.0393652487465729E-5}, {30.0, 19.0, 3.7849142225173516E-5}, {30.0, 20.0, 1.240153636035433E-4}, {30.0, 30.0, 0.14393585001030734}, {30.0, 100.0, 0.08146012958117221}, {30.0, 300.0, -0.029514887800373372}, {30.0, 1000.0, -0.020271896981075843}, {100.0, 1.0E-8, 0.0}, {100.0, 3.16227766016838E-8, 0.0}, {100.0, 1.0E-7, 0.0}, {100.0, 3.16227766016838E-7, 0.0}, {100.0, 1.0E-6, 0.0}, {100.0, 3.16227766016838E-6, 0.0}, {100.0, 1.0E-5, 0.0}, {100.0, 3.16227766016838E-5, 0.0}, {100.0, 1.0E-4, 0.0}, {100.0, 3.16227766016838E-4, 0.0}, {100.0, 0.001, 0.0}, {100.0, 0.00316227766016838, 0.0}, {100.0, 0.01, 0.0}, {100.0, 0.0316227766016838, 0.0}, {100.0, 0.1, 8.452516535121789E-289}, {100.0, 0.316227766016838, 8.450633755975275E-239}, {100.0, 1.0, 8.431828789626707E-189}, {100.0, 2.0, 1.0609531124391719E-158}, {100.0, 3.0, 4.2603601811326214E-141}, {100.0, 4.0, 1.305547836452272E-128}, {100.0, 5.0, 6.267789395541875E-119}, {100.0, 6.0, 5.051325854150702E-111}, {100.0, 7.0, 2.4215591572118172E-104}, {100.0, 7.5, 2.358380045556859E-101}, {100.0, 7.6, 8.835297945847411E-101}, {100.0, 7.7, 3.25302512075143E-100}, {100.0, 7.8, 1.1776236102157394E-99}, {100.0, 7.9, 4.193388542712002E-99}, {100.0, 8.0, 1.4694094093552327E-98}, {100.0, 8.1, 5.0688862671208964E-98}, {100.0, 8.2, 1.7220304874625644E-97}, {100.0, 8.3, 5.763524830094244E-97}, {100.0, 8.4, 1.901118824223632E-96}, {100.0, 8.5, 6.182346491260611E-96}, {100.0, 9.0, 1.8369106342703587E-93}, {100.0, 10.0, 6.59731606415538E-89}, {100.0, 11.0, 8.629790133173882E-85}, {100.0, 12.0, 4.898370445750788E-81}, {100.0, 13.0, 1.3781127544328333E-77}, {100.0, 14.0, 2.131075190314612E-74}, {100.0, 15.0, 1.9660095611249536E-71}, {100.0, 16.0, 1.1559435724349576E-68}, {100.0, 17.0, 4.5721265690179434E-66}, {100.0, 18.0, 1.2722370655682103E-63}, {100.0, 19.0, 2.5856336302772507E-61}, {100.0, 20.0, 3.9617550943362507E-59}, {100.0, 30.0, 4.5788015281752424E-42}, {100.0, 100.0, 0.0963666732958615}, {100.0, 300.0, -0.0144912270647857}, {100.0, 1000.0, 0.011676135007802558}, {300.0, 1.0E-8, 0.0}, {300.0, 3.16227766016838E-8, 0.0}, {300.0, 1.0E-7, 0.0}, {300.0, 3.16227766016838E-7, 0.0}, {300.0, 1.0E-6, 0.0}, {300.0, 3.16227766016838E-6, 0.0}, {300.0, 1.0E-5, 0.0}, {300.0, 3.16227766016838E-5, 0.0}, {300.0, 1.0E-4, 0.0}, {300.0, 3.16227766016838E-4, 0.0}, {300.0, 0.001, 0.0}, {300.0, 0.00316227766016838, 0.0}, {300.0, 0.01, 0.0}, {300.0, 0.0316227766016838, 0.0}, {300.0, 0.1, 0.0}, {300.0, 0.316227766016838, 0.0}, {300.0, 1.0, 0.0}, {300.0, 2.0, 0.0}, {300.0, 3.0, 0.0}, {300.0, 4.0, 0.0}, {300.0, 5.0, 0.0}, {300.0, 6.0, 0.0}, {300.0, 7.0, 0.0}, {300.0, 7.5, 0.0}, {300.0, 7.6, 0.0}, {300.0, 7.7, 0.0}, {300.0, 7.8, 0.0}, {300.0, 7.9, 0.0}, {300.0, 8.0, 0.0}, {300.0, 8.1, 0.0}, {300.0, 8.2, 0.0}, {300.0, 8.3, 0.0}, {300.0, 8.4, 0.0}, {300.0, 8.5, 0.0}, {300.0, 9.0, 0.0}, {300.0, 10.0, 0.0}, {300.0, 11.0, 0.0}, {300.0, 12.0, 0.0}, {300.0, 13.0, 0.0}, {300.0, 14.0, 0.0}, {300.0, 15.0, 0.0}, {300.0, 16.0, 0.0}, {300.0, 17.0, 0.0}, {300.0, 18.0, 0.0}, {300.0, 19.0, 0.0}, {300.0, 20.0, 0.0}, {300.0, 30.0, 1.0388021531643496E-262}, {300.0, 100.0, 3.520366621846933E-109}, {300.0, 300.0, 0.06681839812897998}, {300.0, 1000.0, 4.6782803879124945E-4}};

    @Test
    public void testBesselJ() {
        double tol = 1.0E-15;
        for (int i = 0; i < BESSEL_J_REF.length; ++i) {
            double[] data = BESSEL_J_REF[i];
            double order = data[0];
            double x = data[1];
            double expected = data[2];
            double actual = BesselJ.value((double)order, (double)x);
            String msg = "" + order + " @ " + x;
            Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)1.0E-15);
        }
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testIAEBadOrder() {
        BesselJ.value((double)-1.0, (double)1.0);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testIAEBadArgument() {
        BesselJ.value((double)1.0, (double)100000.0);
    }
}

