/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fraction;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.fraction.FractionConversionException;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class BigFractionTest {
    private void assertFraction(int expectedNumerator, int expectedDenominator, BigFraction actual) {
        Assert.assertEquals((long)expectedNumerator, (long)actual.getNumeratorAsInt());
        Assert.assertEquals((long)expectedDenominator, (long)actual.getDenominatorAsInt());
    }

    private void assertFraction(long expectedNumerator, long expectedDenominator, BigFraction actual) {
        Assert.assertEquals((long)expectedNumerator, (long)actual.getNumeratorAsLong());
        Assert.assertEquals((long)expectedDenominator, (long)actual.getDenominatorAsLong());
    }

    @Test
    public void testConstructor() {
        this.assertFraction(0, 1, new BigFraction(0, 1));
        this.assertFraction(0, 1, new BigFraction(0L, 2L));
        this.assertFraction(0, 1, new BigFraction(0, -1));
        this.assertFraction(1, 2, new BigFraction(1, 2));
        this.assertFraction(1, 2, new BigFraction(2, 4));
        this.assertFraction(-1, 2, new BigFraction(-1, 2));
        this.assertFraction(-1, 2, new BigFraction(1, -2));
        this.assertFraction(-1, 2, new BigFraction(-2, 4));
        this.assertFraction(-1, 2, new BigFraction(2, -4));
        this.assertFraction(11, 1, new BigFraction(11));
        this.assertFraction(11, 1, new BigFraction(11L));
        this.assertFraction(11, 1, new BigFraction(new BigInteger("11")));
        this.assertFraction(0, 1, new BigFraction(1.0E-14, 1.0E-5, 100));
        this.assertFraction(2, 5, new BigFraction(0.40000000000001, 1.0E-5, 100));
        this.assertFraction(15, 1, new BigFraction(15.0000000000001, 1.0E-5, 100));
        Assert.assertEquals((double)1.0E-14, (double)new BigFraction(1.0E-14).doubleValue(), (double)0.0);
        Assert.assertEquals((double)0.40000000000001, (double)new BigFraction(0.40000000000001).doubleValue(), (double)0.0);
        Assert.assertEquals((double)15.0000000000001, (double)new BigFraction(15.0000000000001).doubleValue(), (double)0.0);
        this.assertFraction(3602879701896487L, 0x20000000000000L, new BigFraction(0.40000000000001));
        this.assertFraction(1055531162664967L, 0x400000000000L, new BigFraction(15.0000000000001));
        try {
            new BigFraction(null, BigInteger.ONE);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            new BigFraction(BigInteger.ONE, null);
            Assert.fail((String)"Expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            new BigFraction(BigInteger.ONE, BigInteger.ZERO);
            Assert.fail((String)"Expecting ZeroException");
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
        try {
            new BigFraction(4.294967294E9, 1.0E-5, 100000);
            Assert.fail((String)"Expecting FractionConversionException");
        }
        catch (FractionConversionException fractionConversionException) {
            // empty catch block
        }
    }

    @Test(expected=ConvergenceException.class)
    public void testGoldenRatio() {
        new BigFraction((1.0 + FastMath.sqrt((double)5.0)) / 2.0, 1.0E-12, 25);
    }

    @Test
    public void testDoubleConstructor() throws ConvergenceException {
        this.assertFraction(1, 2, new BigFraction(0.5, 1.0E-5, 100));
        this.assertFraction(1, 3, new BigFraction(0.3333333333333333, 1.0E-5, 100));
        this.assertFraction(2, 3, new BigFraction(0.6666666666666666, 1.0E-5, 100));
        this.assertFraction(1, 4, new BigFraction(0.25, 1.0E-5, 100));
        this.assertFraction(3, 4, new BigFraction(0.75, 1.0E-5, 100));
        this.assertFraction(1, 5, new BigFraction(0.2, 1.0E-5, 100));
        this.assertFraction(2, 5, new BigFraction(0.4, 1.0E-5, 100));
        this.assertFraction(3, 5, new BigFraction(0.6, 1.0E-5, 100));
        this.assertFraction(4, 5, new BigFraction(0.8, 1.0E-5, 100));
        this.assertFraction(1, 6, new BigFraction(0.16666666666666666, 1.0E-5, 100));
        this.assertFraction(5, 6, new BigFraction(0.8333333333333334, 1.0E-5, 100));
        this.assertFraction(1, 7, new BigFraction(0.14285714285714285, 1.0E-5, 100));
        this.assertFraction(2, 7, new BigFraction(0.2857142857142857, 1.0E-5, 100));
        this.assertFraction(3, 7, new BigFraction(0.42857142857142855, 1.0E-5, 100));
        this.assertFraction(4, 7, new BigFraction(0.5714285714285714, 1.0E-5, 100));
        this.assertFraction(5, 7, new BigFraction(0.7142857142857143, 1.0E-5, 100));
        this.assertFraction(6, 7, new BigFraction(0.8571428571428571, 1.0E-5, 100));
        this.assertFraction(1, 8, new BigFraction(0.125, 1.0E-5, 100));
        this.assertFraction(3, 8, new BigFraction(0.375, 1.0E-5, 100));
        this.assertFraction(5, 8, new BigFraction(0.625, 1.0E-5, 100));
        this.assertFraction(7, 8, new BigFraction(0.875, 1.0E-5, 100));
        this.assertFraction(1, 9, new BigFraction(0.1111111111111111, 1.0E-5, 100));
        this.assertFraction(2, 9, new BigFraction(0.2222222222222222, 1.0E-5, 100));
        this.assertFraction(4, 9, new BigFraction(0.4444444444444444, 1.0E-5, 100));
        this.assertFraction(5, 9, new BigFraction(0.5555555555555556, 1.0E-5, 100));
        this.assertFraction(7, 9, new BigFraction(0.7777777777777778, 1.0E-5, 100));
        this.assertFraction(8, 9, new BigFraction(0.8888888888888888, 1.0E-5, 100));
        this.assertFraction(1, 10, new BigFraction(0.1, 1.0E-5, 100));
        this.assertFraction(3, 10, new BigFraction(0.3, 1.0E-5, 100));
        this.assertFraction(7, 10, new BigFraction(0.7, 1.0E-5, 100));
        this.assertFraction(9, 10, new BigFraction(0.9, 1.0E-5, 100));
        this.assertFraction(1, 11, new BigFraction(0.09090909090909091, 1.0E-5, 100));
        this.assertFraction(2, 11, new BigFraction(0.18181818181818182, 1.0E-5, 100));
        this.assertFraction(3, 11, new BigFraction(0.2727272727272727, 1.0E-5, 100));
        this.assertFraction(4, 11, new BigFraction(0.36363636363636365, 1.0E-5, 100));
        this.assertFraction(5, 11, new BigFraction(0.45454545454545453, 1.0E-5, 100));
        this.assertFraction(6, 11, new BigFraction(0.5454545454545454, 1.0E-5, 100));
        this.assertFraction(7, 11, new BigFraction(0.6363636363636364, 1.0E-5, 100));
        this.assertFraction(8, 11, new BigFraction(0.7272727272727273, 1.0E-5, 100));
        this.assertFraction(9, 11, new BigFraction(0.8181818181818182, 1.0E-5, 100));
        this.assertFraction(10, 11, new BigFraction(0.9090909090909091, 1.0E-5, 100));
    }

    @Test
    public void testDigitLimitConstructor() throws ConvergenceException {
        this.assertFraction(2, 5, new BigFraction(0.4, 9));
        this.assertFraction(2, 5, new BigFraction(0.4, 99));
        this.assertFraction(2, 5, new BigFraction(0.4, 999));
        this.assertFraction(3, 5, new BigFraction(0.6152, 9));
        this.assertFraction(8, 13, new BigFraction(0.6152, 99));
        this.assertFraction(510, 829, new BigFraction(0.6152, 999));
        this.assertFraction(769, 1250, new BigFraction(0.6152, 9999));
        this.assertFraction(1, 2, new BigFraction(0.5000000001, 10));
    }

    @Test(expected=FractionConversionException.class)
    public void testPositiveValueOverflow() {
        this.assertFraction(10000000000L, 1L, new BigFraction(1.0E10, 1000));
    }

    @Test(expected=FractionConversionException.class)
    public void testNegativeValueOverflow() {
        this.assertFraction(-10000000000L, 1L, new BigFraction(-1.0E10, 1000));
    }

    @Test
    public void testEpsilonLimitConstructor() throws ConvergenceException {
        this.assertFraction(2, 5, new BigFraction(0.4, 1.0E-5, 100));
        this.assertFraction(3, 5, new BigFraction(0.6152, 0.02, 100));
        this.assertFraction(8, 13, new BigFraction(0.6152, 0.001, 100));
        this.assertFraction(251, 408, new BigFraction(0.6152, 1.0E-4, 100));
        this.assertFraction(251, 408, new BigFraction(0.6152, 1.0E-5, 100));
        this.assertFraction(510, 829, new BigFraction(0.6152, 1.0E-6, 100));
        this.assertFraction(769, 1250, new BigFraction(0.6152, 1.0E-7, 100));
    }

    @Test
    public void testCompareTo() {
        BigFraction first = new BigFraction(1, 2);
        BigFraction second = new BigFraction(1, 3);
        BigFraction third = new BigFraction(1, 2);
        Assert.assertEquals((long)0L, (long)first.compareTo(first));
        Assert.assertEquals((long)0L, (long)first.compareTo(third));
        Assert.assertEquals((long)1L, (long)first.compareTo(second));
        Assert.assertEquals((long)-1L, (long)second.compareTo(first));
        BigFraction pi1 = new BigFraction(1068966896, 340262731);
        BigFraction pi2 = new BigFraction(411557987, 131002976);
        Assert.assertEquals((long)-1L, (long)pi1.compareTo(pi2));
        Assert.assertEquals((long)1L, (long)pi2.compareTo(pi1));
        Assert.assertEquals((double)0.0, (double)(pi1.doubleValue() - pi2.doubleValue()), (double)1.0E-20);
    }

    @Test
    public void testDoubleValue() {
        BigFraction first = new BigFraction(1, 2);
        BigFraction second = new BigFraction(1, 3);
        Assert.assertEquals((double)0.5, (double)first.doubleValue(), (double)0.0);
        Assert.assertEquals((double)0.3333333333333333, (double)second.doubleValue(), (double)0.0);
    }

    @Test
    public void testDoubleValueForLargeNumeratorAndDenominator() {
        BigInteger pow400 = BigInteger.TEN.pow(400);
        BigInteger pow401 = BigInteger.TEN.pow(401);
        BigInteger two = new BigInteger("2");
        BigFraction large = new BigFraction(pow401.add(BigInteger.ONE), pow400.multiply(two));
        Assert.assertEquals((double)5.0, (double)large.doubleValue(), (double)1.0E-15);
    }

    @Test
    public void testFloatValueForLargeNumeratorAndDenominator() {
        BigInteger pow400 = BigInteger.TEN.pow(400);
        BigInteger pow401 = BigInteger.TEN.pow(401);
        BigInteger two = new BigInteger("2");
        BigFraction large = new BigFraction(pow401.add(BigInteger.ONE), pow400.multiply(two));
        Assert.assertEquals((double)5.0, (double)large.floatValue(), (double)1.0E-15);
    }

    @Test
    public void testFloatValue() {
        BigFraction first = new BigFraction(1, 2);
        BigFraction second = new BigFraction(1, 3);
        Assert.assertEquals((float)0.5f, (float)first.floatValue(), (float)0.0f);
        Assert.assertEquals((float)0.33333334f, (float)second.floatValue(), (float)0.0f);
    }

    @Test
    public void testIntValue() {
        BigFraction first = new BigFraction(1, 2);
        BigFraction second = new BigFraction(3, 2);
        Assert.assertEquals((long)0L, (long)first.intValue());
        Assert.assertEquals((long)1L, (long)second.intValue());
    }

    @Test
    public void testLongValue() {
        BigFraction first = new BigFraction(1, 2);
        BigFraction second = new BigFraction(3, 2);
        Assert.assertEquals((long)0L, (long)first.longValue());
        Assert.assertEquals((long)1L, (long)second.longValue());
    }

    @Test
    public void testConstructorDouble() {
        this.assertFraction(1, 2, new BigFraction(0.5));
        this.assertFraction(0x15555555555555L, 0x40000000000000L, new BigFraction(0.3333333333333333));
        this.assertFraction(6124895493223875L, 0x80000000000000L, new BigFraction(0.17));
        this.assertFraction(1784551352345559L, 0x2000000000000L, new BigFraction(3.17));
        this.assertFraction(-1, 2, new BigFraction(-0.5));
        this.assertFraction(-6004799503160661L, 0x40000000000000L, new BigFraction(-0.3333333333333333));
        this.assertFraction(-6124895493223875L, 0x80000000000000L, new BigFraction(-0.17));
        this.assertFraction(-1784551352345559L, 0x2000000000000L, new BigFraction(-3.17));
        for (double v : new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}) {
            try {
                new BigFraction(v);
                Assert.fail((String)"Expecting IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)1L, (long)new BigFraction(Double.MAX_VALUE).getDenominatorAsLong());
        Assert.assertEquals((long)1L, (long)new BigFraction(Double.longBitsToDouble(0x10000000000000L)).getNumeratorAsLong());
        Assert.assertEquals((long)1L, (long)new BigFraction(Double.MIN_VALUE).getNumeratorAsLong());
    }

    @Test
    public void testAbs() {
        BigFraction a = new BigFraction(10, 21);
        BigFraction b = new BigFraction(-10, 21);
        BigFraction c = new BigFraction(10, -21);
        this.assertFraction(10, 21, a.abs());
        this.assertFraction(10, 21, b.abs());
        this.assertFraction(10, 21, c.abs());
    }

    @Test
    public void testReciprocal() {
        BigFraction f = null;
        f = new BigFraction(50, 75);
        f = f.reciprocal();
        Assert.assertEquals((long)3L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)2L, (long)f.getDenominatorAsInt());
        f = new BigFraction(4, 3);
        f = f.reciprocal();
        Assert.assertEquals((long)3L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)4L, (long)f.getDenominatorAsInt());
        f = new BigFraction(-15, 47);
        f = f.reciprocal();
        Assert.assertEquals((long)-47L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)15L, (long)f.getDenominatorAsInt());
        f = new BigFraction(0, 3);
        try {
            f = f.reciprocal();
            Assert.fail((String)"expecting ZeroException");
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
        f = new BigFraction(Integer.MAX_VALUE, 1);
        f = f.reciprocal();
        Assert.assertEquals((long)1L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominatorAsInt());
    }

    @Test
    public void testNegate() {
        BigFraction f = null;
        f = new BigFraction(50, 75);
        f = f.negate();
        Assert.assertEquals((long)-2L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)3L, (long)f.getDenominatorAsInt());
        f = new BigFraction(-50, 75);
        f = f.negate();
        Assert.assertEquals((long)2L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)3L, (long)f.getDenominatorAsInt());
        f = new BigFraction(0x7FFFFFFE, Integer.MAX_VALUE);
        f = f.negate();
        Assert.assertEquals((long)-2147483646L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominatorAsInt());
    }

    @Test
    public void testAdd() {
        BigFraction a = new BigFraction(1, 2);
        BigFraction b = new BigFraction(2, 3);
        this.assertFraction(1, 1, a.add(a));
        this.assertFraction(7, 6, a.add(b));
        this.assertFraction(7, 6, b.add(a));
        this.assertFraction(4, 3, b.add(b));
        BigFraction f1 = new BigFraction(0x7FFFFFFE, 1);
        BigFraction f2 = BigFraction.ONE;
        BigFraction f = f1.add(f2);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(-1, 676);
        f2 = new BigFraction(-2, 442);
        f = f1.add(f2);
        Assert.assertEquals((long)11492L, (long)f.getDenominatorAsInt());
        Assert.assertEquals((long)-69L, (long)f.getNumeratorAsInt());
        try {
            f.add((BigFraction)null);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        f1 = new BigFraction(1, 98304);
        f2 = new BigFraction(1, 59049);
        f = f1.add(f2);
        Assert.assertEquals((long)52451L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1934917632L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(Integer.MIN_VALUE, 3);
        f2 = new BigFraction(1, 3);
        f = f1.add(f2);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)3L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(0x7FFFFFFE, 1);
        f = f1.add(BigInteger.ONE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f = f.add(BigInteger.ZERO);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(0x7FFFFFFE, 1);
        f = f1.add(1);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f = f.add(0);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(0x7FFFFFFE, 1);
        f = f1.add(1L);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f = f.add(0L);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
    }

    @Test
    public void testDivide() {
        BigFraction a = new BigFraction(1, 2);
        BigFraction b = new BigFraction(2, 3);
        this.assertFraction(1, 1, a.divide(a));
        this.assertFraction(3, 4, a.divide(b));
        this.assertFraction(4, 3, b.divide(a));
        this.assertFraction(1, 1, b.divide(b));
        BigFraction f1 = new BigFraction(3, 5);
        BigFraction f2 = BigFraction.ZERO;
        try {
            f1.divide(f2);
            Assert.fail((String)"expecting MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        f1 = new BigFraction(0, 5);
        f2 = new BigFraction(2, 7);
        BigFraction f = f1.divide(f2);
        Assert.assertSame((Object)BigFraction.ZERO, (Object)f);
        f1 = new BigFraction(2, 7);
        f2 = BigFraction.ONE;
        f = f1.divide(f2);
        Assert.assertEquals((long)2L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)7L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(1, Integer.MAX_VALUE);
        f = f1.divide(f1);
        Assert.assertEquals((long)1L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        f2 = new BigFraction(1, Integer.MAX_VALUE);
        f = f1.divide(f2);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        try {
            f.divide((BigFraction)null);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        f1 = new BigFraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        f = f1.divide(BigInteger.valueOf(Integer.MIN_VALUE));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominatorAsInt());
        Assert.assertEquals((long)1L, (long)f.getNumeratorAsInt());
        f1 = new BigFraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        f = f1.divide(Integer.MIN_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominatorAsInt());
        Assert.assertEquals((long)1L, (long)f.getNumeratorAsInt());
        f1 = new BigFraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        f = f1.divide(Integer.MIN_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)f.getDenominatorAsInt());
        Assert.assertEquals((long)1L, (long)f.getNumeratorAsInt());
    }

    @Test
    public void testMultiply() {
        BigFraction a = new BigFraction(1, 2);
        BigFraction b = new BigFraction(2, 3);
        this.assertFraction(1, 4, a.multiply(a));
        this.assertFraction(1, 3, a.multiply(b));
        this.assertFraction(1, 3, b.multiply(a));
        this.assertFraction(4, 9, b.multiply(b));
        BigFraction f1 = new BigFraction(Integer.MAX_VALUE, 1);
        BigFraction f2 = new BigFraction(Integer.MIN_VALUE, Integer.MAX_VALUE);
        BigFraction f = f1.multiply(f2);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f = f2.multiply(Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        f = f2.multiply(Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
        try {
            f.multiply((BigFraction)null);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSubtract() {
        BigFraction a = new BigFraction(1, 2);
        BigFraction b = new BigFraction(2, 3);
        this.assertFraction(0, 1, a.subtract(a));
        this.assertFraction(-1, 6, a.subtract(b));
        this.assertFraction(1, 6, b.subtract(a));
        this.assertFraction(0, 1, b.subtract(b));
        BigFraction f = new BigFraction(1, 1);
        try {
            f.subtract((BigFraction)null);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        BigFraction f1 = new BigFraction(1, 98304);
        BigFraction f2 = new BigFraction(1, 59049);
        f = f1.subtract(f2);
        Assert.assertEquals((long)-13085L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1934917632L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(Integer.MIN_VALUE, 3);
        f2 = new BigFraction(1, 3).negate();
        f = f1.subtract(f2);
        Assert.assertEquals((long)-2147483647L, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)3L, (long)f.getDenominatorAsInt());
        f1 = new BigFraction(Integer.MAX_VALUE, 1);
        f2 = BigFraction.ONE;
        f = f1.subtract(f2);
        Assert.assertEquals((long)0x7FFFFFFEL, (long)f.getNumeratorAsInt());
        Assert.assertEquals((long)1L, (long)f.getDenominatorAsInt());
    }

    @Test
    public void testBigDecimalValue() {
        Assert.assertEquals((Object)new BigDecimal(0.5), (Object)new BigFraction(1, 2).bigDecimalValue());
        Assert.assertEquals((Object)new BigDecimal("0.0003"), (Object)new BigFraction(3, 10000).bigDecimalValue());
        Assert.assertEquals((Object)new BigDecimal("0"), (Object)new BigFraction(1, 3).bigDecimalValue(1));
        Assert.assertEquals((Object)new BigDecimal("0.333"), (Object)new BigFraction(1, 3).bigDecimalValue(3, 1));
    }

    @Test
    public void testEqualsAndHashCode() {
        BigFraction zero = new BigFraction(0, 1);
        Object nullFraction = null;
        Assert.assertTrue((boolean)zero.equals((Object)zero));
        Assert.assertFalse((boolean)zero.equals(nullFraction));
        Assert.assertFalse((boolean)zero.equals((Object)0.0));
        BigFraction zero2 = new BigFraction(0, 2);
        Assert.assertTrue((boolean)zero.equals((Object)zero2));
        Assert.assertEquals((long)zero.hashCode(), (long)zero2.hashCode());
        BigFraction one = new BigFraction(1, 1);
        Assert.assertFalse((one.equals((Object)zero) || zero.equals((Object)one) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)one.equals((Object)BigFraction.ONE));
    }

    @Test
    public void testGetReducedFraction() {
        BigFraction threeFourths = new BigFraction(3, 4);
        Assert.assertTrue((boolean)threeFourths.equals((Object)BigFraction.getReducedFraction((int)6, (int)8)));
        Assert.assertTrue((boolean)BigFraction.ZERO.equals((Object)BigFraction.getReducedFraction((int)0, (int)-1)));
        try {
            BigFraction.getReducedFraction((int)1, (int)0);
            Assert.fail((String)"expecting ZeroException");
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
        Assert.assertEquals((long)BigFraction.getReducedFraction((int)2, (int)Integer.MIN_VALUE).getNumeratorAsInt(), (long)-1L);
        Assert.assertEquals((long)BigFraction.getReducedFraction((int)1, (int)-1).getNumeratorAsInt(), (long)-1L);
    }

    @Test
    public void testPercentage() {
        Assert.assertEquals((double)50.0, (double)new BigFraction(1, 2).percentageValue(), (double)1.0E-15);
    }

    @Test
    public void testPow() {
        Assert.assertEquals((Object)new BigFraction(8192, 1594323), (Object)new BigFraction(2, 3).pow(13));
        Assert.assertEquals((Object)new BigFraction(8192, 1594323), (Object)new BigFraction(2, 3).pow(13L));
        Assert.assertEquals((Object)new BigFraction(8192, 1594323), (Object)new BigFraction(2, 3).pow(BigInteger.valueOf(13L)));
        Assert.assertEquals((Object)BigFraction.ONE, (Object)new BigFraction(2, 3).pow(0));
        Assert.assertEquals((Object)BigFraction.ONE, (Object)new BigFraction(2, 3).pow(0L));
        Assert.assertEquals((Object)BigFraction.ONE, (Object)new BigFraction(2, 3).pow(BigInteger.valueOf(0L)));
        Assert.assertEquals((Object)new BigFraction(1594323, 8192), (Object)new BigFraction(2, 3).pow(-13));
        Assert.assertEquals((Object)new BigFraction(1594323, 8192), (Object)new BigFraction(2, 3).pow(-13L));
        Assert.assertEquals((Object)new BigFraction(1594323, 8192), (Object)new BigFraction(2, 3).pow(BigInteger.valueOf(-13L)));
    }

    @Test
    public void testMath340() {
        BigFraction fractionA = new BigFraction(0.00131);
        BigFraction fractionB = new BigFraction(0.37).reciprocal();
        BigFraction errorResult = fractionA.multiply(fractionB);
        BigFraction correctResult = new BigFraction(fractionA.getNumerator().multiply(fractionB.getNumerator()), fractionA.getDenominator().multiply(fractionB.getDenominator()));
        Assert.assertEquals((Object)correctResult, (Object)errorResult);
    }

    @Test
    public void testSerial() throws FractionConversionException {
        BigFraction[] fractions;
        for (BigFraction fraction : fractions = new BigFraction[]{new BigFraction(3, 4), BigFraction.ONE, BigFraction.ZERO, new BigFraction(17), new BigFraction(Math.PI, 1000), new BigFraction(-5, 2)}) {
            Assert.assertEquals((Object)fraction, (Object)TestUtils.serializeAndRecover(fraction));
        }
    }
}

