/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.util;

import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.remote.util.RemoteCacheRequestFactory;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs3.auxiliary.remote.value.RemoteRequestType;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class RemoteCacheRequestFactoryUnitTest
extends TestCase {
    public void testCreateGetRequest_Normal() {
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        RemoteCacheRequest result = RemoteCacheRequestFactory.createGetRequest((String)"test", (Object)key, (long)2L);
        RemoteCacheRequestFactoryUnitTest.assertNotNull((String)"Should have a result", (Object)result);
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong cacheName", (String)"test", (String)result.getCacheName());
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong type", (Object)RemoteRequestType.GET, (Object)result.getRequestType());
    }

    public void testCreateGetMatchingRequest_Normal() {
        String cacheName = "test";
        String pattern = "pattern";
        long requesterId = 2L;
        RemoteCacheRequest result = RemoteCacheRequestFactory.createGetMatchingRequest((String)"test", (String)"pattern", (long)2L);
        RemoteCacheRequestFactoryUnitTest.assertNotNull((String)"Should have a result", (Object)result);
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong cacheName", (String)"test", (String)result.getCacheName());
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong type", (Object)RemoteRequestType.GET_MATCHING, (Object)result.getRequestType());
    }

    public void testCreateGetMultipleRequest_Normal() {
        String cacheName = "test";
        Set keys = Collections.emptySet();
        long requesterId = 2L;
        RemoteCacheRequest result = RemoteCacheRequestFactory.createGetMultipleRequest((String)"test", keys, (long)2L);
        RemoteCacheRequestFactoryUnitTest.assertNotNull((String)"Should have a result", (Object)result);
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong cacheName", (String)"test", (String)result.getCacheName());
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong type", (Object)RemoteRequestType.GET_MULTIPLE, (Object)result.getRequestType());
    }

    public void testCreateRemoveRequest_Normal() {
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        RemoteCacheRequest result = RemoteCacheRequestFactory.createRemoveRequest((String)"test", (Object)key, (long)2L);
        RemoteCacheRequestFactoryUnitTest.assertNotNull((String)"Should have a result", (Object)result);
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong cacheName", (String)"test", (String)result.getCacheName());
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong type", (Object)RemoteRequestType.REMOVE, (Object)result.getRequestType());
    }

    public void testCreateRemoveAllRequest_Normal() {
        String cacheName = "test";
        long requesterId = 2L;
        RemoteCacheRequest result = RemoteCacheRequestFactory.createRemoveAllRequest((String)"test", (long)2L);
        RemoteCacheRequestFactoryUnitTest.assertNotNull((String)"Should have a result", (Object)result);
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong cacheName", (String)"test", (String)result.getCacheName());
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong type", (Object)RemoteRequestType.REMOVE_ALL, (Object)result.getRequestType());
    }

    public void testCreateUpdateRequest_Normal() {
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        CacheElement element = new CacheElement("test", (Object)key, null);
        RemoteCacheRequest result = RemoteCacheRequestFactory.createUpdateRequest((ICacheElement)element, (long)2L);
        RemoteCacheRequestFactoryUnitTest.assertNotNull((String)"Should have a result", (Object)result);
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong cacheName", (String)"test", (String)result.getCacheName());
        RemoteCacheRequestFactoryUnitTest.assertEquals((String)"Wrong type", (Object)RemoteRequestType.UPDATE, (Object)result.getRequestType());
    }
}

