/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.util.stream.Stream;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.RoundtripBase;
import org.apache.commons.imaging.roundtrip.TestImages;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GrayscaleRountripTest
extends RoundtripBase {
    public static BufferedImage[] images = new BufferedImage[]{TestImages.createArgbBitmapImage(1, 1), TestImages.createArgbGrayscaleImage(2, 2), TestImages.createArgbGrayscaleImage(10, 10), TestImages.createArgbGrayscaleImage(300, 300), TestImages.createGrayscaleGrayscaleImage(1, 1), TestImages.createGrayscaleGrayscaleImage(2, 2), TestImages.createGrayscaleGrayscaleImage(10, 10), TestImages.createGrayscaleGrayscaleImage(300, 300)};

    public static Stream<Arguments> testGrayscaleRoundtrip() {
        return GrayscaleRountripTest.createRoundtripArguments(images);
    }

    @ParameterizedTest
    @MethodSource
    public void testGrayscaleRoundtrip(BufferedImage testImage, FormatInfo formatInfo) throws Exception {
        boolean imageExact = formatInfo.colorSupport != 3;
        this.roundtrip(formatInfo, testImage, "gray", imageExact);
    }
}

