/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.nio.charset.Charset;
import org.apache.commons.geometry.io.core.GeometryFormat;
import org.apache.commons.geometry.io.core.input.GeometryInput;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.euclidean.threed.AbstractBoundaryReadHandler3D;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.GeometryFormat3D;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlConstants;
import org.apache.commons.geometry.io.euclidean.threed.stl.StlFacetDefinitionReaders;

public class StlBoundaryReadHandler3D
extends AbstractBoundaryReadHandler3D {
    private Charset defaultCharset = StlConstants.DEFAULT_CHARSET;

    public GeometryFormat getFormat() {
        return GeometryFormat3D.STL;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(Charset charset) {
        this.defaultCharset = charset;
    }

    @Override
    public FacetDefinitionReader facetDefinitionReader(GeometryInput in) {
        Charset inputCharset = in.getCharset() != null ? in.getCharset() : this.defaultCharset;
        return (FacetDefinitionReader)GeometryIOUtils.tryApplyCloseable(inputStream -> StlFacetDefinitionReaders.create(inputStream, inputCharset), () -> ((GeometryInput)in).getInputStream());
    }
}

