/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.oned;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.spherical.oned.CutAngle;
import org.apache.commons.geometry.spherical.oned.CutAngles;
import org.apache.commons.geometry.spherical.oned.Point1S;
import org.apache.commons.geometry.spherical.oned.RegionBSPTree1S;
import org.apache.commons.numbers.core.Precision;

public class AngularInterval
implements HyperplaneBoundedRegion<Point1S> {
    private final CutAngle minBoundary;
    private final CutAngle maxBoundary;
    private final Point1S midpoint;

    private AngularInterval(CutAngle minBoundary, CutAngle maxBoundary) {
        this.minBoundary = minBoundary;
        this.maxBoundary = maxBoundary;
        this.midpoint = minBoundary != null && maxBoundary != null ? Point1S.of(0.5 * (minBoundary.getAzimuth() + maxBoundary.getAzimuth())) : null;
    }

    public double getMin() {
        return this.minBoundary != null ? this.minBoundary.getAzimuth() : 0.0;
    }

    public CutAngle getMinBoundary() {
        return this.minBoundary;
    }

    public double getMax() {
        return this.maxBoundary != null ? this.maxBoundary.getAzimuth() : Math.PI * 2;
    }

    public CutAngle getMaxBoundary() {
        return this.maxBoundary;
    }

    public Point1S getMidPoint() {
        return this.midpoint;
    }

    public boolean isFull() {
        return this.minBoundary == null;
    }

    public boolean isEmpty() {
        return false;
    }

    public double getSize() {
        return this.getMax() - this.getMin();
    }

    public double getBoundarySize() {
        return 0.0;
    }

    public Point1S getCentroid() {
        return this.getMidPoint();
    }

    public RegionLocation classify(Point1S pt) {
        if (!this.isFull()) {
            HyperplaneLocation minLoc = this.minBoundary.classify(pt);
            HyperplaneLocation maxLoc = this.maxBoundary.classify(pt);
            boolean wraps = this.wrapsZero();
            if (!wraps && (minLoc == HyperplaneLocation.PLUS || maxLoc == HyperplaneLocation.PLUS) || wraps && minLoc == HyperplaneLocation.PLUS && maxLoc == HyperplaneLocation.PLUS) {
                return RegionLocation.OUTSIDE;
            }
            if (minLoc == HyperplaneLocation.ON || maxLoc == HyperplaneLocation.ON) {
                return RegionLocation.BOUNDARY;
            }
        }
        return RegionLocation.INSIDE;
    }

    public Point1S project(Point1S pt) {
        if (!this.isFull()) {
            double maxDist;
            double minDist = this.minBoundary.getPoint().distance(pt);
            return minDist <= (maxDist = this.maxBoundary.getPoint().distance(pt)) ? this.minBoundary.getPoint() : this.maxBoundary.getPoint();
        }
        return null;
    }

    public boolean wrapsZero() {
        if (!this.isFull()) {
            double minNormAz = this.minBoundary.getPoint().getNormalizedAzimuth();
            double maxNormAz = this.maxBoundary.getPoint().getNormalizedAzimuth();
            return maxNormAz < minNormAz;
        }
        return false;
    }

    public AngularInterval transform(Transform<Point1S> transform) {
        return AngularInterval.transform(this, transform, AngularInterval::of);
    }

    public Split<RegionBSPTree1S> split(Hyperplane<Point1S> splitter) {
        return this.toTree().split(splitter);
    }

    public RegionBSPTree1S toTree() {
        return RegionBSPTree1S.fromInterval(this);
    }

    public List<Convex> toConvex() {
        if (AngularInterval.isConvex(this.minBoundary, this.maxBoundary)) {
            return Collections.singletonList(new Convex(this.minBoundary, this.maxBoundary));
        }
        CutAngle midPos = CutAngles.createPositiveFacing(this.midpoint, this.minBoundary.getPrecision());
        CutAngle midNeg = CutAngles.createNegativeFacing(this.midpoint, this.maxBoundary.getPrecision());
        return Arrays.asList(new Convex(this.minBoundary, midPos), new Convex(midNeg, this.maxBoundary));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[min= ").append(this.getMin()).append(", max= ").append(this.getMax()).append(']');
        return sb.toString();
    }

    public static Convex full() {
        return Convex.FULL;
    }

    public static AngularInterval of(double min, double max, Precision.DoubleEquivalence precision) {
        return AngularInterval.of(Point1S.of(min), Point1S.of(max), precision);
    }

    public static AngularInterval of(Point1S min, Point1S max, Precision.DoubleEquivalence precision) {
        return AngularInterval.createInterval(min, max, precision, AngularInterval::new, Convex.FULL);
    }

    public static AngularInterval of(CutAngle a, CutAngle b) {
        return AngularInterval.createInterval(a, b, AngularInterval::new, Convex.FULL);
    }

    private static <T extends AngularInterval> T createInterval(Point1S min, Point1S max, Precision.DoubleEquivalence precision, BiFunction<? super CutAngle, ? super CutAngle, T> factory, T fullSpace) {
        AngularInterval.validateIntervalValues(min, max);
        if (min.eq(max, precision)) {
            return fullSpace;
        }
        Point1S adjustedMax = max.above(min);
        return (T)((AngularInterval)factory.apply(CutAngles.createNegativeFacing(min, precision), CutAngles.createPositiveFacing(adjustedMax, precision)));
    }

    private static <T extends AngularInterval> T createInterval(CutAngle a, CutAngle b, BiFunction<? super CutAngle, ? super CutAngle, T> factory, T fullSpace) {
        Point1S aPoint = a.getPoint();
        Point1S bPoint = b.getPoint();
        AngularInterval.validateIntervalValues(aPoint, bPoint);
        if (a.isPositiveFacing() == b.isPositiveFacing() || aPoint.eq(bPoint, a.getPrecision()) || bPoint.eq(aPoint, b.getPrecision())) {
            return fullSpace;
        }
        CutAngle min = a.isPositiveFacing() ? b : a;
        CutAngle max = a.isPositiveFacing() ? a : b;
        CutAngle adjustedMax = CutAngles.createPositiveFacing(max.getPoint().above(min.getPoint()), max.getPrecision());
        return (T)((AngularInterval)factory.apply(min, adjustedMax));
    }

    private static void validateIntervalValues(Point1S a, Point1S b) {
        if (!a.isFinite() || !b.isFinite()) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid angular interval: [{0}, {1}]", a.getAzimuth(), b.getAzimuth()));
        }
    }

    private static boolean isConvex(CutAngle min, CutAngle max) {
        if (min != null && max != null) {
            double dist = max.getAzimuth() - min.getAzimuth();
            Precision.DoubleEquivalence precision = min.getPrecision();
            return precision.lte(dist, Math.PI);
        }
        return true;
    }

    private static <T extends AngularInterval> T transform(T interval, Transform<Point1S> transform, BiFunction<? super CutAngle, ? super CutAngle, T> factory) {
        if (!interval.isFull()) {
            CutAngle tMin = interval.getMinBoundary().transform(transform);
            CutAngle tMax = interval.getMaxBoundary().transform(transform);
            return (T)((AngularInterval)factory.apply(tMin, tMax));
        }
        return interval;
    }

    public static final class Convex
    extends AngularInterval {
        private static final Convex FULL = new Convex(null, null);

        private Convex(CutAngle minBoundary, CutAngle maxBoundary) {
            super(minBoundary, maxBoundary);
            if (!AngularInterval.isConvex(minBoundary, maxBoundary)) {
                throw new IllegalArgumentException(MessageFormat.format("Interval is not convex: [{0}, {1}]", minBoundary.getAzimuth(), maxBoundary.getAzimuth()));
            }
        }

        @Override
        public List<Convex> toConvex() {
            return Collections.singletonList(this);
        }

        @Override
        public Convex transform(Transform<Point1S> transform) {
            return (Convex)AngularInterval.transform((AngularInterval)this, (Transform<Point1S>)transform, Convex::of);
        }

        public Split<Convex> splitDiameter(CutAngle splitter) {
            CutAngle negCut;
            CutAngle posCut;
            CutAngle opposite = CutAngles.fromPointAndDirection(splitter.getPoint().antipodal(), !splitter.isPositiveFacing(), splitter.getPrecision());
            if (this.isFull()) {
                Convex minus = Convex.of(splitter, opposite);
                Convex plus = Convex.of(splitter.reverse(), opposite.reverse());
                return new Split((Object)minus, (Object)plus);
            }
            CutAngle minBoundary = this.getMinBoundary();
            CutAngle maxBoundary = this.getMaxBoundary();
            Point1S posPole = Point1S.of(splitter.getPoint().getAzimuth() + 1.5707963267948966);
            int minLoc = minBoundary.getPrecision().compare(1.5707963267948966, posPole.distance(minBoundary.getPoint()));
            int maxLoc = maxBoundary.getPrecision().compare(1.5707963267948966, posPole.distance(maxBoundary.getPoint()));
            boolean positiveFacingSplit = splitter.isPositiveFacing();
            Convex pos = null;
            Convex neg = null;
            if (minLoc > 0) {
                if (maxLoc >= 0) {
                    pos = this;
                } else {
                    posCut = positiveFacingSplit ? opposite.reverse() : opposite;
                    pos = Convex.of(minBoundary, posCut);
                    negCut = positiveFacingSplit ? opposite : opposite.reverse();
                    neg = Convex.of(negCut, maxBoundary);
                }
            } else if (minLoc < 0) {
                if (maxLoc <= 0) {
                    neg = this;
                } else {
                    posCut = positiveFacingSplit ? splitter.reverse() : splitter;
                    pos = Convex.of(maxBoundary, posCut);
                    negCut = positiveFacingSplit ? splitter : splitter.reverse();
                    neg = Convex.of(negCut, minBoundary);
                }
            } else if (splitter.getPoint().distance(minBoundary.getPoint()) < 1.5707963267948966) {
                pos = this;
            } else {
                neg = this;
            }
            Convex minus = positiveFacingSplit ? neg : pos;
            Convex plus = positiveFacingSplit ? pos : neg;
            return new Split((Object)minus, (Object)plus);
        }

        public static Convex of(double min, double max, Precision.DoubleEquivalence precision) {
            return Convex.of(Point1S.of(min), Point1S.of(max), precision);
        }

        public static Convex of(Point1S min, Point1S max, Precision.DoubleEquivalence precision) {
            return (Convex)AngularInterval.createInterval(min, max, precision, Convex::new, (AngularInterval)Convex.FULL);
        }

        public static Convex of(CutAngle a, CutAngle b) {
            return (Convex)AngularInterval.createInterval(a, b, Convex::new, (AngularInterval)Convex.FULL);
        }
    }
}

