/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.twod.shape;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.euclidean.twod.AffineTransformMatrix2D;
import org.apache.commons.geometry.euclidean.twod.ConvexArea;
import org.apache.commons.geometry.euclidean.twod.LineConvexSubset;
import org.apache.commons.geometry.euclidean.twod.Lines;
import org.apache.commons.geometry.euclidean.twod.Segment;
import org.apache.commons.geometry.euclidean.twod.Vector2D;
import org.apache.commons.geometry.euclidean.twod.rotation.Rotation2D;
import org.apache.commons.numbers.core.Precision;

public final class Parallelogram
extends ConvexArea {
    private static final List<Vector2D> UNIT_SQUARE_VERTICES = Arrays.asList(Vector2D.of(-0.5, -0.5), Vector2D.of(0.5, -0.5), Vector2D.of(0.5, 0.5), Vector2D.of(-0.5, 0.5));

    private Parallelogram(List<LineConvexSubset> boundaries) {
        super(boundaries);
    }

    public static Parallelogram unitSquare(Precision.DoubleEquivalence precision) {
        return Parallelogram.fromTransformedUnitSquare(AffineTransformMatrix2D.identity(), precision);
    }

    public static Parallelogram axisAligned(Vector2D a, Vector2D b, Precision.DoubleEquivalence precision) {
        double minX = Math.min(a.getX(), b.getX());
        double maxX = Math.max(a.getX(), b.getX());
        double minY = Math.min(a.getY(), b.getY());
        double maxY = Math.max(a.getY(), b.getY());
        double xDelta = maxX - minX;
        double yDelta = maxY - minY;
        Vector2D scale = Vector2D.of(xDelta, yDelta);
        Vector2D position = Vector2D.of(0.5 * xDelta + minX, 0.5 * yDelta + minY);
        return Parallelogram.builder(precision).setScale(scale).setPosition(position).build();
    }

    public static Parallelogram fromTransformedUnitSquare(Transform<Vector2D> transform, Precision.DoubleEquivalence precision) {
        List vertices = UNIT_SQUARE_VERTICES.stream().map(transform).collect(Collectors.toList());
        int len = vertices.size();
        boolean preservesOrientation = transform.preservesOrientation();
        ArrayList<LineConvexSubset> boundaries = new ArrayList<LineConvexSubset>(UNIT_SQUARE_VERTICES.size());
        for (int i = 0; i < len; ++i) {
            Vector2D p1;
            Vector2D p0 = (Vector2D)vertices.get(i);
            if (precision.eqZero(p0.distance(p1 = (Vector2D)vertices.get((i + 1) % len)))) {
                throw new IllegalArgumentException(MessageFormat.format("Parallelogram has zero size: vertices {0} and {1} are equivalent", p0, p1));
            }
            Segment boundary = preservesOrientation ? Lines.segmentFromPoints(p0, p1, precision) : Lines.segmentFromPoints(p1, p0, precision);
            boundaries.add(boundary);
        }
        return new Parallelogram(boundaries);
    }

    public static Builder builder(Precision.DoubleEquivalence precision) {
        return new Builder(precision);
    }

    public static final class Builder {
        private Vector2D scale = Vector2D.of(1.0, 1.0);
        private Rotation2D rotation = Rotation2D.identity();
        private Vector2D position = Vector2D.ZERO;
        private final Precision.DoubleEquivalence precision;

        private Builder(Precision.DoubleEquivalence precision) {
            this.precision = precision;
        }

        public Builder setPosition(Vector2D pos) {
            this.position = pos;
            return this;
        }

        public Builder setScale(Vector2D scaleFactors) {
            this.scale = scaleFactors;
            return this;
        }

        public Builder setScale(double x, double y) {
            return this.setScale(Vector2D.of(x, y));
        }

        public Builder setScale(double scaleFactor) {
            return this.setScale(scaleFactor, scaleFactor);
        }

        public Builder setRotation(Rotation2D rot) {
            this.rotation = rot;
            return this;
        }

        public Builder setXDirection(Vector2D xDirection) {
            return this.setRotation(Rotation2D.createVectorRotation(Vector2D.Unit.PLUS_X, xDirection));
        }

        public Builder setYDirection(Vector2D yDirection) {
            return this.setRotation(Rotation2D.createVectorRotation(Vector2D.Unit.PLUS_Y, yDirection));
        }

        public Parallelogram build() {
            AffineTransformMatrix2D transform = AffineTransformMatrix2D.createScale(this.scale).rotate(this.rotation).translate(this.position);
            return Parallelogram.fromTransformedUnitSquare(transform, this.precision);
        }
    }
}

