/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.mail2.javax.resolver.DataSourceBaseResolver;

public class DataSourceClassPathResolver
extends DataSourceBaseResolver {
    private final String classPathBase;

    public DataSourceClassPathResolver() {
        this("/");
    }

    public DataSourceClassPathResolver(String classPathBase) {
        this(classPathBase, false);
    }

    public DataSourceClassPathResolver(String classPathBase, boolean lenient) {
        super(lenient);
        this.classPathBase = classPathBase.endsWith("/") ? classPathBase : classPathBase + "/";
    }

    public String getClassPathBase() {
        return this.classPathBase;
    }

    private String getResourceName(String resourceLocation) {
        return (this.getClassPathBase() + resourceLocation).replace("//", "/");
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        return this.resolve(resourceLocation, this.isLenient());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        try {
            if (this.isCid(resourceLocation)) return null;
            if (this.isHttpUrl(resourceLocation)) return null;
            String mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(resourceLocation);
            String resourceName = this.getResourceName(resourceLocation);
            try (InputStream inputStream = DataSourceClassPathResolver.class.getResourceAsStream(resourceName);){
                if (inputStream == null) {
                    if (!isLenient) throw new IOException("The following class path resource was not found : " + resourceLocation);
                    DataSource dataSource = null;
                    return dataSource;
                }
                ByteArrayDataSource ds = new ByteArrayDataSource(inputStream, mimeType);
                URL resource = DataSourceClassPathResolver.class.getResource(resourceName);
                if (resource != null) {
                    ds.setName(resource.toString());
                    ByteArrayDataSource byteArrayDataSource = ds;
                    return byteArrayDataSource;
                }
                if (!isLenient) throw new IOException("The following class path resource was not found : " + resourceName);
                DataSource dataSource = null;
                return dataSource;
            }
        }
        catch (IOException e) {
            if (!isLenient) throw e;
            return null;
        }
    }
}

