/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.javax.resolver;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.mail2.javax.DataSourceResolver;
import org.apache.commons.mail2.javax.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail2.javax.resolver.DataSourceClassPathResolver;
import org.apache.commons.mail2.javax.resolver.DataSourceCompositeResolver;
import org.apache.commons.mail2.javax.resolver.DataSourceUrlResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DataSourceCompositeResolverTest
extends AbstractDataSourceResolverTest {
    private DataSourceResolver[] dataSourceResolvers;
    private DataSourceResolver[] dataSourceResolversMissing;

    @BeforeEach
    public void setUp() throws Exception {
        DataSourceUrlResolver urlResolver = new DataSourceUrlResolver(new URL("https://www.apache.org"), false);
        DataSourceUrlResolver urlResolverMissing = new DataSourceUrlResolver(new URL("https://does.not.exist"), false);
        DataSourceClassPathResolver classPathResolver = new DataSourceClassPathResolver("/images", false);
        this.dataSourceResolvers = new DataSourceResolver[]{urlResolver, classPathResolver};
        this.dataSourceResolversMissing = new DataSourceResolver[]{urlResolverMissing};
    }

    @Test
    public void testExternalModification() throws Exception {
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(this.dataSourceResolvers, true);
        DataSourceResolver[] arr = dataSourceResolver.getDataSourceResolvers();
        arr[0] = null;
        DataSourceResolver[] arr2 = dataSourceResolver.getDataSourceResolvers();
        Assertions.assertNotNull((Object)arr2[0]);
    }

    @Test
    public void testResolvingFilesLenient() throws Exception {
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(this.dataSourceResolvers, true);
        Assertions.assertTrue((this.toByteArray(dataSourceResolver.resolve("/images/feather-small.gif")).length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.toByteArray(dataSourceResolver.resolve("/contentTypeTest.gif")).length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testResolvingFilesNonLenient() {
        DataSourceCompositeResolver dataSourceResolver = new DataSourceCompositeResolver(this.dataSourceResolversMissing, false);
        Assertions.assertThrows(IOException.class, () -> DataSourceCompositeResolverTest.lambda$testResolvingFilesNonLenient$0((DataSourceResolver)dataSourceResolver));
    }

    private static /* synthetic */ void lambda$testResolvingFilesNonLenient$0(DataSourceResolver dataSourceResolver) throws Throwable {
        dataSourceResolver.resolve("./image/does-not-exist.gif");
    }
}

