/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.jakarta.resolver;

import java.io.IOException;
import org.apache.commons.mail2.jakarta.DataSourceResolver;
import org.apache.commons.mail2.jakarta.resolver.AbstractDataSourceResolverTest;
import org.apache.commons.mail2.jakarta.resolver.DataSourceClassPathResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataSourceClassPathResolverTest
extends AbstractDataSourceResolverTest {
    @Test
    public void testResolvingClassPathLenient() throws Exception {
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", true);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("images/asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("./images/asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("/images/asf_logo_wide.gif")).length);
        Assertions.assertNull((Object)dataSourceResolver.resolve("/asf_logo_wide.gif"));
        dataSourceResolver = new DataSourceClassPathResolver("/images", true);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("./asf_logo_wide.gif")).length);
        Assertions.assertEquals((int)5866, (int)this.toByteArray(dataSourceResolver.resolve("/asf_logo_wide.gif")).length);
        Assertions.assertNull((Object)dataSourceResolver.resolve("./images/asf_logo_wide.gif"));
    }

    @Test
    public void testResolvingClassPathNonLenient() throws Exception {
        DataSourceClassPathResolver dataSourceResolver = new DataSourceClassPathResolver("/", false);
        Assertions.assertNotNull((Object)dataSourceResolver.resolve("images/asf_logo_wide.gif"));
        Assertions.assertThrows(IOException.class, () -> DataSourceClassPathResolverTest.lambda$testResolvingClassPathNonLenient$0((DataSourceResolver)dataSourceResolver));
    }

    private static /* synthetic */ void lambda$testResolvingClassPathNonLenient$0(DataSourceResolver dataSourceResolver) throws Throwable {
        dataSourceResolver.resolve("asf_logo_wide.gif");
    }
}

