/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.BaseTestCase;
import org.apache.commons.dbutils.handlers.MapListHandler;

public class MapListHandlerTest
extends BaseTestCase {
    public void testEmptyResultSetHandle() throws SQLException {
        MapListHandler h = new MapListHandler();
        List results = (List)h.handle(this.emptyResultSet);
        MapListHandlerTest.assertNotNull((Object)results);
        MapListHandlerTest.assertTrue((boolean)results.isEmpty());
    }

    public void testHandle() throws SQLException {
        MapListHandler h = new MapListHandler();
        List results = (List)h.handle(this.rs);
        MapListHandlerTest.assertNotNull((Object)results);
        MapListHandlerTest.assertEquals((int)ROWS, (int)results.size());
        Iterator iter = results.iterator();
        MapListHandlerTest.assertTrue((boolean)iter.hasNext());
        Map row = (Map)iter.next();
        MapListHandlerTest.assertEquals((int)COLS, (int)row.size());
        MapListHandlerTest.assertEquals((Object)"1", row.get("one"));
        MapListHandlerTest.assertEquals((Object)"2", row.get("TWO"));
        MapListHandlerTest.assertEquals((Object)"THREE", row.get("Three"));
        MapListHandlerTest.assertTrue((boolean)iter.hasNext());
        row = (Map)iter.next();
        MapListHandlerTest.assertEquals((int)COLS, (int)row.size());
        MapListHandlerTest.assertEquals((Object)"4", row.get("one"));
        MapListHandlerTest.assertEquals((Object)"5", row.get("TWO"));
        MapListHandlerTest.assertEquals((Object)"SIX", row.get("Three"));
        MapListHandlerTest.assertFalse((boolean)iter.hasNext());
    }
}

